<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\GeneralDaily;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\ReciptVoucherDetails;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class Collection_DelegatesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $from = $request->get('From');
        $to = $request->get('To');
        $Delegate = $request->get('Delegate');

        $DBBEFORE=0;
        $CRBEFORE=0;
        $DBTOTAL=0;
        $CRTOTAL=0;
        $DBBALANCE=0;
        $CRBALANCE=0;


        $DebBef =0;


        $CredBef =0;

        $TotalDeb =GeneralDaily::where('Account',$this->Account)
            ->get()->sum('Debitor_Coin');


        $TotalCred =GeneralDaily::where('Account',$this->Account)
            ->get()->sum('Creditor_Coin');

        $lq=GeneralDaily::where('Account',$this->Account)
            ->latest('id')->first();

        $lb =Sales::where('Client',$this->Account)->where('Edit',0)->where('Delete',0)
            ->latest('id')->first();

        if(!empty($lq)){
            $LastQeed=$lq->Date;
        }else{
            $LastQeed=0;
        }
        if(!empty($lb)){
            $LastBill=$lb->Date;
        }else{
            $LastBill=0;
        }

        $account=$this->Account;
        $last =ReciptVoucherDetails::whereRelation('RV_ID', function ($query) use ($Delegate) {

            return $query->where('Collector',$Delegate);
        })


            ->when(!empty($account), function ($query) use ($account)  {
                return $query->where('Account',$account);

            })

            ->latest('id')->first();

        if(!empty($last)){
            $LastRecipt=$last->RV_ID()->first()->Date;
        }else{
            $LastRecipt=0;
        }


        $x= $TotalDeb  - $TotalCred  ;


        if($x < 0){

            $y=0;
            $z=abs($x);
        }else{

            $y=$x;
            $z=0;

        }

        $DBBEFORE +=$DebBef;
        $CRBEFORE +=$CredBef;
        $DBTOTAL +=$TotalDeb;
        $CRTOTAL +=$TotalCred;
        $DBBALANCE +=$y;
        $CRBALANCE +=$z;


            if(app()->getLocale() == 'ar' ){
                $xName=$this->Account()->first()->Name;

            }else{
                $xName=$this->Account()->first()->NameEn;

            }


            $data=[

                'name'=>$xName
                ,'credit_debitor'=>$y
                ,'credit_creditor'=>$z
                ,'last_jun'=>$LastQeed
                ,'last_bill'=>$LastBill
                ,'last_recipt'=>$LastRecipt

            ];


            return $data ;







    }

}
