<?php

namespace App\Http\Resources\Reports\SupplyChain;


use App\Models\AssemblyProducts;
use App\Models\ProductSales;
use App\Models\ProductsQty;
use App\Models\ProductUnits;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class BrandSalesApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $From = $request->get('From');
        $To = $request->get('To');
        $Brand = $request->get('Brand');


        $Newqty=ProductSales::
        where('Product',$this->Product)
            ->where('Product_Code',$this->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Qty');

        $Newtot=ProductSales::
        where('Product',$this->Product)
            ->where('Product_Code',$this->Product_Code)
            ->whereRelation('Sales', function ($query) use ($From,$To) {
                return $query->where('Edit',0)->where('Delete',0)-> whereBetween('Date',[$From,$To]);

            })
            ->whereRelation('Sales','Edit',0)
            ->whereRelation('Sales','Delete',0)
            ->get()->sum('Total_Net');


        $data=[

            'Code'=>$this->Product_Code
            ,'Name'=>$this->P_Ar_Name . ($this-> V_Name .'-'.  $this->VV_Name )
            ,'Unit'=>$this->Unit()->first()->Name
            ,'Qty'=>$Newqty
            ,'Price'=>$this->Price
            ,'Total'=>$Newtot



        ];

        return $data ;





    }

}
