<?php

namespace App\Http\Resources\Reports\HR;


use App\Models\DepartureEmp;
use App\Models\Employess;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class AttendenceValueReportResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $from=$request->get('from');
        $to=$request->get('to');

        $HourValue=$this->Salary / $this->Hours_Numbers;
        $Attendence=DepartureEmp::whereBetween('Date', [$from, $to])->where('Emp',$this->id)->get()->sum('Hours_Number') ;
        $DiscountLate=DepartureEmp::whereBetween('Date', [$from, $to])->where('Emp',$this->id)->get()->sum('Disc_Late') ;
        $DiscountDeparture=DepartureEmp::whereBetween('Date', [$from, $to])->where('Emp',$this->id)->get()->sum('Disc_Early') ;
        $FinValue= ( $Attendence * $HourValue)  - ( $DiscountLate + $DiscountDeparture );


        if($lang == 'ar' ){
            $Name=$this->Name;
        }else{
            $Name=$this->NameEn;

        }


        $data=[

            'name'=>$Name
            ,'hour_value'=>$HourValue
            ,'hours_numberss'=>number_format((float)$Attendence, 2, '.', '')
            ,'discount_late'=>$DiscountLate
            ,'discount_departure'=>$DiscountDeparture
            ,'financial_value'=>number_format((float)$FinValue, 2, '.', '')




        ];




        return $data ;
    }

}
