<?php

namespace App\Http\Resources\Reports\HR;


use App\Models\Employess;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class AttendenceAndDepartureReportResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $Mwzf=Employess::find($this->Emp);
        if(!empty($Mwzf)){
            $Att = new DateTime($Mwzf->Attendence);
            $AttTime = new DateTime($this->In_Time);
            $DifTimeAtt = $Att->diff($AttTime);

            $Dep = new DateTime($Mwzf->Departure);
            $DepTime = new DateTime($this->Out_Time);
            $DifTimeDep = $DepTime->diff($Dep);

            $x=$DifTimeAtt->format("%H:%I:%S");
            $y=$DifTimeDep->format("%H:%I:%S");


            $Act = new DateTime($this->In_Time);
            $ActTime = new DateTime($this->Out_Time);
            $DifAct = $ActTime->diff($Act);

            $Actual=$DifAct->format("%H:%I:%S");
        }else{
            $x=0;
            $y=0;
            $Actual= 0;
        }

        $datetime = DateTime::createFromFormat('Y-m-d', $this->Date);
        $Day=$datetime->format('l');

        if(!empty($this->Emp()->first()->Name)){
            if(app()->getLocale() == 'ar' ){
                $Name=$this->Emp()->first()->Name;
            }else{
                $Name=$this->Emp()->first()->NameEn;

            }
        }else{

            $Name='';
        }



        $data=[

            'date'=>$this->Date
            ,'day'=>$Day
            ,'month'=>$this->Month
            ,'name'=>$Name
            ,'attendence'=>$this->In_Time
            ,'attendence_late'=>$x
            ,'departure'=>$this->Out_Time
            ,'departure_early'=>$y
            ,'actual_time'=>$Actual



        ];




        return $data ;
    }

}
