<?php

namespace App\Http\Resources\Reports\CRM;


use App\Models\CommentsClients;
use App\Models\Customers;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;
class CommentsReportsApiApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        if ($lang == 'ar') {
            $name = $this->Name;
        } else {
            $name = $this->NameEn;
        }

        if (!empty($this->Governrate()->first()->Arabic_Name)) {

            if ($lang == 'ar') {
                $gov = $this->Governrate()->first()->Arabic_Name;
            } else {
                $gov = $this->Governrate()->first()->English_Name;
            }
    }else{
            $gov='';
        }


        if (!empty($this->City()->first()->Arabic_Name)) {

            if ($lang == 'ar') {
                $cit = $this->City()->first()->Arabic_Name;
            } else {
                $cit = $this->City()->first()->English_Name;
            }
        }else{
            $cit='';
        }

        if (!empty($this->Activity()->first()->Arabic_Name)) {

            if ($lang == 'ar') {
                $activity = $this->Activity()->first()->Arabic_Name;
            } else {
                $activity = $this->Activity()->first()->English_Name;
            }
        }else{
            $activity='';
        }


        $data=[

            'Client'=>$name
            ,'Governrate'=>$gov
            ,'City'=>$cit
            ,'Activity'=>$activity
            ,'Phone'=>$this->Phone
             ,'Comments'=>$this->when(!empty($this->id), function () {

                $Date=request('Date');
                $Client=request('Client');

                $Comments=CommentsClients::latest('id')

                    ->when(!empty($Date), function ($query) use ($Date){
                        $query->where('Date', $Date);
                    })

                    ->when(!empty($Client), function ($query) use ($Client){
                        $query->where('Customer', $Client);
                    })


                    ->get();

                $CustomersAddresses=CommentsClientsResources::collection($Comments);

        return $CustomersAddresses;
    }),

        ];




        return $data ;
    }

}
