<?php

namespace App\Http\Resources\Reports;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class AdminOwnerResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');

        $id_Prem=DB::table('roles')->where('name',$this->roles_name)->first();



        if($lang == 'ar'){
            $Roles=DB::table('admins')->where('admins.email',$this->email)

                ->leftJoin('roles', function ($join) {

                    $join->on('admins.roles_name', '=', 'roles.name');
                })

                ->leftJoin('role_has_permissions', function ($join) {

                    $join->on('roles.id', '=', 'role_has_permissions.role_id');
                })

                ->leftJoin('permissions', function ($join) {

                    $join->on('role_has_permissions.permission_id', '=', 'permissions.id');
                })


                ->select(
                    'permissions.name as page'
                )
                ->get();
        }else{

            $Roles=DB::table('admins')->where('admins.email',$this->email)

                ->leftJoin('roles', function ($join) {

                    $join->on('admins.roles_name', '=', 'roles.name');
                })

                ->leftJoin('role_has_permissions', function ($join) {

                    $join->on('roles.id', '=', 'role_has_permissions.role_id');
                })

                ->leftJoin('permissions', function ($join) {

                    $join->on('role_has_permissions.permission_id', '=', 'permissions.id');
                })


                ->select(
                    'permissions.nameEn as page'
                )
                ->get();

        }

        $PRem=array();
        foreach ($Roles as $index) {
            if($index->page != null) {
                array_push($PRem, $index->page);
            }
        }

        if(!empty($this->store()->first()->Name)){

            if($lang == 'ar'){
                $stoname=$this->store()->first()->Name;
            }else{

                $stoname=$this->store()->first()->NameEn;
            }
        }else{
            $stoname='';
        }



        if($lang == 'ar'){
            $NameO=$this->name;
        }else{

            $NameO=$this->nameEn;
        }



        $data=[

            'name'=>$NameO
            ,'phone'=>$this->phone
            ,'email'=>$this->email
            ,'package'=>$this->package
            ,'image'=>asset($this->image)
            ,'token'=>$this->token
            ,'premation_id'=>$id_Prem->id
            ,'premation_name'=>$this->roles_name
            ,'type'=>$this->type
            ,'prmations_pages'=>$PRem


        ];




        return $data ;
    }

}
