<?php

namespace App\Http\Resources\Reports\Accounting;


use App\Models\Employess;
use App\Models\GeneralDaily;
use App\Models\PaymentVoucherDetails;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;
use DateTime;

class IncomListReportFilterApiResources extends JsonResource
{


    public function toArray($request)
    {


        $lang = $request->header('lang', '');
        $from=$request->get('from');
        $to=$request->get('to');
        $branch=$request->get('branch');
        $safe=$request->get('safe');
        $account=$request->get('account');
        $subAccount=$request->get('subAccount');


        $subAccount=$this->id;


        $TotD=GeneralDaily::whereBetween('Date',[$from,$to])


            ->when(!empty($subAccount), function ($query) use ($subAccount) {
                return $query->where('Account', $subAccount);
            })

            ->whereIn('Type',['سند قبض','دفع شيك وارد','القيود اليومية','تحويلات الخزائن'])
            ->get()->sum('Debitor_Coin');

        $TotC=GeneralDaily::whereBetween('Date',[$from,$to])


            ->when(!empty($subAccount), function ($query) use ($subAccount) {
                return $query->where('Account', $subAccount);
            })

            ->whereIn('Type',['سند قبض','دفع شيك وارد','القيود اليومية','تحويلات الخزائن'])
            ->get()->sum('Creditor_Coin');



        $data=[

            'Name'=>$this->Name
            ,'total_debitor'=>$TotD
            ,'total_creditor'=>$TotC
            ,'details'=>$this->when(!empty($this->id), function () {

                $from=request('from');
                $to=request('to');
                $branch=request('branch');
                $safe=request('safe');
                $account=request('account');
                $subAccount=request('subAccount');




                           $lists=GeneralDaily::whereBetween('Date',[$from,$to])


                               ->when(!empty($subAccount), function ($query) use ($subAccount) {
                                   return $query->where('Account', $subAccount);
                               })

                               ->whereIn('Type',['سند قبض','دفع شيك وارد','القيود اليومية','تحويلات الخزائن'])

                               ->get();


                $dataa=IncomlistDetailsApiResources::collection($lists);


                return $dataa;
            }),

        ];




        return $data ;
    }

}
