<?php

namespace App\Http\Resources;


use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ReciptsVouchersResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');


        if($lang == 'ar' ){
            if(!empty($this->Safe()->first()->Name)){

                $safe=$this->Safe()->first()->Name;
            }


            if(!empty($this->Store()->first()->Name)){

                $store=$this->Store()->first()->Name;
            }

        }else{
            if(!empty($this->Safe()->first()->NameEn)){

                $safe=$this->Safe()->first()->NameEn;
            }


            if(!empty($this->Store()->first()->NameEn)){

                $store=$this->Store()->first()->NameEn;
            }

        }



        $data = [

            'code'=>$this->Code,
            'date'=>$this->Date,
            'safe'=>$safe,
            'store'=>$store,
            'total_creditor'=>$this->Total_Creditor,

            'details'=>$this->when(!empty($this->id), function () {

                $details=ReciptVoucherDetailsResources::collection(ReciptVoucherDetails::where('RV_ID',$this->id)->get());

                return $details;
            }),



        ];


        return $data ;
    }

}
