<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class MyMettingResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(!empty($this->Client()->first()->Activity)){

            if($lang == 'ar'){
                $activity = $this->Client()->first()->Activity()->first()->Arabic_Name ;
            }else{
                $activity = $this->Client()->first()->Activity()->first()->English_Name ;

            }
        }else{

            $activity = '';
        }

        if(!empty($this->Client()->first()->Governrate)){

            if($lang == 'ar'){
                $governrate = $this->Client()->first()->Governrate()->first()->Arabic_Name ;
            }else{
                $governrate = $this->Client()->first()->Governrate()->first()->English_Name ;

            }

        }else{

            $governrate = '';
        }

        if(!empty($this->Client()->first()->City)){

            if($lang == 'ar'){
                $city = $this->Client()->first()->City()->first()->Arabic_Name ;
            }else{
                $city = $this->Client()->first()->City()->first()->English_Name ;

            }
        }else{

            $city = '';
        }

        if(!empty($this->Client()->first()->ClientStatus)){
            if($lang == 'ar'){
                $status = $this->Client()->first()->ClientStatus()->first()->Arabic_Name ;
            }else{

                $status = $this->Client()->first()->ClientStatus()->first()->English_Name ;
            }
        }else{

            $status = '';
        }

        if(!empty($this->Type)){

            if($lang == 'ar'){
                $type = $this->Type()->first()->Arabic_Name ;
            }else{
                $type = $this->Type()->first()->English_Name ;

            }
        }else{

            $type = '';
        }


        if(!empty($this->Client()->first()->Phone)){

            $phone = $this->Client()->first()->Phone ;

        }else{

            $phone = '';
        }



        if($lang == 'ar'){
            $clientName = $this->Client()->first()->Name ;
        }else{
            $clientName = $this->Client()->first()->NameEn ;

        }



        if ($lang == 'ar') {
            $data = [

                'meet_id'=>$this->id,
                'client_id'=>$this->Client,
                'client'=>$clientName,
                'client_code'=>$this->Client()->first()->Code,
                'activity'=>$activity,
                'date'=>$this->Date,
                'time'=>$this->Time,
                'government'=>$governrate,
                'city'=>$city,
                'status'=>$status,
                'type'=>$type,
                'phone'=>$phone,
                'note'=>$this->Note,


            ];

        }else{

            $data = [

                'meet_id'=>$this->id,
                'client_id'=>$this->Client,
                'client'=>$clientName,
                'client_code'=>$this->Client()->first()->Code,
                'activity'=>$activity,
                'date'=>$this->Date,
                'time'=>$this->Time,
                'government'=>$governrate,
                'city'=>$city,
                'status'=>$status,
                'type'=>$type,
                'phone'=>$phone,
                'note'=>$this->Note,


            ];

        }
        return $data ;
    }

}
