<?php

namespace App\Http\Resources\ECom;

use App\Models\Comments;
use App\Models\Countris;
use App\Models\Customers;
use App\Models\Products;
use App\Models\ProductsVira;
use App\Models\ProductUnits;
use App\Models\Rate;
use App\Models\SubImages;
use App\Models\SubVirables;
use Illuminate\Http\Resources\Json\JsonResource;
use DateTime;
use Str;
class ProductsResources extends JsonResource
{
    public function toArray($request)
    {

        $header = $request->header('Authorization', '');
        if (Str::startsWith($header, 'Bearer ')) {
            $x=Str::substr($header, 7);
        }

        if(!empty($x)){
            $admin=Customers::where('token',$x)->first();
        }else{
            $admin=null;
        }





        $lang = $request->header('lang', '');


            $Ses = Countris::find(request('country_id'));
            $countReviews = Comments::where('Product', $this->id)->count();
            $NAMEVirable = '';
            $NAMEVirable2 = '';

            if ($this->P_Type == 'Single_Variable') {

                $v = ProductsVira::where('Product', $this->id)->orderBy('id', 'desc')->first();


                if ($lang == 'ar') {
                    $NAMEVirable = $v->V1()->first()->V_ID()->first()->Name;
                } else {
                    $NAMEVirable = $v->V1()->first()->V_ID()->first()->NameEn;

                }


            } elseif ($this->P_Type == 'Duble_Variable') {


                $v = ProductsVira::where('Product', $this->id)->orderBy('id', 'desc')->first();

                if ($lang == 'ar') {
                    $NAMEVirable = $v->V1()->first()->V_ID()->first()->Name;
                } else {
                    $NAMEVirable = $v->V1()->first()->V_ID()->first()->NameEn;
                }

                if ($lang == 'ar') {
                    $NAMEVirable2 = $v->V2()->first()->V_ID()->first()->Name;
                } else {
                    $NAMEVirable2 = $v->V2()->first()->V_ID()->first()->NameEn;
                }


            }

            if (!empty($admin)) {

                $rate = Rate::where('User', $admin->id)->where('Product', $this->id)->first();
                if (!empty($rate->Rate)) {
                    $myRAte = $rate->Rate;
                    $myRAteID = $rate->id;
                } else {
                    $myRAte = null;
                    $myRAteID = null;
                }


            } else {
                $myRAte = null;
                $myRAteID = null;
            }

            $Price = ProductUnits::where('Product', $this->id)->where('Def', 1)->first();
            if ($this->Offer == 1) {
                $Offerprice = $this->OfferPrice;
                $price = $Price->Price;
            } else {
                $price = $Price->Price;
                $Offerprice = 0;
            }

            if ($lang == 'ar') {

                $ProName = $this->P_Ar_Name;
                $Desc = strip_tags($this->Ar_Desc);
                $Spec = strip_tags($this->Ar_Spec);

            } else {

                $ProName = $this->P_En_Name;
                $Desc = strip_tags($this->En_Desc);
                $Spec = strip_tags($this->En_Spec);

            }

            $data = [

                'product_id' => $this->id,
                'product_type' => $this->P_Type,
                'product_name' => $ProName,
                'image_1' => asset($this->Image),
                'image_2' => asset($this->Image2),
                'product_price' => $price,
                'product_offer_price' => $Offerprice,
                'default_code' => $Price->Barcode,
                'symbol' => $Ses->Coin()->first()->Symbol,
                'product_rate' => $this->rate,
                'product_description' => $Desc,
                'product_spection' => $Spec,
                'user_rate_id' => $myRAteID,
                'user_rate' => $myRAte,
                'reviews_count' => $countReviews,
                'product_virable_1_name' => $NAMEVirable,
                'product_virable_2_name' => $NAMEVirable2,
                'comments' => $this->when(!empty($this->id), function () {

                    $Comments = Comments::where('Product', $this->id)->paginate(12);

                    $CommentsDet = CommentsProductsResources::collection($Comments);

                    return $CommentsDet;
                }),

                'rates' => $this->when(!empty($this->id), function () {

                    $Rates = Rate::where('Product', $this->id)->get();

                    $RateDet = RatesProductsResources::collection($Rates);

                    return $RateDet;
                }),



                'virable_one' => $this->when($this->P_Type == 'Single_Variable' or $this->P_Type == 'Duble_Variable', function () {

                    $v = ProductsVira::where('Product', $this->id)->orderBy('id', 'desc')->first();
                    $Viras = SubVirables::where('V_ID', $v->V1()->first()->V_ID)->get();

                    $ViraDet = ViraProductsResources::collection($Viras);

                    return $ViraDet;
                }),


                'virable_two' => $this->when($this->P_Type == 'Duble_Variable', function () {

                    $v = ProductsVira::where('Product', $this->id)->orderBy('id', 'desc')->first();
                    $Viras2 = SubVirables::where('V_ID', $v->V2()->first()->V_ID)->get();

                    $ViraTwoDet = ViraProductsResources::collection($Viras2);

                    return $ViraTwoDet;
                }),

            ];

            return $data;
        }

}
