<?php

namespace App\Http\Resources;


use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class CommentsClientResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');



        if($lang == 'ar'){
            $comment=$this->Comment;
            $ResName=$this->Responsible()->first()->Name;

            if(!empty($this->Type()->first()->Arabic_Name)){
                $interview=$this->Type()->first()->Arabic_Name;
            }else{
                $interview='';
            }



            if(!empty($this->Rate()->first()->Arabic_Name)){
                $Rate=$this->Rate()->first()->Arabic_Name;
            }else{
                $Rate='';
            }

        }else{
            $comment=$this->CommentEn;
            $ResName=$this->Responsible()->first()->NameEn;

            if(!empty($this->Type()->first()->English_Name)){
                $interview=$this->Type()->first()->English_Name;
            }else{
                $interview='';
            }


            if(!empty($this->Rate()->first()->English_Name)){
                $Rate=$this->Rate()->first()->English_Name;
            }else{
                $Rate='';
            }



        }




        if ($lang == 'ar') {
            $data = [

                'id'=>$this->id,
                'code'=>$this->Code,
                'date'=>$this->Date,
                'rate'=>$Rate,
                'visit_cost'=>$this->Visit_Cost,
                'note'=>$this->Note,
                'time'=>$this->Time,
                'interview_type'=>$interview,
                'comment'=>$comment,
                'responsible'=>$ResName,

            ];

        }else{

            $data = [

                'id'=>$this->id,
                'code'=>$this->Code,
                'date'=>$this->Date,
                'rate'=>$Rate,
                'visit_cost'=>$this->Visit_Cost,
                'note'=>$this->Note,
                'time'=>$this->Time,
                'interview_type'=>$interview,
                'comment'=>$comment,
                'responsible'=>$ResName,

            ];

        }
        return $data ;
    }

}
