<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SubscribesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'Date'=>'required',
            'Safe'=>'required',
            'Coin'=>'required',
            'Draw'=>'required',
            'Payment_Method'=>'required',
            'Client'=>'required',


        ];
    }


    public function messages()
    {
        return [
            'Date.required' => trans('admin.DateRequired'),
            'Safe.required' => trans('admin.SafeRequired'),
            'Coin.required' => trans('admin.CoinRequired'),
            'Draw.required' => trans('admin.TDrawRequired'),
            'Payment_Method.required' => trans('admin.Payment_MethodRequired'),
            'Client.required' => trans('admin.ClientRequired'),

        ];
    }


}
