<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
    'P_Type'=>'required',
     'P_Ar_Name'=>'required',
     'Group'=>'required',
     'Image'=>'image|mimes:jpeg,png,jpg|max:2048',
     'Barcode.*' => [
     'unique:product_units,Barcode',
     'distinct',
     ],

        ];
    }
    
    
    public function messages()
{
    return [
        'P_Type.required' => trans('admin.P_TypeRequired'),
     'P_Ar_Name.required' => trans('admin.P_Ar_NameRequired'),
     'Group.required' => trans('admin.GroupRequired'),
    ];
}
    
    
}
