<?php

namespace App\Http\Controllers;

use App\Models\AssemblyProducts;
use App\Models\ExpireDateQty;
use App\Services\Average;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Webslider;
use App\Models\About;
use App\Models\AcccountingManual;
use App\Models\SocialMedia;
use App\Models\ContactUS;
use App\Models\MsgRqst;
use App\Models\Articles;
use App\Models\Polices;
use App\Models\Products;
use App\Models\Terms;
use App\Models\CouponCode;
use App\Models\Governrate;
use App\Models\Addressses;
use App\Models\Customers;
use App\Models\StoresDefaultData;
use App\Models\ProductsQty;
use App\Models\ProductsVira;
use App\Models\CompanyData;
use App\Models\CatPro;
use App\Models\User;
use App\Models\ItemsGroups;
use App\Models\Brands;
use App\Models\SubImages;
use App\Models\SubVirables;
use App\Models\ProductUnits;
use App\Models\Stores;
use App\Models\Wishlist;
use App\Models\Compare;
use App\Models\FAQ;
use App\Models\Countris;
use App\Models\SalesDefaultData;
use App\Models\ProDetailsImg;
use App\Models\BefroeFooter;
use App\Models\ProductSalesOrder;
use App\Models\Rate;
use App\Models\Comments;
use App\Models\SalesOrder;
use App\Models\MainEComDesign;
use App\Models\HomeEComDesign;
use App\Models\HomeProductEComDesign;
use App\Models\SupPagesEComDesign;
use App\Models\SupPagesPartTwoEComDesign;
use App\Models\SupPagesWishCompEComDesign;
use App\Models\ProductDetailsEComDesign;
use App\Models\Notifications;
use App\Models\FifoQty;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use DB;
use Str;
use Mail;
use Cart;
use Hash;
use SpamProtector;
use App\Mail\UserResetPassword;
use App\Traits\GeneralTrait;

class WebsiteController extends Controller
{
    function __construct(){
$this->middleware('permission:سلايدر الموقع', ['only' => ['WebSliderPage']]);
$this->middleware('permission:من نحن', ['only' => ['AboutPage']]);
$this->middleware('permission:التواصل الاجتماعي', ['only' => ['SocialMediaPage']]);
$this->middleware('permission:رسايل التواصل', ['only' => ['MsgRqstPage']]);
$this->middleware('permission:التواصل معنا', ['only' => ['ContactUSPage']]);
$this->middleware('permission:المقالات', ['only' => ['ArticlesPage']]);
$this->middleware('permission:السياسات', ['only' => ['PolicesPage']]);
$this->middleware('permission:الشروط و الاحكام', ['only' => ['TermsPage']]);
$this->middleware('permission:كوبون كود', ['only' => ['CouponCodePage']]);
$this->middleware('permission:طلبات المتجر', ['only' => ['ShopOrders']]);
$this->middleware('permission:الاسئله الشائعه', ['only' => ['FAQPage']]);
$this->middleware('permission:الدول', ['only' => ['CountrisPage']]);
$this->middleware('permission:اعلانات تفاصيل االمنتج', ['only' => ['ProDetailsImg']]);
$this->middleware('permission:صور سياسه المتجر', ['only' => ['BefroeFooter']]);
$this->middleware('permission:طلبات المتجر', ['only' => ['ShopOrders']]);

}

    use GeneralTrait;


          //======  Webslider =======
    public function WebSliderPage(){
        $items=Webslider::all();
         return view('admin.Website.Webslider',['items'=>$items]);
    }

     public function AddWebSlider(){

         try {
             DB::beginTransaction();

        $data= $this->validate(request(),[
             'Arabic_Title'=>'required',
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
             'Image'=>'required|max:100000',
               ],[
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),

         ]);


             if(!empty(request('English_Title'))){

                 $english_name=request('English_Title');
             }else{

                 $english_name=request('Arabic_Title');
             }


             $image=request()->file('Image');
             $zFile=$this->UploadFile($image);


                 $data['Image']=$zFile;
         $data['Arabic_Title']=request('Arabic_Title');
         $data['Type']=request('Type');
         $data['Status']=1;
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['English_Title']=$english_name;
         Webslider::create($data);


             $dataUser=[
                 'screen_ar'=>'ويب سلايدر',
                 'screen_en'=>'WebSlider',
                 'explain_ar'=>request('Arabic_Title'),
                 'explain_en'=>$english_name,
             ];
             $this->UserCreateMoves($dataUser);


             DB::commit();
             session()->flash('success',trans('admin.Added_Successfully'));
             return back();

         }catch(\Exception $ex){

             $MODEL=Webslider::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Webslider::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }

     public function EditWebSlider($id){


         try {
             DB::beginTransaction();

              $data= $this->validate(request(),[
             'Arabic_Title'=>'required',
             'Image'=>'sometimes|nullable|max:100000',
               ],[
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),

         ]);



             $image=request()->file('Image');
             $zFile=$this->UploadFile($image);

             if(!empty($zFile)){

                 $data['Image']=$zFile;

             }else{

                 $data['Image']=request('Images');
             }


             $data['Status']=request('Status');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['Arabic_Title']=request('Arabic_Title');
           $data['Type']=request('Type');
         $data['English_Title']=request('English_Title');
           Webslider::where('id',$id)->update($data);

         $dataUser=[
             'screen_ar'=>'ويب سلايدر',
             'screen_en'=>'WebSlider',
             'explain_ar'=>request('Arabic_Title'),
             'explain_en'=>request('English_Title'),
         ];
         $this->UserUpdateMoves($dataUser);

         DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();

     }catch(\Exception $ex){

$MODEL=Webslider::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=Webslider::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}


     }

     public function DeleteWebSlider($id){

         try {
             DB::beginTransaction();
        $del=Webslider::find($id);


             $dataUser=[
                 'screen_ar'=>'ويب سلايدر',
                 'screen_en'=>'WebSlider',
                 'explain_ar'=>$del->Arabic_Title,
                 'explain_en'=>$del->English_Title,
             ];
             $this->UserDeleteMoves($dataUser);

             $del->delete();
             DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();
         }catch(\Exception $ex){

             $MODEL=Webslider::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Webslider::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

           }

     public function UnActiveSlider($id){

        Webslider::where('id',$id)->update(['Status'=>0]);
        session()->flash('error',trans('admin.UnActived'));
        return back();

           }

         public function ActiveSlider($id){

        Webslider::where('id',$id)->update(['Status'=>1]);
        session()->flash('success',trans('admin.Actived'));
        return back();

           }


             //======  About =======
    public function AboutPage(){
        $item=About::orderBy('id','desc')->first();
         return view('admin.Website.About',['item'=>$item]);
    }

     public function UpdateAbout($id){
         try {
             DB::beginTransaction();
              $data= $this->validate(request(),[
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
             'Arabic_Title'=>'required',
             'English_Title'=>'required',
             'Image'=>'sometimes|nullable|max:100000',
             'Image_2'=>'sometimes|nullable|max:100000',
             'Image_3'=>'sometimes|nullable|max:100000',

               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),


         ]);


             $image=request()->file('Image');
             $zFile=$this->UploadFile($image);
             $imagex=request()->file('Image_2');
             $zFileX=$this->UploadFile($imagex);
             $imagexe=request()->file('Image_3');
             $zFileXE=$this->UploadFile($imagexe);

             if(!empty($zFile)){$data['Image']=$zFile;}else{$data['Image']=request('Images');}
             if(!empty($zFileX)){$data['Image_2']=$zFileX;}else{$data['Image_2']=request('Images_2');}
             if(!empty($zFileXE)){$data['Image_3']=$zFileXE;}else{$data['Image_3']=request('Images_3');}

         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
           About::where('id',$id)->update($data);


             $dataUser=[
                 'screen_ar'=>'ويب سلايدر',
                 'screen_en'=>'WebSlider',
                 'explain_ar'=>$id,
                 'explain_en'=>$id,
             ];
             $this->UserUpdateMoves($dataUser);


             DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=About::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=About::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


             // ==== Social Media ==
            public function SocialMediaPage(){

                 $item=SocialMedia::orderBy('id','desc')->first();
        return view('admin.Website.SocialMedia',["item"=>$item]);

    }

            public function SocialMediaUpdate($id){
                try {
                    DB::beginTransaction();

          $data['Facebook'] = request('Facebook');
          $data['Twitter'] = request('Twitter');
          $data['Instagram'] = request('Instagram');
          $data['Youtube'] = request('Youtube');
          $data['Snapchat'] = request('Snapchat');
          $data['Whatsapp'] = request('Whatsapp');
          $data['Google_Plus'] = request('Google_Plus');
          $data['LinkedIn'] = request('LinkedIn');
          $data['Pinterest'] = request('Pinterest');
          $data['Telegram'] = request('Telegram');
          $data['iOS'] = request('iOS');
          $data['Android'] = request('Android');


           SocialMedia::OrderBy('id','desc')->update($data);


                $dataUser=[
                    'screen_ar'=>' التواصل الاجتماعي',
                    'screen_en'=>'Social Media',
                    'explain_ar'=>$id,
                    'explain_en'=>$id,
                ];
                $this->UserUpdateMoves($dataUser);


                DB::commit();

                session()->flash('success',trans('admin.Updated'));
                return redirect('SocialMedia');

            }catch(\Exception $ex){

$MODEL=SocialMedia::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=SocialMedia::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}


      }


             //======  MsgRqst =======
    public function MsgRqstPage(){
        $items=MsgRqst::paginate(100);
         return view('admin.Website.MsgRqst',['items'=>$items]);
    }

     public function DeleteMsgRqst($id){

         try {
             DB::beginTransaction();

        $del=MsgRqst::find($id);

             $dataUser=[
                 'screen_ar'=>' طلبات الرسائلي',
                 'screen_en'=>'Message Request',
                 'explain_ar'=>$id,
                 'explain_en'=>$id,
             ];
             $this->UserUDeleteMoves($dataUser);

             $del->delete();
             DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();

     }catch(\Exception $ex){

$MODEL=MsgRqst::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=MsgRqst::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}

           }


              //======  ContactUS =======
    public function ContactUSPage(){
        $item=ContactUS::orderBy('id','desc')->first();
         return view('admin.Website.ContactUS',['item'=>$item]);
    }

     public function ContactUSUpdate($id){

         try {
             DB::beginTransaction();

              $data= $this->validate(request(),[
             'Map'=>'required',
             'Arabic_Title'=>'required',
             'English_Title'=>'required',
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
             'Opening_Hours'=>'required',
             'Phone1'=>'required',
             'Phone2'=>'required',
             'Phone_Header'=>'required',
             'Email'=>'required',
             'Arabic_Address'=>'required',
             'English_Address'=>'required',


               ],[
         ]);


         $data['Map']=request('Map');
         $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['Opening_Hours']=request('Opening_Hours');
         $data['Phone1']=request('Phone1');
         $data['Phone2']=request('Phone2');
         $data['Phone_Header']=request('Phone_Header');
         $data['Email']=request('Email');
         $data['Arabic_Address']=request('Arabic_Address');
         $data['English_Address']=request('English_Address');
           ContactUS::where('id',$id)->update($data);


             $dataUser=[
                 'screen_ar'=>'التواصل معنا',
                 'screen_en'=>'Contact us',
                 'explain_ar'=>$id,
                 'explain_en'=>$id,
             ];
             $this->UserUpdateMoves($dataUser);


             DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=ContactUS::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=ContactUS::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


              //======  Articles =======
    public function ArticlesPage(){
        $items=Articles::all();
         return view('admin.Website.Articles',['items'=>$items]);
    }

     public function AddArticles(){

         try {
             DB::beginTransaction();

        $data= $this->validate(request(),[
             'Sub_Image'=>'required',
             'Arabic_Title'=>'required',
             'English_Title'=>'required',
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
             'Date'=>'required',
             'Image'=>'required|max:100000',
               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),
            'Sub_Image.required' => trans('admin.ImageRequired'),

         ]);

            $image=request()->file('Image');
          if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='ArticlesImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
                   }

         $data['Image']=$image_url;


           $imagee=request()->file('Sub_Image');
          if($imagee){
            $image_namee=Str::random(20);
            $exte=strtolower($imagee->getClientOriginalExtension());
            $image_full_namee=$image_namee .'.' . $exte ;
            $upload_pathe='ArticlesImages/';
            $image_urle=$upload_pathe.$image_full_namee;
            $successe=$imagee->move($upload_pathe,$image_full_namee);
                   }

         $data['Sub_Image']=$image_urle;
         $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['Date']=request('Date');
         Articles::create($data);


             $dataUser=[
                 'screen_ar'=>' المقالات',
                 'screen_en'=>'Blogs',
                 'explain_ar'=>request('Arabic_Title'),
                 'explain_en'=>request('English_Title'),
             ];
             $this->UserCreateMoves($dataUser);


             DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
             return back();

         }catch(\Exception $ex){

             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }

     public function EditArticles($id){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Sub_Image'=>'sometimes|nullable|max:100000',
             'Arabic_Title'=>'required',
             'English_Title'=>'required',
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
             'Date'=>'required',
             'Image'=>'sometimes|nullable|max:100000',
               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),
            'Image.required' => trans('admin.ImageRequired'),
            'Sub_Image.required' => trans('admin.ImageRequired'),

         ]);

            $image=request()->file('Image');
          if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
                   }

         if(!empty($image_url)){
            $data['Image']=$image_url;
         }else{

             $data['Image']=request('Images');
         }


                    $imagee=request()->file('Sub_Image');
          if($imagee){
            $image_namee=Str::random(20);
            $exte=strtolower($imagee->getClientOriginalExtension());
            $image_full_namee=$image_namee .'.' . $exte ;
            $upload_pathe='ArticlesImages/';
            $image_urle=$upload_pathe.$image_full_namee;
            $successe=$imagee->move($upload_pathe,$image_full_namee);
                   }

                 if(!empty($image_urle)){
            $data['Sub_Image']=$image_urle;
         }else{

             $data['Sub_Image']=request('Sub_Images');
         }


        $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
         $data['Date']=request('Date');

           Articles::where('id',$id)->update($data);

             $dataUser=[
                 'screen_ar'=>' المقالات',
                 'screen_en'=>'Blogs',
                 'explain_ar'=>request('Arabic_Title'),
                 'explain_en'=>request('English_Title'),
             ];
             $this->UserUpdateMoves($dataUser);


             DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();


         }catch(\Exception $ex){

             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

     }

     public function DeleteArticles($id){

         try {
             DB::beginTransaction();
        $del=Articles::find($id);

             $dataUser=[
                 'screen_ar'=>' المقالات',
                 'screen_en'=>'Blogs',
                 'explain_ar'=>$del->Arabic_Title,
                 'explain_en'=>$del->English_Title,
             ];
             $this->UserDeleteMoves($dataUser);

             $del->delete();
             DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

         }catch(\Exception $ex){

             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Articles::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

           }


            //======   Terms =======
    public function TermsPage(){
        $item=Terms::orderBy('id','desc')->first();
         return view('admin.Website.Terms',['item'=>$item]);
    }

     public function UpdateTerms($id){

         try {
             DB::beginTransaction();
              $data= $this->validate(request(),[
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
         ]);

         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');

           Terms::where('id',$id)->update($data);


             $dataUser=[
                 'screen_ar'=>' الشروط و الاحكام',
                 'screen_en'=>'Terms & Conditions',
                 'explain_ar'=>$id,
                 'explain_en'=>$id,
             ];
             $this->UserUpdateMoves($dataUser);


             DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();
         }catch(\Exception $ex){

             $MODEL=Terms::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Terms::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


        //======   Polices =======
    public function PolicesPage(){
        $item=Polices::orderBy('id','desc')->first();
         return view('admin.Website.Polices',['item'=>$item]);
    }

     public function UpdatePolices($id){

         try {
             DB::beginTransaction();
                      $data= $this->validate(request(),[
             'Arabic_Desc'=>'required',
             'English_Desc'=>'required',
               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
         ]);

         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');

           Polices::where('id',$id)->update($data);


             $dataUser=[
                 'screen_ar'=>'السياسات',
                 'screen_en'=>'Polices',
                 'explain_ar'=>$id,
                 'explain_en'=>$id,
             ];
             $this->UserUpdateMoves($dataUser);
DB::commit();
            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=Polices::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=Polices::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }

        //Coupon Code

      public function  CouponCodePage(){
       $items=CouponCode::all();
        return view('admin.Website.CouponCode',["items"=>$items]);
    }

      public function AddCouponCode(){

          try {
              DB::beginTransaction();

             $data= $this->validate(request(),[
                 'Amount'=>'required',
                 'Num'=>'required',
                 'Expire'=>'required',
                  'Code'=>'required|unique:coupon_codes',


                    ],[
                'Code.required' =>trans('admin.CodeRequired'),
                'Amount.required' =>trans('admin.AmountRequired'),
                'Num.required' =>trans('admin.NumRequired'),
                'Expire.required' =>trans('admin.ExpireRequired'),

             ]);

                      $data['Code']=request('Code');
                      $data['Amount']=request('Amount');
                      $data['Status']=0;
                      $data['Used']=0;
                      $data['Num']=request('Num');
                      $data['Expire']=request('Expire');


                        CouponCode::create($data);
              $dataUser=[
                  'screen_ar'=>'كوبونات الخصم',
                  'screen_en'=>'Cupon Codes',
                  'explain_ar'=>request('Code'),
                  'explain_en'=>request('Code'),
              ];
              $this->UserCreateMoves($dataUser);
              DB::commit();
                      session()->flash('success',trans('admin.Added_Successfully'));
                      return back();

          }catch(\Exception $ex){

              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }
}

      public function EditCouponCode($id){

          try {
              DB::beginTransaction();
            $data= $this->validate(request(),[
                'Code'=>'required|unique:coupon_codes,Code,'.$id,
                 'Amount'=>'required',
                 'Num'=>'required',
                 'Expire'=>'required',

                    ],[
                'Code.required' =>trans('admin.CodeRequired'),
                'Amount.required' =>trans('admin.AmountRequired'),
                'Num.required' =>trans('admin.NumRequired'),
                'Expire.required' =>trans('admin.ExpireRequired'),

             ]);

                      $data['Code']=request('Code');
                      $data['Amount']=request('Amount');
                      $data['Status']=request('Status');
                      $data['Num']=request('Num');
                      $data['Expire']=request('Expire');


                CouponCode::where('id',$id)->update($data);

              $dataUser=[
                  'screen_ar'=>'كوبونات الخصم',
                  'screen_en'=>'Cupon Codes',
                  'explain_ar'=>request('Code'),
                  'explain_en'=>request('Code'),
              ];
              $this->UserUpdateMoves($dataUser);
              DB::commit();


                session()->flash('success',trans('admin.Updated'));
                return back();

          }catch(\Exception $ex){

              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

}

      public function DeleteCouponCode($id){
          try {
              DB::beginTransaction();
            $del=CouponCode::find($id);


              $dataUser=[
                  'screen_ar'=>'كوبونات الخصم',
                  'screen_en'=>'Cupon Codes',
                  'explain_ar'=>$del->Code,
                  'explain_en'=>$del->Code,
              ];
              $this->UserDeleteMoves($dataUser);
              $del->delete();
              DB::commit();

            session()->flash('error',trans('admin.Deleted'));
            return back();
          }catch(\Exception $ex){

              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=CouponCode::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

}



                 //======  FAQ =======
    public function FAQPage(){
        $items=FAQ::all();
         return view('admin.Website.FAQ',['items'=>$items]);
    }

     public function AddFAQ(){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Arabic_Question'=>'required',
             'English_Question'=>'required',
             'Arabic_Answer'=>'required',
             'English_Answer'=>'required',


               ],[


         ]);

         $data['Arabic_Question']=request('Arabic_Question');
         $data['English_Question']=request('English_Question');
         $data['Arabic_Answer']=request('Arabic_Answer');
         $data['English_Answer']=request('English_Answer');
         FAQ::create($data);

             $dataUser=[
                 'screen_ar'=>'الاسئله الشائعه',
                 'screen_en'=>'FAQ',
                 'explain_ar'=>request('Arabic_Question'),
                 'explain_en'=>request('English_Question'),
             ];
             $this->UserCreateMoves($dataUser);
             DB::commit();

             session()->flash('success',trans('admin.Added_Successfully'));
             return back();

         }catch(\Exception $ex){

             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }

     public function EditFAQ($id){

         try {
             DB::beginTransaction();

              $data= $this->validate(request(),[
             'Arabic_Question'=>'required',
             'English_Question'=>'required',
             'Arabic_Answer'=>'required',
             'English_Answer'=>'required',


               ],[


         ]);


         $data['Arabic_Question']=request('Arabic_Question');
         $data['English_Question']=request('English_Question');
         $data['Arabic_Answer']=request('Arabic_Answer');
         $data['English_Answer']=request('English_Answer');

           FAQ::where('id',$id)->update($data);

             $dataUser=[
                 'screen_ar'=>'الاسئله الشائعه',
                 'screen_en'=>'FAQ',
                 'explain_ar'=>request('Arabic_Question'),
                 'explain_en'=>request('English_Question'),
             ];
             $this->UserUpdateMoves($dataUser);
             DB::commit();


            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }

     public function DeleteFAQ($id){

         try {
             DB::beginTransaction();
        $del=FAQ::find($id);

             $dataUser=[
                 'screen_ar'=>'الاسئله الشائعه',
                 'screen_en'=>'FAQ',
                 'explain_ar'=>$del->Arabic_Question,
                 'explain_en'=>$del->English_Question,
             ];
             $this->UserUpdateMoves($dataUser);
             $del->delete();
             DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

         }catch(\Exception $ex){

             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=FAQ::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

           }



                     //======  ProDetailsImg =======
    public function ProDetailsImg(){
        $items=ProDetailsImg::all();
         return view('admin.Website.ProDetailsImg',['items'=>$items]);
    }

     public function EditProDetailsImg($id){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Image'=>'sometimes|nullable|max:100000',

               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),


         ]);

            $image=request()->file('Image');
          if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='WebsliderImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
                   }

         if(!empty($image_url)){
            $data['Image']=$image_url;
         }else{

             $data['Image']=request('Images');
         }


        $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
           ProDetailsImg::where('id',$id)->update($data);

DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

         }catch(\Exception $ex){

             $MODEL=ProDetailsImg::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=ProDetailsImg::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


                         //======  BefroeFooter =======
    public function BefroeFooter(){
        $items=BefroeFooter::all();
         return view('admin.Website.BefroeFooter',['items'=>$items]);
    }

     public function EditBefroeFooter($id){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Image'=>'sometimes|nullable|max:100000',
             'Arabic_Title'=>'required',
             'English_Title'=>'required',


               ],[
            'Arabic_Desc.required' => trans('admin.Arabic_DescRequired'),
            'English_Desc.required' => trans('admin.English_DescRequired'),
            'Arabic_Title.required' => trans('admin.Arabic_TitleRequired'),
            'English_Title.required' => trans('admin.English_TitleRequired'),


         ]);


        $data['Image']=request('Image');
        $data['Arabic_Title']=request('Arabic_Title');
         $data['English_Title']=request('English_Title');
         $data['Arabic_Desc']=request('Arabic_Desc');
         $data['English_Desc']=request('English_Desc');
           BefroeFooter::where('id',$id)->update($data);

           DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();
         }catch(\Exception $ex){

             $MODEL=BefroeFooter::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             $MODEL=BefroeFooter::class;
             DB::rollBack();
             Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


    //===  ShopOrders ==
     public function ShopOrders(){
            $items=SalesOrder::where('Order_Type',1)->orderBy('id','desc')->paginate(100);

         return view('admin.Website.ShopOrders',['items'=>$items]);
    }


     public function ChangeStatusShop(){

 SalesOrder::where('id',request('ID'))->update(['Delivery_Status'=>request('Delivery_Status')]);
        session()->flash('error',trans('admin.Updated'));
        return back();

           }



    //  E-Commercce =========================  Design   ============================
      public function EComDesign(){
            $Main=MainEComDesign::orderBy('id','desc')->first();
            $Home=HomeEComDesign::orderBy('id','desc')->first();
            $HomePro=HomeProductEComDesign::orderBy('id','desc')->first();
            $SubOne=SupPagesEComDesign::orderBy('id','desc')->first();
            $SubTwo=SupPagesPartTwoEComDesign::orderBy('id','desc')->first();
            $Wish=SupPagesWishCompEComDesign::orderBy('id','desc')->first();
            $ProDetails=ProductDetailsEComDesign::orderBy('id','desc')->first();

         return view('admin.Website.EComDesign', get_defined_vars());
    }

   public function AddMainEComDesignFirst(){


         $data['Pagination_BG_Color']=null;

         MainEComDesign::create($data);


             return back();

    }

      public function AddMainEComDesign(){



          $image=request()->file('Body_BG_Image');
          if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='LogoImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
                   }


             if(!empty($image_url)){

                 $data['Body_BG_Image']=$image_url;

             }else{
                 $data['Body_BG_Image']=request('Images');
             }



         $data['Font_Type']=request('Font_Type');
         $data['Pagination_BG_Color']=request('Pagination_BG_Color');
         $data['Pagination_Txt_Color']=request('Pagination_Txt_Color');
         $data['Pagination_Active_BG_Color']=request('Pagination_Active_BG_Color');
         $data['Pagination_Active_Txt_Color']=request('Pagination_Active_Txt_Color');
         $data['Body_BG_Type']=request('Body_BG_Type');
         $data['Body_BG_Color']=request('Body_BG_Color');
         $data['Sub_Page_BG_Color']=request('Sub_Page_BG_Color');
         $data['Breadcumb_BG_Color']=request('Breadcumb_BG_Color');
             $data['Breadcumb_Txt_Color']=request('Breadcumb_Txt_Color');
         $data['Modal_BG_Color']=request('Modal_BG_Color');
         $data['Modal_Txt_Color']=request('Modal_Txt_Color');
         $data['Modal_Button_BG_Color']=request('Modal_Button_BG_Color');
         $data['Modal_Button_Txt_Color']=request('Modal_Button_Txt_Color');
         $data['Table_Header_BG_Color']=request('Table_Header_BG_Color');
         $data['Table_Header_Txt_Color']=request('Table_Header_Txt_Color');
         $data['Table_Body_BG_Color']=request('Table_Body_BG_Color');
         $data['Table_Body_Txt_Color']=request('Table_Body_Txt_Color');
                 $data['Table_Button_BG_Color']=request('Table_Button_BG_Color');
         $data['Table_Button_Txt_Color']=request('Table_Button_Txt_Color');
         $data['CopyRights_Txt_Color']=request('CopyRights_Txt_Color');
         $data['CopyRights_Klar_Txt_Color']=request('CopyRights_Klar_Txt_Color');
         $data['CopyRights_Klar_Hover_Txt_Color']=request('CopyRights_Klar_Hover_Txt_Color');
         $data['Preloader_BG_Color']=request('Preloader_BG_Color');
         $data['Preloader_Small_Circle_Color']=request('Preloader_Small_Circle_Color');
         $data['Preloader_Large_Circle_Color']=request('Preloader_Large_Circle_Color');
         $data['Footer_Title_Color']=request('Footer_Title_Color');
         $data['Footer_Txt_Color']=request('Footer_Txt_Color');
             $data['Footer_Social_Color']=request('Footer_Social_Color');
         $data['Footer_Social_Hover_BG_Color']=request('Footer_Social_Hover_BG_Color');
         $data['Footer_Social_Hover_Txt_Color']=request('Footer_Social_Hover_Txt_Color');
         $data['Header_Top_BG_Color']=request('Header_Top_BG_Color');
         $data['Header_Top_Txt_Color']=request('Header_Top_Txt_Color');
         $data['Header_Top_Txt_Hover_Color']=request('Header_Top_Txt_Hover_Color');
         $data['Header_Middle_BG_Color']=request('Header_Middle_BG_Color');
         $data['Header_Middle_Icon_Color']=request('Header_Middle_Icon_Color');
         $data['Header_Middle_Icon_Hover_Color']=request('Header_Middle_Icon_Hover_Color');
         $data['Header_SearchBar_BG_Color']=request('Header_SearchBar_BG_Color');
            $data['Header_SearchBar_Txt_Color']=request('Header_SearchBar_Txt_Color');
         $data['Header_SearchBar_Icon_BG_Color']=request('Header_SearchBar_Icon_BG_Color');
         $data['Header_SearchBar_Icon_Txt_Color']=request('Header_SearchBar_Icon_Txt_Color');
         $data['Header_SearchBar_Icon_Hover_BG_Color']=request('Header_SearchBar_Icon_Hover_BG_Color');
         $data['Header_SearchBar_Icon_Hover_Txt_Color']=request('Header_SearchBar_Icon_Hover_Txt_Color');
         $data['Navbar_BG_Color']=request('Navbar_BG_Color');
         $data['Navbar_Txt_Color']=request('Navbar_Txt_Color');
         $data['Navbar_Hover_BG_Color']=request('Navbar_Hover_BG_Color');
         $data['Navbar_Hover_Txt_Color']=request('Navbar_Hover_Txt_Color');
         $data['Navbar_Category_BG_Color']=request('Navbar_Category_BG_Color');
         $data['Navbar_Category_Txt_Color']=request('Navbar_Category_Txt_Color');
         $data['Navbar_Category_Box_BG_Color']=request('Navbar_Category_Box_BG_Color');
         $data['Navbar_Category_Box_Txt_Color']=request('Navbar_Category_Box_Txt_Color');
         $data['Footer_Txt_Hover_Color']=request('Footer_Txt_Hover_Color');
         $data['Footer_Social_BG_Color']=request('Footer_Social_BG_Color');



         MainEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }


       public function AddHomeEComDesignFirst(){


         $data['Slider_BG_Color']=null;

         HomeEComDesign::create($data);


             return back();

    }

      public function AddHomeEComDesign(){



          $image=request()->file('Slider_BG_Image');
          if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='LogoImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
                   }


             if(!empty($image_url)){

                 $data['Slider_BG_Image']=$image_url;

             }else{
                 $data['Slider_BG_Image']=request('Images');
             }



         $data['Slider_BG_Type']=request('Slider_BG_Type');

         $data['Slider_BG_Color']=request('Slider_BG_Color');
         $data['Slider_Button_BG_Color']=request('Slider_Button_BG_Color');
         $data['Slider_Button_Txt_Color']=request('Slider_Button_Txt_Color');
         $data['Slider_Button_Hover_BG_Color']=request('Slider_Button_Hover_BG_Color');
         $data['Slider_Button_Hover_Txt_Color']=request('Slider_Button_Hover_Txt_Color');
         $data['Slider_Title_Txt_Color']=request('Slider_Title_Txt_Color');
         $data['Slider_Desc_Txt_Color']=request('Slider_Desc_Txt_Color');
             $data['Ads_Top_Img_First_BG_Color']=request('Ads_Top_Img_First_BG_Color');
         $data['Ads_Top_Img_First_Before_BG_Color']=request('Ads_Top_Img_First_Before_BG_Color');
         $data['Ads_Top_Img_Second_BG_Color']=request('Ads_Top_Img_Second_BG_Color');
         $data['Ads_Top_Img_Second_Before_BG_Color']=request('Ads_Top_Img_Second_Before_BG_Color');
         $data['Ads_Top_Img_Button_BG_Color']=request('Ads_Top_Img_Button_BG_Color');
         $data['Ads_Top_Img_Button_Txt_Color']=request('Ads_Top_Img_Button_Txt_Color');
         $data['Ads_Top_Img_Button_Hover_BG_Color']=request('Ads_Top_Img_Button_Hover_BG_Color');
         $data['Ads_Top_Img_Button_Hover_Txt_Color']=request('Ads_Top_Img_Button_Hover_Txt_Color');
         $data['Support_Icons_BG_Color']=request('Support_Icons_BG_Color');
                 $data['Support_Icons_Txt_Color']=request('Support_Icons_Txt_Color');
         $data['Support_Icons_Color']=request('Support_Icons_Color');
         $data['Ads_Bootom_Imgs_BG_Color']=request('Ads_Bootom_Imgs_BG_Color');
         $data['Ads_Bootom_Imgs_Middle_BG_Color']=request('Ads_Bootom_Imgs_Middle_BG_Color');
         $data['Ads_Bootom_Imgs_Button_BG_Color']=request('Ads_Bootom_Imgs_Button_BG_Color');
         $data['Ads_Bootom_Imgs_Button_Txt_Color']=request('Ads_Bootom_Imgs_Button_Txt_Color');
         $data['Ads_Bootom_Imgs_Button_Hover_BG_Color']=request('Ads_Bootom_Imgs_Button_Hover_BG_Color');
         $data['Ads_Bootom_Imgs_Button_Hover_Txt_Color']=request('Ads_Bootom_Imgs_Button_Hover_Txt_Color');
         $data['Partners_BG_Color']=request('Partners_BG_Color');




         HomeEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }


           public function AddHomeProductEComDesignFirst(){


         $data['Special_Offer_Title_BG_Color']=null;

         HomeProductEComDesign::create($data);


             return back();

    }

      public function AddHomeProductEComDesign(){


         $data['Special_Offer_Title_BG_Color']=request('Special_Offer_Title_BG_Color');
         $data['Special_Offer_Title_Txt_Color']=request('Special_Offer_Title_Txt_Color');
         $data['Special_Offer_Product_BG_Color']=request('Special_Offer_Product_BG_Color');
         $data['Special_Offer_Product_Border_Color']=request('Special_Offer_Product_Border_Color');
         $data['Special_Offer_Product_Txt_Color']=request('Special_Offer_Product_Txt_Color');
         $data['Special_Offer_Product_Price_Color']=request('Special_Offer_Product_Price_Color');
         $data['Special_Offer_Product_Rate_Color']=request('Special_Offer_Product_Rate_Color');
          $data['Best_Sellers_Title_BG_Color']=request('Best_Sellers_Title_BG_Color');
         $data['Best_Sellers_Title_Txt_Color']=request('Best_Sellers_Title_Txt_Color');
         $data['Best_Sellers_Category_Txt_Color']=request('Best_Sellers_Category_Txt_Color');
         $data['Best_Sellers_Category_Active_Txt_Color']=request('Best_Sellers_Category_Active_Txt_Color');
         $data['Best_Sellers_Product_BG_Color']=request('Best_Sellers_Product_BG_Color');
         $data['Best_Sellers_Product_Group_BG_Color']=request('Best_Sellers_Product_Group_BG_Color');
         $data['Best_Sellers_Product_Group_Txt_Color']=request('Best_Sellers_Product_Group_Txt_Color');
         $data['Best_Sellers_Product_Group_Hover_BG_Color']=request('Best_Sellers_Product_Group_Hover_BG_Color');
         $data['Best_Sellers_Product_Group_Hover_Txt_Color']=request('Best_Sellers_Product_Group_Hover_Txt_Color');
        $data['Best_Sellers_Product_Icon_BG_Color']=request('Best_Sellers_Product_Icon_BG_Color');
         $data['Best_Sellers_Product_Icon_Txt_Color']=request('Best_Sellers_Product_Icon_Txt_Color');
         $data['Best_Sellers_Product_Icon_Hover_BG_Color']=request('Best_Sellers_Product_Icon_Hover_BG_Color');
         $data['Best_Sellers_Product_Icon_Hover_Txt_Color']=request('Best_Sellers_Product_Icon_Hover_Txt_Color');
         $data['Best_Sellers_Product_Txt_Color']=request('Best_Sellers_Product_Txt_Color');
         $data['Best_Sellers_Product_Price_Color']=request('Best_Sellers_Product_Price_Color');
         $data['Best_Sellers_Product_Rate_Color']=request('Best_Sellers_Product_Rate_Color');
         $data['New_Arrivals_Title_BG_Color']=request('New_Arrivals_Title_BG_Color');
         $data['New_Arrivals_Title_Txt_Color']=request('New_Arrivals_Title_Txt_Color');
         $data['New_Arrivals_Product_BG_Color']=request('New_Arrivals_Product_BG_Color');
         $data['New_Arrivals_Product_Group_BG_Color']=request('New_Arrivals_Product_Group_BG_Color');
         $data['New_Arrivals_Product_Group_Txt_Color']=request('New_Arrivals_Product_Group_Txt_Color');
         $data['New_Arrivals_Product_Group_Hover_BG_Color']=request('New_Arrivals_Product_Group_Hover_BG_Color');
         $data['New_Arrivals_Product_Group_Hover_Txt_Color']=request('New_Arrivals_Product_Group_Hover_Txt_Color');
         $data['New_Arrivals_Product_Icon_BG_Color']=request('New_Arrivals_Product_Icon_BG_Color');
         $data['New_Arrivals_Product_Icon_Txt_Color']=request('New_Arrivals_Product_Icon_Txt_Color');
         $data['New_Arrivals_Product_Icon_Hover_BG_Color']=request('New_Arrivals_Product_Icon_Hover_BG_Color');
         $data['New_Arrivals_Product_Icon_Hover_Txt_Color']=request('New_Arrivals_Product_Icon_Hover_Txt_Color');
         $data['New_Arrivals_Product_Txt_Color']=request('New_Arrivals_Product_Txt_Color');
         $data['New_Arrivals_Product_Price_Color']=request('New_Arrivals_Product_Price_Color');
         $data['New_Arrivals_Product_Hover_Price_Color']=request('New_Arrivals_Product_Hover_Price_Color');
         $data['New_Arrivals_Product_Rate_Color']=request('New_Arrivals_Product_Rate_Color');
         $data['Special_Offer_Product_Txt_Hover_Color']=request('Special_Offer_Product_Txt_Hover_Color');




         HomeProductEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }



            public function AddSupPagesEComDesignFirst(){


         $data['About_Title_Color']=null;

         SupPagesEComDesign::create($data);


             return back();

    }

      public function AddSupPagesEComDesign(){


         $data['About_Title_Color']=request('About_Title_Color');
         $data['About_Txt_Color']=request('About_Txt_Color');
         $data['Blogs_Title_Color']=request('Blogs_Title_Color');
         $data['Blogs_Txt_Color']=request('Blogs_Txt_Color');
         $data['Blogs_Hover_Txt_Color']=request('Blogs_Hover_Txt_Color');
         $data['Contact_Title_Color']=request('Contact_Title_Color');
         $data['Contact_Txt_Color']=request('Contact_Txt_Color');
          $data['Contact_Form_Input_Border_Color']=request('Contact_Form_Input_Border_Color');
         $data['Contact_Form_Input_Txt_Color']=request('Contact_Form_Input_Txt_Color');
         $data['Contact_Form_Button_BG_Color']=request('Contact_Form_Button_BG_Color');
         $data['Contact_Form_Button_Txt_Color']=request('Contact_Form_Button_Txt_Color');
         $data['Contact_Form_Button_Hover_BG_Color']=request('Contact_Form_Button_Hover_BG_Color');
         $data['Contact_Form_Button_Hover_Txt_Color']=request('Contact_Form_Button_Hover_Txt_Color');
         $data['Faq_Title_Color']=request('Faq_Title_Color');
         $data['Faq_Q_BG_Color']=request('Faq_Q_BG_Color');
         $data['Faq_Q_Txt_Color']=request('Faq_Q_Txt_Color');
        $data['Faq_A_Line_Color']=request('Faq_A_Line_Color');
         $data['Faq_A_BG_Color']=request('Faq_A_BG_Color');
         $data['Faq_A_Txt_Color']=request('Faq_A_Txt_Color');
         $data['MyAccount_Box_BG_Color']=request('MyAccount_Box_BG_Color');
         $data['MyAccount_Box_Button_BG_Color']=request('MyAccount_Box_Button_BG_Color');
         $data['MyAccount_Box_Button_Txt_Color']=request('MyAccount_Box_Button_Txt_Color');
         $data['MyAccount_Box_Button_Hover_BG_Color']=request('MyAccount_Box_Button_Hover_BG_Color');
         $data['MyAccount_Box_Button_Hover_Txt_Color']=request('MyAccount_Box_Button_Hover_Txt_Color');
         $data['MyAccount_Box_Input_Border_Color']=request('MyAccount_Box_Input_Border_Color');
         $data['MyAccount_Box_Input_Txt_Color']=request('MyAccount_Box_Input_Txt_Color');


         SupPagesEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }



           public function AddSupPagesPartTwoEComDesignFirst(){


         $data['Shop_Product_BG_Color']=null;

         SupPagesPartTwoEComDesign::create($data);


             return back();

    }

      public function AddSupPagesPartTwoEComDesign(){


         $data['Shop_Product_BG_Color']=request('Shop_Product_BG_Color');
         $data['Shop_Product_Group_BG_Color']=request('Shop_Product_Group_BG_Color');
         $data['Shop_Product_Group_Txt_Color']=request('Shop_Product_Group_Txt_Color');
         $data['Shop_Product_Group_Hover_BG_Color']=request('Shop_Product_Group_Hover_BG_Color');
         $data['Shop_Product_Group_Hover_Txt_Color']=request('Shop_Product_Group_Hover_Txt_Color');
         $data['Shop_Product_Icon_BG_Color']=request('Shop_Product_Icon_BG_Color');
         $data['Shop_Product_Icon_Txt_Color']=request('Shop_Product_Icon_Txt_Color');
          $data['Shop_Product_Icon_Hover_BG_Color']=request('Shop_Product_Icon_Hover_BG_Color');
         $data['Shop_Product_Icon_Hover_Txt_Color']=request('Shop_Product_Icon_Hover_Txt_Color');
         $data['Shop_Product_Txt_Color']=request('Shop_Product_Txt_Color');
         $data['Shop_Product_Price_Color']=request('Shop_Product_Price_Color');
         $data['Shop_Product_Rate_Color']=request('Shop_Product_Rate_Color');
         $data['Shop_Filter_Title_Color']=request('Shop_Filter_Title_Color');
         $data['Shop_Filter_Txt_Color']=request('Shop_Filter_Txt_Color');
         $data['Shop_Filter_Search_BG_Color']=request('Shop_Filter_Search_BG_Color');
         $data['Shop_Filter_Search_Icon_BG_Color']=request('Shop_Filter_Search_Icon_BG_Color');
        $data['Shop_Filter_Search_Icon_Txt_Color']=request('Shop_Filter_Search_Icon_Txt_Color');
         $data['Shop_Filter_Search_Icon_BG_Hover_Color']=request('Shop_Filter_Search_Icon_BG_Hover_Color');
         $data['Shop_Filter_Search_Icon_Txt_Hover_Color']=request('Shop_Filter_Search_Icon_Txt_Hover_Color');
         $data['Cart_Button_BG_Color']=request('Cart_Button_BG_Color');
         $data['Cart_Button_Txt_Color']=request('Cart_Button_Txt_Color');
         $data['Cart_Button_BG_Hover_Color']=request('Cart_Button_BG_Hover_Color');
         $data['Cart_Button_Txt_Hover_Color']=request('Cart_Button_Txt_Hover_Color');
         $data['Cart_Box_BG_Color']=request('Cart_Box_BG_Color');
         $data['Cart_Box_Title_Color']=request('Cart_Box_Title_Color');
 $data['Cart_Box_Txt_Color']=request('Cart_Box_Txt_Color');
         $data['Cart_Box_Button_BG_Color']=request('Cart_Box_Button_BG_Color');
         $data['Cart_Box_Button_Txt_Color']=request('Cart_Box_Button_Txt_Color');
         $data['Cart_Box_Button_BG_Hover_Color']=request('Cart_Box_Button_BG_Hover_Color');
         $data['Cart_Box_Button_Txt_Hover_Color']=request('Cart_Box_Button_Txt_Hover_Color');
         $data['Cart_Cupon_Button_BG_Color']=request('Cart_Cupon_Button_BG_Color');
         $data['Cart_Cupon_Button_Txt_Color']=request('Cart_Cupon_Button_Txt_Color');
          $data['Cart_Cupon_Button_BG_Hover_Color']=request('Cart_Cupon_Button_BG_Hover_Color');
         $data['Cart_Cupon_Button_Txt_Hover_Color']=request('Cart_Cupon_Button_Txt_Hover_Color');
         $data['Cart_Cupon_Input_BG_Color']=request('Cart_Cupon_Input_BG_Color');
         $data['Checkout_Box_BG_Color']=request('Checkout_Box_BG_Color');
         $data['Checkout_Box_Title_Color']=request('Checkout_Box_Title_Color');
         $data['Checkout_Box_Txt_Color']=request('Checkout_Box_Txt_Color');
         $data['Checkout_Box_Button_BG_Color']=request('Checkout_Box_Button_BG_Color');
         $data['Checkout_Box_Button_Txt_Color']=request('Checkout_Box_Button_Txt_Color');
         $data['Checkout_Box_Button_BG_Hover_Color']=request('Checkout_Box_Button_BG_Hover_Color');
        $data['Checkout_Box_Button_Txt_Hover_Color']=request('Checkout_Box_Button_Txt_Hover_Color');
         $data['Checkout_Head_BG_Color']=request('Checkout_Head_BG_Color');
         $data['Checkout_Head_Txt_Color']=request('Checkout_Head_Txt_Color');
         $data['Checkout_Input_BG_Color']=request('Checkout_Input_BG_Color');
         $data['Checkout_Input_Txt_Color']=request('Checkout_Input_Txt_Color');
         $data['Reg_Login_Form_Box_BG_Color']=request('Reg_Login_Form_Box_BG_Color');
         $data['Reg_Login_Form_Box_Title_Color']=request('Reg_Login_Form_Box_Title_Color');
         $data['Reg_Login_Form_Box_Txt_Color']=request('Reg_Login_Form_Box_Txt_Color');
         $data['Reg_Login_Form_Box_Txt_Hover_Color']=request('Reg_Login_Form_Box_Txt_Hover_Color');
         $data['Reg_Login_Form_Box_Input_Border_Color']=request('Reg_Login_Form_Box_Input_Border_Color');
         $data['Reg_Login_Form_Box_Button_BG_Color']=request('Reg_Login_Form_Box_Button_BG_Color');
         $data['Reg_Login_Form_Box_Button_Txt_Color']=request('Reg_Login_Form_Box_Button_Txt_Color');
         $data['Reg_Login_Form_Box_Button_BG_Hover_Color']=request('Reg_Login_Form_Box_Button_BG_Hover_Color');
         $data['Reg_Login_Form_Box_Button_Txt_Hover_Color']=request('Reg_Login_Form_Box_Button_Txt_Hover_Color');



         SupPagesPartTwoEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }


          public function AddProductDetailsEComDesignFirst(){


         $data['Title_Color']=null;

         ProductDetailsEComDesign::create($data);


             return back();

    }

      public function AddProductDetailsEComDesign(){


         $data['Title_Color']=request('Title_Color');
         $data['Txt_Color']=request('Txt_Color');
         $data['Price_Color']=request('Price_Color');
         $data['Rate_Color']=request('Rate_Color');
         $data['Select_BG_Color']=request('Select_BG_Color');
         $data['Select_Txt_Color']=request('Select_Txt_Color');
         $data['Qty_BG_Color']=request('Qty_BG_Color');
          $data['Qty_Txt_Color']=request('Qty_Txt_Color');
         $data['Qty_Input_BG_Color']=request('Qty_Input_BG_Color');
         $data['Qty_Input_Txt_Color']=request('Qty_Input_Txt_Color');
         $data['Comment_Input_BG_Color']=request('Comment_Input_BG_Color');
         $data['Comment_Button_BG_Color']=request('Comment_Button_BG_Color');
         $data['Comment_Button_Txt_Color']=request('Comment_Button_Txt_Color');
         $data['Comment_Button_BG_Hover_Color']=request('Comment_Button_BG_Hover_Color');
         $data['Comment_Button_Txt_Hover_Color']=request('Comment_Button_Txt_Hover_Color');
         $data['Related_Title_BG_Color']=request('Related_Title_BG_Color');
        $data['Related_Title_Txt_Color']=request('Related_Title_Txt_Color');
         $data['Related_Product_BG_Color']=request('Related_Product_BG_Color');
         $data['Related_Product_Group_BG_Color']=request('Related_Product_Group_BG_Color');
         $data['Related_Product_Group_Txt_Color']=request('Related_Product_Group_Txt_Color');
         $data['Related_Product_Group_Hover_BG_Color']=request('Related_Product_Group_Hover_BG_Color');
         $data['Related_Product_Group_Hover_Txt_Color']=request('Related_Product_Group_Hover_Txt_Color');
         $data['Related_Product_Icon_BG_Color']=request('Related_Product_Icon_BG_Color');
         $data['Related_Product_Icon_Txt_Color']=request('Related_Product_Icon_Txt_Color');
         $data['Related_Product_Icon_Hover_BG_Color']=request('Related_Product_Icon_Hover_BG_Color');
         $data['Related_Product_Icon_Hover_Txt_Color']=request('Related_Product_Icon_Hover_Txt_Color');
         $data['Related_Product_Txt_Color']=request('Related_Product_Txt_Color');
         $data['Related_Product_Price_Color']=request('Related_Product_Price_Color');
         $data['Related_Product_Hover_Price_Color']=request('Related_Product_Hover_Price_Color');
         $data['Related_Product_Rate_Color']=request('Related_Product_Rate_Color');


         ProductDetailsEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }

              public function AddPagesWishCompEComDesignFirst(){


         $data['Wish_Title_BG_Color']=null;

         SupPagesWishCompEComDesign::create($data);


             return back();

    }

      public function AddSupPagesWishCompEComDesign(){


         $data['Wish_Title_BG_Color']=request('Wish_Title_BG_Color');
         $data['Wish_Title_Txt_Color']=request('Wish_Title_Txt_Color');
         $data['Wish_Box_BG_Color']=request('Wish_Box_BG_Color');
         $data['Wish_Box_Border_Color']=request('Wish_Box_Border_Color');
         $data['Wish_Box_Border_Type']=request('Wish_Box_Border_Type');
         $data['Wish_Box_Txt_Color']=request('Wish_Box_Txt_Color');
         $data['Wish_Box_Button_BG_Color']=request('Wish_Box_Button_BG_Color');
          $data['Wish_Box_Button_Txt_Color']=request('Wish_Box_Button_Txt_Color');
         $data['Wish_Box_Button_BG_Hover_Color']=request('Wish_Box_Button_BG_Hover_Color');
         $data['Wish_Box_Button_Txt_Hover_Color']=request('Wish_Box_Button_Txt_Hover_Color');
         $data['Compare_Box_BG_Color']=request('Compare_Box_BG_Color');
         $data['Compare_Box_Txt_Color']=request('Compare_Box_Txt_Color');
         $data['Compare_Box_Price_Hover_Color']=request('Compare_Box_Price_Hover_Color');
         $data['Compare_Box_Delete_Txt_Color']=request('Compare_Box_Delete_Txt_Color');





         SupPagesWishCompEComDesign::orderBy('id','desc')->update($data);


             session()->flash('success',trans('admin.Updated'));
             return back();

    }

    //  E-Commercce =========================  End Design   ============================


//========================== View ==============================

    //Session

     public function OldChangeCountrySession($id){
           Cart::destroy();
             session()->put('ChangeCountryy',$id);
                  return back();
    }


 public function ChangeCountrySession(){

     $id=request('Country');
           Cart::destroy();
             session()->put('ChangeCountryy',$id);
                  return back();
    }


    //Home Page
      public function HomePage(){
          $Comp=CompanyData::orderBy('id','desc')->first();
          $Sliders=Webslider::where('Status',1)->get();
          $Brands=Brands::whereIn('Store_Show',[1,3])->take(6)->get();
          $Articles=Articles::orderBy('id','desc')->take(9)->get();
          $Footers=BefroeFooter::all();
          $Groups=ItemsGroups::orderBy('Arrange','asc')->whereIn('Store_Show',[1,3])->where('Parent',0)->get();
          $ProductsNew=Products::whereIn('Store_Show',[1,3])
              ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
              ->where('Store_Type',0)
              ->where('Status',0)
              ->where('Delete',0)
              ->orderBy('Arrange','asc')->take(50)->get();
          $ProductsOffers=Products::whereIn('Store_Show',[1,3])
              ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
              ->where('Store_Type',1)
              ->where('Status',0)
              ->where('Delete',0)
              ->orderBy('Arrange','asc')->take(50)->get();
          $OneAds=ProDetailsImg::find(1);
          $TwoAds=ProDetailsImg::find(2);
          $ThreeAds=ProDetailsImg::find(3);
          $FourAds=ProDetailsImg::find(4);
          $Befores=BefroeFooter::all();

         return view('site.home',get_defined_vars());
    }

     public function AboutSite(){
          $About=About::orderBy('id','desc')->first();
         return view('site.About',get_defined_vars());
    }

       public function ContactSite(){

          $Contact=ContactUS::orderBy('id','desc')->first();
         return view('site.Contact',get_defined_vars());
    }

       public function PrivacyPolicySite(){
          $Ploicy=Polices::orderBy('id','desc')->first();
         return view('site.Polices',get_defined_vars());
    }

       public function TermsSite(){
          $Terms=Terms::orderBy('id','desc')->first();
         return view('site.Terms',get_defined_vars());
    }

       public function FAQSite(){
          $FAQs=FAQ::all();
         return view('site.FAQs',get_defined_vars());
    }

       public function BlogsSite(){

          $Articles=Articles::paginate(9);
         return view('site.Articles',get_defined_vars());
    }

     public function BlogDetails($id){

          $art=Articles::find($id);
         $Articles=Articles::paginate(3);
         return view('site.ArticleDetails',get_defined_vars());
    }


      //PostMsgRqst
      public function PostMsgRqst(){

          try {
              DB::beginTransaction();

        $data= $this->validate(request(),[
             'Name'=>'required',
             'Email'=>'required',
             'Subject'=>'required',
             'Msg'=>'required',
             'Phone'=>'required',
               ],[


         ]);

         $data['Name']=request('Name');
         $data['Email']=request('Email');
         $data['Subject']=request('Subject');
         $data['Msg']=request('Msg');
         $data['Phone']=request('Phone');
         MsgRqst::create($data);

              DB::commit();

             session()->flash('success',trans('admin.Thanks'));
             return back();

          }catch(\Exception $ex){

              $MODEL=MsgRqst::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=MsgRqst::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

      }

    //Login Site
     public function LoginSite(){
         return view('site.Login');
    }

       public function RegisterSite(){
            $Countris=Countris::all();
         return view('site.Register',['Countris'=>$Countris]);
    }

    public function PostRegister(){

        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
             'Name'=>'required',
             'email'=>'required|email|unique:customers',
             'Phone'=>'required|unique:customers',
             'password'=>'required|min:6',

               ],[
            'Name.required' => trans('admin.nameRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),
            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),


         ]);

            $Acc=$this->CreateAccount(request('Name'),request('Name') ,24 ,null);


        $data['Date']=date('Y-m-d');
        $data['Name']=request('Name');
        $data['NameEn']=request('Name');
        $data['Price_Level']=1;
        $data['Phone']=request('Phone');
        $data['email']=request('email');
        $data['password']=bcrypt(request('password'));
        $data['country']=request('country');
    $data['Account']=$Acc;
     Customers::create($data);

     DB::commit();

             session()->flash('success',trans('admin.Registerd_Successfully'));
             return back();

        }catch(\Exception $ex){

            $MODEL=Customers::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Customers::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

       public function PostLoginSite(){

           try {
               DB::beginTransaction();
       if(auth()->guard('client')->attempt(['email'=>request('Email'),'password'=>request('Password')])){

           DB::commit();
          return redirect('/');

       }else{
           DB::rollBack();
          session()->flash('error',trans('admin.incorrect_information_login'));
       	 return back();
       }


           }catch(\Exception $ex){


               DB::rollBack();
               Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }catch(\Error $ex){


               DB::rollBack();
               Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }


    }

         public function LogoutSite(){

             try {
                 DB::beginTransaction();
            Cart::destroy();
    auth()->guard('client')->logout();
    DB::commit();
	     return redirect('/');

             }catch(\Exception $ex){


                 DB::rollBack();
                 Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

                 session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
                 return back();

             }catch(\Error $ex){


                 DB::rollBack();
                 Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

                 session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
                 return back();

             }

 }

     public function ForgotSite(){
         return view('site.Forget');
    }

     public function PostForgotSite(){

         try {
             DB::beginTransaction();
         $admin = Customers::where('email',request('Email'))->first();
               if(!empty($admin)){


                   $code=rand(10,10000);
                   Customers::where('id',$admin->id)->update(['code'=>$code]);

                 Mail::to($admin->Email)->send(new UserResetPassword(['data'=>$admin]));
                   session()->flash('success',trans('admin.Reset_Password'));

                   DB::commit();
                    return view('site.VerifyCode',['admin'=>$admin]);

               }else{
                   DB::rollBack();
                session()->flash('success',trans('admin.WrongEmail'));
  return back();

               }


         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

        }

  public function PostCodeSite(){

      try {
          DB::beginTransaction();

         $admin = Customers::where('id',request('user'))->first();
               if($admin->code == request('code')){

                   Customers::where('id',$admin->id)->update(['code'=>null]);
DB::commit();
                    return view('site.ResetPassword',['admin'=>$admin]);

               }else{
                   DB::rollBack();
                session()->flash('error',trans('admin.WrongCode'));
                return view('site.VerifyCode',['admin'=>$admin]);

               }


      }catch(\Exception $ex){


          DB::rollBack();
          Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

          session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
          return back();

      }catch(\Error $ex){


          DB::rollBack();
          Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

          session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
          return back();

      }

        }

     public function PostResetPassword(){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[

             'Password'=>'required|min:6|same:confirm',

               ],[

            'Password.required' =>trans('admin.passwordRequired'),
            'Password.min' => trans('admin.passwordmin_6'),
            'Password.same' => trans('admin.passwordsame'),

         ]);


         $data['password']=bcrypt(request('Password'));

         Customers::where('id',request('user'))->update($data);

          if(auth()->guard('client')->attempt(['email'=>request('Email'),'password'=>request('Password')])){

              DB::commit();
          return redirect('/');

       }
         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }


//My Account
  public function MyAccountSite(){
         $User=Customers::find(auth()->guard('client')->user()->id);
      $Addresses=Addressses::where('Customer',auth()->guard('client')->user()->id)->get();
      $Countris=Countris::all();
      $Governrates=Governrate::where('Country',auth()->guard('client')->user()->country)->get();
      $Orders=SalesOrder::where('Client',auth()->guard('client')->user()->Account)->paginate(9);
         return view('site.MyAccount',get_defined_vars());
    }

     public function UpdateAccount(){
         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Name'=>'required',
              'email'=>'required|email|unique:customers,email,'.auth()->guard('client')->user()->id,
             'Phone'=>'required|unique:customers,Phone,'.auth()->guard('client')->user()->id,

               ],[
            'Name.required' => trans('admin.nameRequired'),
            'country.required' => trans('admin.countryRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),

         ]);


         $data['Name']=request('Name');
         $data['NameEn']=request('Name');
       $data['Phone']=request('Phone');
    $data['email']=request('email');
    $data['country']=request('country');
         Customers::where('id',auth()->guard('client')->user()->id)->update($data);

             DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();
         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }


        public function GovernrateFilter($id) {

               if(app()->getLocale() == 'ar' ){
       $states = DB::table("cities")->where("Gov",$id)->pluck("Arabic_Name","id");
               }else{
          $states = DB::table("cities")->where("Gov",$id)->pluck("English_Name","id");
               }
       return response()->json($states);

    }

      public function CityFilter($id) {

               if(app()->getLocale() == 'ar' ){
       $states = DB::table("places")->where("City",$id)->pluck("Arabic_Name","id");
               }else{
           $states = DB::table("places")->where("City",$id)->pluck("English_Name","id");
               }

       return response()->json($states);

    }

    public function CityShip($id) {


        $states=[];

       $X = DB::table("cities")->where("id",$id)->first();


           $states +=['ship'=>$X->Ship_Price];

       return response()->json($states);

    }


     public function UpdatePassword(){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[

             'password'=>'required|min:6|same:Confirm_Password',

               ],[

            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),
            'password.same' => trans('admin.passwordsame'),

         ]);

         $user= Customers::find(auth()->guard('client')->user()->id);

             if (Hash::check(request('CurrentPassword'), $user->password)) {

                       $data['password']=bcrypt(request('password'));

                Customers::where('id',auth()->guard('client')->user()->id)->update($data);
                DB::commit();
                       session()->flash('success',trans('admin.Updated'));
             return back();

             }else{
                 DB::rollBack();
                         session()->flash('error',trans('admin.CurrentPassWrong'));
             return back();
             }

         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }




    }


     public function EditMyAddress(){

         try {
             DB::beginTransaction();

            $Addr['Address_Name']=request('Address_Name');
            $Addr['Street']=request('StreetAdd');
            $Addr['Special_Mark']=request('Special_MarkAdd');
            $Addr['Buliding']=request('BulidingAdd');
            $Addr['Floor']=request('FloorAdd');
            $Addr['Flat']=request('FlatAdd');
            $Addr['Details']=request('Address_DetailsAdd');
            $Addr['Location']=request('LocationAdd');
            $Addr['Governrate']=request('GovernrateAdd');
            $Addr['City']=request('CityAdd');
            $Addr['Place']=request('PlaceAdd');


           Addressses::where('id',request('ID'))->update($Addr);
DB::commit();

             session()->flash('success',trans('admin.Updated'));
             return back();

         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }
     public function UpdateAddress(){

         try {
             DB::beginTransaction();

            Addressses::where('Customer',auth()->guard('client')->user()->id)->delete();

            $Addr['Address_Name']=request('Address_Name');
            $Addr['Street']=request('StreetAdd');
            $Addr['Special_Mark']=request('Special_MarkAdd');
            $Addr['Buliding']=request('BulidingAdd');
            $Addr['Floor']=request('FloorAdd');
            $Addr['Flat']=request('FlatAdd');
            $Addr['Details']=request('Address_DetailsAdd');
            $Addr['Location']=request('LocationAdd');
            $Addr['Governrate']=request('GovernrateAdd');
            $Addr['City']=request('CityAdd');
            $Addr['Place']=request('PlaceAdd');
            $Addr['Customer']=auth()->guard('client')->user()->id;

           Addressses::create($Addr);
DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();

         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }


     }


    public function DeleteMyAddress($id){

        try {
            DB::beginTransaction();
            $del=Addressses::find($id);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

}

    //Wishlist
     public function WishlistPage(){
        $Wishs=Wishlist::where('User',auth()->guard('client')->user()->id)->paginate(6);
         return view('site.Wishlist',[
             'Wishs'=>$Wishs,
         ]);
    }

     public function AddWish($id){
         try {
             DB::beginTransaction();
         $data['Product']=$id;
         $data['User']=auth()->guard('client')->user()->id;
         Wishlist::create($data);
         DB::commit();
             return back();
         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }

       public function DeleteWish($id){

           try {
               DB::beginTransaction();
            $del=Wishlist::find($id);
            $del->delete();
               DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
           }catch(\Exception $ex){


               DB::rollBack();
               Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }catch(\Error $ex){


               DB::rollBack();
               Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }

}


       //Compare
     public function ComparePage(){
        $Comps=Compare::where('User',auth()->guard('client')->user()->id)->orderBy('id','desc')->take(3)->get();
         return view('site.Compare',[
             'Comps'=>$Comps,
         ]);
    }

     public function AddCompare($id){

         try {
             DB::beginTransaction();
         $data['Product']=$id;
         $data['User']=auth()->guard('client')->user()->id;

         Compare::create($data);
         DB::commit();
             return back();
         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }


       public function DeleteCompare($id){

           try {
               DB::beginTransaction();
            $del=Compare::find($id);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
           }catch(\Exception $ex){


               DB::rollBack();
               Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }catch(\Error $ex){


               DB::rollBack();
               Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

               session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
               return back();

           }

}

//Shop
    public function ShopSite(){

        $Products=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')
            ->paginate(24);
        $Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->take(6)->orderBy('Arrange','asc')->get();
        $Brands=Brands::whereIn('Store_Show',[1,3])->take(6)->get();

        $ProductsNew=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Store_Type',0)
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')->take(5)->get();
         return view('site.Shop',get_defined_vars());
    }

    public function ProductDetails($id){
        $pro=Products::find($id);

        $ProductGroups=Products::orderBy('id','desc')
            ->where('id','!=',$pro->id)
            ->whereIn('Store_Show',[1,3])
            ->where('Group',$pro->Group)
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Status',0)
            ->orderBy('Arrange','asc')
            ->take(5)->get();

        $ProductBrands=Products::orderBy('id','desc')
            ->where('id','!=',$pro->id)
            ->whereIn('Store_Show',[1,3])
            ->where('Brand',$pro->Brand)
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Status',0)
            ->orderBy('Arrange','asc')
            ->take(5)->get();

        $SubImages=SubImages::where('Product',$pro->id)->get();
        $Comments=Comments::where('Product',$pro->id)->get();
        $countReviews=Comments::where('Product',$pro->id)->count();

        $Uni=ProductUnits::where('Product',$pro->id)->where('Def',1)->first();
        $ProDetailsImg=ProDetailsImg::all();
        $Terms=Terms::orderBy('id','desc')->first();
        $Polices=Polices::orderBy('id','desc')->first();
        $NAMEVirable='';
        $NAMEVirable2='';
        $Viras='';
        $Viras2='';

        $salesDef=SalesDefaultData::latest()->first();

        if($pro->P_Type == 'Single_Variable'){

            $v=ProductsVira::where('Product',$pro->id)->orderBy('id','desc')->first();

            if(app()->getLocale() == 'ar' ){
                $NAMEVirable=$v->V1()->first()->V_ID()->first()->Name;
            }else{
                $NAMEVirable=$v->V1()->first()->V_ID()->first()->NameEn;
            }

            $Viras=SubVirables::where('V_ID',$v->V1()->first()->V_ID)->get();

        }elseif($pro->P_Type == 'Duble_Variable'){


            $v=ProductsVira::where('Product',$pro->id)->orderBy('id','desc')->first();



            if(app()->getLocale() == 'ar' ){
                $NAMEVirable=$v->V1()->first()->V_ID()->first()->Name;
            }else{
                $NAMEVirable=$v->V1()->first()->V_ID()->first()->NameEn;
            }

            $Viras=SubVirables::where('V_ID',$v->V1()->first()->V_ID)->get();




            if(app()->getLocale() == 'ar' ){
                $NAMEVirable2=$v->V2()->first()->V_ID()->first()->Name;
            }else{
                $NAMEVirable2=$v->V2()->first()->V_ID()->first()->NameEn;
            }

            $Viras2=SubVirables::where('V_ID',$v->V2()->first()->V_ID)->get();


        }


         return view('site.ProductDetails',get_defined_vars());
    }


    public function  SiteProQty(Request $request) {


 $CODE = $request->get('CODE');
 $STORE = $request->get('STORE');
 $PRODUCT = $request->get('PRODUCT');
     $states=[];
        $salesDef=SalesDefaultData::latest()->first();


            $QTY = $this->ProAvQties($STORE, $PRODUCT, $CODE);

            if (!empty($QTY)) {

                $AvQty = $QTY->Qty;
                $Code = $QTY->P_Code;

            } else {
                $AvQty = 0;
                $Code = '';


            }

        if($salesDef->Ecommerce_Sales == 2) {

            $AvQty=1000;
        }

 $states += ['qty' => $AvQty ,'code'=>$Code];
       return response()->json($states);


    }

      public function  SiteProQtyV(Request $request) {


 $V = $request->get('V');
 $STORE = $request->get('STORE');
 $PRODUCT = $request->get('PRODUCT');
     $states=[];

          $QTY=ProductsQty::
                where('Product',$PRODUCT)
                    ->where('Store',$STORE)
                    ->where('V1',$V)
                    ->first();

        if(!empty($QTY)){

          $AvQty=$QTY->Qty;
          $Code=$QTY->P_Code;
          $price=$QTY->Price_Sale;
        }else{
          $AvQty=0;
            $Code='';
            $price=0;
        }

          $salesDef=SalesDefaultData::latest()->first();

          if($salesDef->Ecommerce_Sales == 2) {

              $AvQty=1000;
          }


          $states += ['qty' => $AvQty,'code'=>$Code , 'price'=>$price ];
       return response()->json($states);


    }

      public function  SiteProQtyVV(Request $request) {


 $V = $request->get('V');
 $VV = $request->get('VV');
 $STORE = $request->get('STORE');
 $PRODUCT = $request->get('PRODUCT');
     $states=[];

   $QTY=ProductsQty::
                where('Product',$PRODUCT)
                    ->where('Store',$STORE)
                    ->where('V1',$V)
                    ->where('V2',$VV)
                    ->first();




        if(!empty($QTY)){

          $AvQty=$QTY->Qty;
          $Code=$QTY->P_Code;
              $price=$QTY->Price_Sale;
        }else{
          $AvQty=0;
            $Code='';
                $price=0;
        }

          $salesDef=SalesDefaultData::latest()->first();

          if($salesDef->Ecommerce_Sales == 2) {

              $AvQty=1000;
          }


          $states += ['qty' => $AvQty,'code'=>$Code, 'price'=>$price];
       return response()->json($states);


    }

//Filters
     public function ShopFilterName(){

         if(!empty(request('search'))){
             $search=request('search');

             $Products=Products::
                 where('P_Ar_Name','ILIKE', "%{$search}%")
                 ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                 ->where('Status',0)
                 ->where('Delete',0)
                 ->whereIn('Store_Show',[1,3])
                 ->orderBy('Arrange','asc')
                 ->paginate(24);


         }else{

             $Products=Products::whereIn('Store_Show',[1,3])
                 ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
                 ->where('Status',0)
                 ->where('Delete',0)
                 ->whereIn('Store_Show',[1,3])
                 ->orderBy('Arrange','asc')
                 ->paginate(24);

         }


         $Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->orderBy('Arrange','asc')->take(6)->get();
         $Brands=Brands::whereIn('Store_Show',[1,3])->take(6)->get();

         $ProductsNew=Products::whereIn('Store_Show',[1,3])
             ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
             ->where('Store_Type',0)
             ->where('Status',0)
             ->where('Delete',0)
             ->orderBy('Arrange','asc')->take(5)->get();

         return view('site.Shop',get_defined_vars());


    }

    public function ShopFilterBrand($id){

        $Products=Products::whereIn('Store_Show',[1,3])
            ->where('Brand',$id)
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')
            ->paginate(24);

        $Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->orderBy('Arrange','asc')->take(6)->get();
        $Brands=Brands::whereIn('Store_Show',[1,3])->take(6)->get();

        $ProductsNew=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Store_Type',0)
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')->take(5)->get();
         return view('site.Shop',get_defined_vars());
    }

    public function FilterShopCat($id){
        $Products=Products::whereIn('Store_Show',[1,3])
            ->where('Group',$id)
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')
            ->paginate(24);

        $Groups=ItemsGroups::whereIn('Store_Show',[1,3])->where('Parent',0)->orderBy('Arrange','asc')->take(6)->get();
        $Brands=Brands::whereIn('Store_Show',[1,3])->take(6)->get();

        $ProductsNew=Products::whereIn('Store_Show',[1,3])
            ->whereIn('P_Type',['Completed','Single_Variable','Duble_Variable'])
            ->where('Store_Type',0)
            ->where('Status',0)
            ->where('Delete',0)
            ->orderBy('Arrange','asc')->take(5)->get();
         return view('site.Shop',get_defined_vars());
    }


    //Comments
      public function AddComment(){

          try {
              DB::beginTransaction();
        $data= $this->validate(request(),[
             'Comment'=>'required',
               ],[


         ]);


         $data['Product']=request('Product');
         $data['User']=auth()->guard('client')->user()->id;
         $data['Comment']=request('Comment');
         $data['Date']=date('Y-m-d');
         Comments::create($data);

              DB::commit();
             session()->flash('success',trans('admin.Thanks'));
             return back();
          }catch(\Exception $ex){


              DB::rollBack();
              Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              DB::rollBack();
              Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

    }

      public function DeleteComment($id){
          try {
              DB::beginTransaction();
            $del=Comments::find($id);
            $del->delete();
              DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
          }catch(\Exception $ex){


              DB::rollBack();
              Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              DB::rollBack();
              Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

}

     public function EditComment(){

         try {
             DB::beginTransaction();
        $data= $this->validate(request(),[
             'Comment'=>'required',
               ],[


         ]);
         Comments::where('id',request('ID'))->update(['Comment'=>request('Comment')]);
             DB::commit();
             session()->flash('success',trans('admin.Updated'));
             return back();
         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }

    }


    //Rate
      public function AddRate(){

          try {
              DB::beginTransaction();
        $data= $this->validate(request(),[
             'Rate'=>'required',
               ],[


         ]);


         $data['Product']=request('Product');
         $data['User']=auth()->guard('client')->user()->id;
         $data['Rate']=request('Rate');
         Rate::create($data);

        $count=Rate::where('Product',request('Product'))->count();
        $Sumcount=Rate::where('Product',request('Product'))->get()->sum('Rate');

          $result= $Sumcount / $count ;
          Products::where('id',request('Product'))->update(['rate'=>$result]);

              DB::commit();
             session()->flash('success',trans('admin.Thanks'));
             return back();
          }catch(\Exception $ex){


              DB::rollBack();
              Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              DB::rollBack();
              Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

    }

      public function EditRate(){

          try {
              DB::beginTransaction();
        $data= $this->validate(request(),[
             'Rate'=>'required',
               ],[


         ]);


         $data['Rate']=request('Rate');
         Rate::where('id',request('ID'))->update($data);

        $count=Rate::where('Product',request('Product'))->count();
        $Sumcount=Rate::where('Product',request('Product'))->get()->sum('Rate');

          $result= $Sumcount / $count ;
          Products::where('id',request('Product'))->update(['rate'=>$result]);
              DB::commit();
             session()->flash('success',trans('admin.Thanks'));
             return back();
          }catch(\Exception $ex){


              DB::rollBack();
              Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              DB::rollBack();
              Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

    }


    //Cart
     public function AddToCart(){

         if(request('qty') > request('AVQTY')){
                 session()->flash('error',trans('admin.QtyMoreAvQty'));
             return back();
         }

         $qty=request('qty');
         $Price=request('Price');
         $pro =Products::find(request('Product'));

            $Name=$pro->P_Ar_Name;
            $OtherName=$pro->P_En_Name;

$Ses=Countris::find(session()->get('ChangeCountryy'));

       Cart::add(['id' =>$pro->id, 'name' =>$Name, 'qty' => $qty, 'price' =>$Price, 'weight' =>0 ,'tax'=>0, 'options' => ['image' => $pro->Image ,'store' => $Ses->Store , 'code' => request('P_Code') , 'AvQty'=>request('AVQTY'),'other_name'=>$OtherName] ]);


       return redirect('CartSite');
    }

     public function CartSite(){

        $Carts=Cart::content();
         $x=0;

         return view('site.Cart',[
             'Carts'=>$Carts,
             'x'=>$x,
         ]);
    }

    public function DeleteCart($id){
          Cart::update($id,0);
           return back();
     }

    public function UpdateCart(){

         $qty=request('qty');
         $AvQty=request('AvQty');
         $rowId=request('RowID');
       for($i=0; $i < count($rowId) ; $i++){
           if($qty[$i] > $AvQty[$i]){
               session()->flash('error',trans('admin.QtyMoreAvQty'));
             return back();
           }else{
           Cart::update($rowId[$i],$qty[$i]);
           }
       }

         return back();

     }

     public function UpdateCuponCode(){

         try {
             DB::beginTransaction();
        $i=CouponCode::where('Code',request('code'))->first();

         if(!empty($i->id)){

            if($i->Status == 1){

                DB::rollBack();
            session()->flash('error',trans('admin.Code_Expired'));
             return back();

            }elseif($i->Expire < date('Y-m-d')){

                DB::rollBack();
              session()->flash('error',trans('admin.Code_Expired'));
             return back();

            }else{


                    if(request('code') != NULL){

                $y=$i->Used + 1 ;

                if($y == $i->Num){

                    $Status=1;
                }else{

                    $Status=0;
                }
             CouponCode::where('id',$i->id)->update(['Used'=>$y,'Status'=>$Status]);

          }


             $x=$i->Amount;
                    DB::commit();
           session()->flash('success',trans('admin.Correct_Code'));

        $Carts=Cart::content();


         return view('site.Cart',[
             'Carts'=>$Carts,
             'x'=>$x,
         ]);


            }


         }else{

             DB::rollBack();
              session()->flash('error',trans('admin.Wrong_Code'));
             return back();

         }

         }catch(\Exception $ex){


             DB::rollBack();
             Log::channel('custom')->error('Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }catch(\Error $ex){


             DB::rollBack();
             Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

             session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
             return back();

         }



     }

    //CheckoutPage
      public function Checkout(){

         $Carts=Cart::content();

          if(!empty(auth()->guard('client')->user()->id)){
    $Addresses=Addressses::where('Customer',auth()->guard('client')->user()->id)->get();
          }else{
             $Addresses='';
          }
          $x=session()->get('CODE');
        $Ses=Countris::find(session()->get('ChangeCountryy'));
          $Governrates=Governrate::where('Country',$Ses->id)->get();
         return view('site.Checkout',get_defined_vars());
    }

      public function ChangeAddressSite(Request $request) {


           $id = $request->get('Address');

          $states=[];

     $adress=Addressses::find($id);
 $states += ['Address_Name' => $adress->Address_Name,'Special_MarkAdd'=>$adress->Special_Mark,'StreetAdd'=>$adress->Street,'BulidingAdd'=>$adress->Buliding,'FloorAdd'=>$adress->Floor,'FlatAdd'=>$adress->Flat,'LocationAdd'=>$adress->Location,'Address_DetailsAdd'=>$adress->Details,'Gov'=>$adress->Governrate,'GovName'=>$adress->Governrate()->first()->Arabic_Name,'Cit'=>$adress->City,'CitName'=>$adress->City()->first()->Arabic_Name , 'Pla'=>$adress->Place,'PlaName'=>$adress->Place()->first()->Arabic_Name];


       return response()->json($states);

    }

    //Orders
      public function PlaceOrder(Average $average){

          try {
              DB::beginTransaction();


              $Carts=Cart::content();


          $TotQty=0;

          foreach($Carts as $cart){
              $TotQty += $cart->qty ;
          }

          $Ses=Countris::find(session()->get('ChangeCountryy'));
        $DEEF=SalesDefaultData::orderBy('id','desc')->first();
              $def=StoresDefaultData::latest('id')->first();
        if($DEEF->ECommercceSaleType == 1){
           $HOLDD=1;
        }else{
          $HOLDD=0;
        }

              if(!empty(auth()->guard('client')->user()->id)){
                  $Client=AcccountingManual::where('id',auth()->guard('client')->user()->Account)->first()->id;
              }else{
                  $Client=$DEEF->Client;
              }

        $ID = DB::table('sales_orders')->insertGetId(
        array(
            'Date' => date('Y-m-d'),
            'Time' => date("h:i:s a", time()),
            'Draw' => $Ses->Coin()->first()->Draw,
            'Payment_Method' => request('Payment_Method'),
            'Status' => request('Status'),
            'Refernce_Number' => null,
            'Note' => null,
            'Product_Numbers' => Cart::content()->count(),
            'Total_Qty' => $TotQty,
            'Total_Discount' => 0,
            'Total_BF_Taxes' => request('Total_Price'),
            'Total_Taxes' => 0,
            'Total_Price' => request('Total_Price'),
            'Pay' => 0,
            'CuponCode' => request('CuponCode'),
            'Shipping' => request('Shipping'),
            'Delivery_Status' => 0,
            'Order_Type' => 1,
            'Name' => request('Name'),
            'Email' => request('Email'),
            'Phone' => request('Phone'),
            'OtherPhone' => request('OtherPhone'),
            'Address_Name' => request('Address_Name'),
            'Special_MarkAdd' => request('Special_MarkAdd'),
            'StreetAdd' => request('StreetAdd'),
            'BulidingAdd' => request('BulidingAdd'),
            'FloorAdd' => request('FloorAdd'),
            'FlatAdd' => request('FlatAdd'),
            'Governrate' => request('Governrate'),
            'City' => request('City'),
            'Place' => request('Place'),
            'LocationAdd' => request('LocationAdd'),
            'Address_DetailsAdd' => request('Address_DetailsAdd'),
            'Safe' => $Ses->Safe,
            'Later_Due' => null,
            'Sale_Date' => null,
            'ToSales' => 0,
            'Client' => $Client,
            'Delegate' =>null,
            'Executor' =>null,
            'Store' => $Ses->Store,
            'Coin' => $Ses->Coin,
            'Cost_Center' =>null,
            'presenter' => null,
            'annual_interest' =>null,
            'monthly_installment' => null,
            'Years_Number' =>null,
            'total' => null,
            'Quote' => null,
            'installment_Num' => null,
            'Date_First_installment' => null,
            'User' => 1,
            'Delegate_Recived' =>0,
            'Delegate_Recived_Time' =>null,
            'To_Sales_Time' =>null,
            'Cancel_Order' =>0,
            'Cancel_Order_Time' =>null,
            'Hold_Qty' =>$HOLDD,
            'Total_Wight_Bill' =>0,
            'Edit' => 0,
            'Delete' => 0,
            'Edit_New_Code' => 0,
            'Current_Credit' =>0,
            'Total_Net' => request('Total_Price'),
            'Residual' => 0,
            'ProfitPrecent' =>0,
            'Total_Cost' =>0 ,



        )
    );


        $CodeT=SalesOrder::findOrFail($ID)->Code;

         $notii['Date']=date('Y-m-d');
         $notii['Status']=0;
         $notii['Noti_Ar_Name']='طلب مبيعات متجر';
         $notii['Noti_En_Name']='Store Online Order';
         $notii['Type']='طلب مبيعات متجر';
         $notii['TypeEn']='Store Online Order';
         $notii['Type_Code']=$CodeT;
         $notii['Emp']= null;
         $notii['Client']=$Client;
         $notii['Product']=null;
         $notii['Store']=$Ses->Store;
         $notii['Safe']=$Ses->Safe;
         Notifications::create($notii);
         notify()->success(trans('admin.Online_Order'));

             foreach($Carts as $cart){

                 $QTY=$this->ProAvQties($Ses->Store,$cart->id,$cart->options->code);

                 $pp=ProductUnits::where('Product',$cart->id)->where('Unit',$QTY->Unit)->first();
                 $plow=ProductUnits::where('Product',$cart->id)->where('Rate',1)->first();
                 $rr = ProductUnits::where("Unit",$QTY->Unit)->where('Product',$cart->id)->first();
                 $SS=Stores::find($Ses->Store);
                 $PSS=Products::find($cart->id);
                 $prooooo=Products::find($cart->id);
                 $costPrice=$average->AverageCostGetUnit($cart->id,$cart->options->code,$Ses->Store,$QTY->Unit);

                $uu['Product_Code']=$QTY->P_Code;
                $uu['P_Ar_Name']=$QTY->P_Ar_Name;
                $uu['P_En_Name']=$QTY->P_En_Name;
                $uu['V_Name']=$QTY->V_Name;
                $uu['VV_Name']=$QTY->VV_Name;
                $uu['Original_Qty']=$cart->qty;
                $uu['Qty']=$cart->qty;
                $uu['AvQty']=$QTY->Qty;
                $uu['Price']=$cart->price;
                $uu['Discount']=0;
                $uu['Tax']=1;
                $uu['Total_Bf_Tax']=$cart->total;
                $uu['Total_Tax']=0;
                $uu['Total']=$cart->total;
                $uu['Store']=$Ses->Store;
                $uu['Product']=$cart->id;
                $uu['Unit']=$QTY->Unit;
                $uu['Exp_Date']=null;
                $uu['SalesOrder']=$ID;
                $uu['V1']=$QTY->V1;
                $uu['V2']=$QTY->V2;
                $uu['Patch_Number']=null;
                 $uu['TDiscount']=0;
                 $uu['Total_Net']=$cart->price * $cart->qty ;
                 $uu['SalesProDesc']=null;
                 $uu['SmallCode']=$plow->Barcode;
                 $uu['weight']=0;
                 $uu['Total_Wight']=0;
                 $uu['SmallQty']=$cart->qty * $pp->Rate;
                 $uu['UnitRate']=$pp->Rate;
                 $uu['Date']=date('Y-m-d');
                 $uu['Branch']=$SS->Branch;
                 $uu['Group']=$PSS->Group;
                 $uu['Brand']=$PSS->Brand;
                 $uu['CostPrice']=$costPrice;
                 $uu['TotCostNew']=$costPrice * $cart->qty;
               ProductSalesOrder::create($uu);

                 if($DEEF->ECommercceSaleType == 1){

                     if($prooooo->P_Type == 'Assembly'){

                         $Asembs=AssemblyProducts::where('p_id',$cart->id)->get();

                         foreach($Asembs as $ass){


                             $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();
                             $Quantity = $this->ProAvQties($Ses->Store,$ass->Product,$ass->P_Code);

                             $qq = $unit->Rate * ($cart->qty * $ass->Qty) ;

                             $ty = $average->AverageCostGetUnit($ass->Product,$ass->P_Code, $Ses->Store, $ass->Unit);

                             if (!empty($Quantity)) {
                                 $hold_qty = $Quantity->Hold_Qty + $qq;
                                 $newqty = $Quantity->Qty - $qq;
                                 if($newqty < 0){
                                    DB::rollback();
                                     session()->flash('error',trans('admin.Not_Enough_Qty'));
                                    return back();
                                 }
                                 $cur = $newqty * ($ty / $unit->Rate);
                                 ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur, 'Hold_Qty' => $hold_qty]);

                             }


                             //Fifo
                             if ($def->Cost_Price == 2) {

                                 $fifo=$this->FifoAvQtyDate($Ses->Store,$ass->Product, $ass->P_Code);


                                 if (!empty($fifo)) {

                                     if ($fifo->Qty >= ($cart->qty * $ass->Qty)) {


                                         $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                         $qq = $unit->Rate * ($cart->qty * $ass->Qty);

                                         $newqty = $fifo->Qty - $qq;
                                         $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                         if($newqty < 0){
                                             DB::rollback();
                                             session()->flash('error',trans('admin.Not_Enough_Qty'));
                                             return back();

                                         }
                                         FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);





                                     } else {


                                         $resdiualQty = ($cart->qty * $ass->Qty) - $fifo->Qty;

                                         $unit = ProductUnits::where('Unit', $ass->Unit)->where('Product', $ass->Product)->first();

                                         $qq = $unit->Rate * ($fifo->Qty * $ass->Qty);

                                         $newqty = $fifo->Qty - $qq;
                                         if($newqty < 0){
                                             DB::rollback();
                                             session()->flash('error',trans('admin.Not_Enough_Qty'));
                                             return back();
                                         }
                                         $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                         FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                                         $ResdiualCost = $this->FifoStoreAssemblyHoldQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $ass->Unit, $ass->Qty, $ID);


                                     }


                                 }


                             }



                         }


                     }elseif($prooooo->P_Type != 'Service' and $prooooo->P_Type != 'Subscribe') {



                         $unit = ProductUnits::where('Unit', $QTY->Unit)->where('Product', $cart->id)->first();
                         $Quantity = $this->ProAvQties($Ses->Store, $cart->id, $QTY->P_Code);

                         $qq = $unit->Rate * $cart->qty;

                         $ty = $average->AverageCostGetUnit($cart->id, $plow->Barcode, $Ses->Store, $QTY->Unit);

                         if (!empty($Quantity)) {
                             $hold_qty = $Quantity->Hold_Qty + $qq;
                             $newqty = $Quantity->Qty - $qq;
                             $cur = $newqty * ($ty / $unit->Rate);
                             if($newqty < 0){
                                 DB::rollback();
                                 session()->flash('error',trans('admin.Not_Enough_Qty'));
                                 return back();

                             }
                             ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur, 'Hold_Qty' => $hold_qty]);

                         }



                         //Fifo

                         if ($def->Cost_Price == 2) {

                             $fifo=$this->FifoAvQtyDate($Ses->Store ,$cart->id, $QTY->P_Code);


                             if (!empty($fifo)) {

                                 if ($fifo->Qty >= $cart->qty) {


                                     $unit = ProductUnits::where('Unit', $QTY->Unit)->where('Product', $cart->id)->first();

                                     $qq = $unit->Rate *$cart->qty;

                                     $newqty = $fifo->Qty - $qq;

                                     $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                     if($newqty < 0){

                                         DB::rollback();
                                         session()->flash('error',trans('admin.Not_Enough_Qty'));
                                         return back();

                                     }
                                     FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);




                                 } else {


                                     $resdiualQty = $cart->qty - $fifo->Qty;

                                     $unit = ProductUnits::where('Unit', $QTY->Unit)->where('Product', $cart->id)->first();

                                     $qq = $unit->Rate * $fifo->Qty;

                                     $newqty = $fifo->Qty - $qq;


                                     if($newqty < 0){
                                         DB::rollback();
                                         session()->flash('error',trans('admin.Not_Enough_Qty'));
                                         return back();

                                     }
                                     $hold_qty_fifo = $fifo->Hold_Qty + $qq;

                                     FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty,'Hold_Qty'=>$hold_qty_fifo]);


                                     $ResdiualCost = $this->FifoStoreHoldQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $QTY->Unit, $ID);


                                 }


                             }


                         }


                     }

                 }

            }


 $totalCost=ProductSalesOrder::where('SalesOrder',$ID)->get()->sum('TotCostNew');

               $PROFIIIT =$totalCost - request('Total_Price');
                $nfd = ($PROFIIIT * 100) / $totalCost;

              SalesOrder::where('id',$ID)->update([
                  'ProfitPrecent'=>$nfd,
                  'Total_Cost'=>$totalCost,
              ]);


                Cart::destroy();
                DB::commit();

             session()->flash('success',trans('admin.Order_Successfully'));
          return redirect('/');

          }catch(\Exception $ex){

              $MODEL=SalesOrder::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }catch(\Error $ex){


              $MODEL=SalesOrder::class;
              DB::rollBack();
              Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

              session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
              return back();

          }

    }


}
