<?php

namespace App\Http\Controllers;

use App\Events\SalaryDue;
use App\Http\Requests\EmpRequest;
use App\Services\HRService;
use Illuminate\Http\Request;
use App\Models\StoresDefaultData;
use Illuminate\Support\Facades\Log;
use App\Models\WorkDepartments;
use App\Models\ModuleSettingsNum;
use App\Models\OutcomManufacturingModel;
use App\Models\JobsTypes;
use App\Models\DeducationsTypes;
use App\Models\BeneftisTypes;
use App\Models\UsersMoves;
use App\Models\OverTimes;
use App\Models\HolidaysTypes;
use App\Models\Employess;
use App\Models\AcccountingManual;
use App\Models\Admin;
use App\Models\LoanTypes;
use App\Models\Borrowa;
use App\Models\CostCenter;
use App\Models\ProductUnits;
use App\Models\Coins;
use App\Models\JournalizingDetails;
use App\Models\Journalizing;
use App\Models\GeneralDaily;
use App\Models\Entitlement;
use App\Models\Deduction;
use App\Models\Holidays;
use App\Models\Attendance;
use App\Models\Departure;
use App\Models\AttendanceEmp;
use App\Models\DepartureEmp;
use App\Models\RegOverTime;
use App\Models\Settlement;
use App\Models\Loan;
use App\Models\PaySalary;
use App\Models\Stores;
use App\Models\EmpInstallment;
use App\Models\EmpInstallmentDetails;
use App\Models\Sales;
use App\Models\EmpRatio;
use App\Models\ExchangeCommissions;
use App\Models\ReturnMaintainceBill;
use App\Models\ProductSales;
use App\Models\ProductsPurchases;
use App\Models\ReciptMaintaince;
use App\Models\ProductMaintaincBill;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\CrmDefaultData;
use App\Models\PurchasesDefaultData;
use App\Models\SalesDefaultData;
use App\Models\MaintainceDefaultData;
use App\Models\ReciptVoucher;
use App\Models\ReciptVoucherDetails;
use App\Models\EmpPOSStores;
use App\Models\Employment_levels;
use App\Models\Insurance_companies;
use App\Models\Branches;
use App\Models\Countris;
use App\Models\Disclaimer;
use App\Models\ResignationRequest;
use App\Models\AllowencesEmp;
use App\Models\DiscountsEmp;
use App\Models\EmpsProducationQuantity;
use App\Models\EmpsProducationPoint;
use App\Models\AttendencePolicyEmp;
use App\Models\DepaarturePolicyEmp;
use App\Models\ShippingList;
use App\Models\ItemsGroups;
use App\Models\Event;
use App\Models\Notifications;
use App\Models\AccountsDefaultData;
use App\Models\Consists;
use App\Models\Purchases;
use App\Models\ProductMoves;
use App\Models\EmpSafes;
use App\Models\EmpCovenant;
use DB;
use Rats\Zkteco\Lib\ZKTeco;
use Str;
use DateTime;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Traits\GeneralTrait;

class HRController extends Controller
{
    use GeneralTrait;

    function __construct()
    {

        $this->middleware('permission:اقسام العمل', ['only' => ['WorkDepartmentsPage','AddWorkDepartments'],'EditWorkDepartments','DeleteWorkDepartments']);
        $this->middleware('permission:انواع الوظائف', ['only' => ['Jobs_TypePage','AddJobs_Type','EditJobs_Type','DeleteJobs_Type']]);
        $this->middleware('permission:اضافه موظف', ['only' => ['AddEmpPage','PostAddEmp']]);
        $this->middleware('permission:جدول الموظفين', ['only' => ['EmpSechdulePage','DeleteEmp','EditEmp','PostEditEmp']]);
        $this->middleware('permission:انواع الاجازات', ['only' => ['Holidays_TypesPage','AddHolidays_Types','EditHolidays_Types','DeleteHolidays_Types']]);
        $this->middleware('permission:انواع الاستحقاقات', ['only' => ['Benefits_TypesPage','AddBenefits_Types','EditBenefits_Types','DeleteBenefits_Types']]);
        $this->middleware('permission:انواع الاستقطاعات', ['only' => ['Deductions_TypesPage','AddDeductions_Types','EditDeductions_Types','DeleteDeductions_Types']]);
        $this->middleware('permission:الساعات الاضافيه', ['only' => ['OvertimePage','AddOvertime','EditOvertime','DeleteOvertime']]);
        $this->middleware('permission:انواع القروض', ['only' => ['Loan_TypesPage','AddLoan_Types','EditLoan_Types','DeleteLoan_Types']]);
        $this->middleware('permission:اضافه سلفه', ['only' => ['AddBorrowPage','PostAddBorrow']]);
        $this->middleware('permission:السلف', ['only' => ['BorrowPage','DeleteBorrow']]);
        $this->middleware('permission:طلب اجازه', ['only' => ['HolidaysOrderPage','AddHolidaysOrder','EditHolidaysOrder','DeleteHolidaysOrder','TransToHoilday']]);
        $this->middleware('permission:الاجازات', ['only' => ['HolidaysPage','AddHolidays','EditHolidays','DeleteHolidays']]);
        $this->middleware('permission:الاستحقاقات', ['only' => ['EntitlementsPage','AddEntitlements','EditEntitlements','DeleteEntitlements']]);
        $this->middleware('permission:الاستقطاعات', ['only' => ['DeducationPage','AddDeducation','EditDeducation','DeleteDeducation']]);
        $this->middleware('permission: الحضور', ['only' => ['AttendancePage','AddAttendance']]);
        $this->middleware('permission:جدول الحضور', ['only' => ['AttendanceSechdulePage','DeleteAttendance','EditAttendancePage','PostEditAttendance']]);
        $this->middleware('permission:انصراف', ['only' => ['DeparturePage','AddDeparture']]);
        $this->middleware('permission:جدول الانصراف', ['only' => ['DepartureSechdulePage','EditDeparturePage','PostEditDeparture']]);
        $this->middleware('permission:تسجيل الساعات الاضافيه', ['only' => ['RegOverTimePage','AddRegOverTime','EditRegOverTime','DeleteRegOverTime']]);
        $this->middleware('permission:اضافه قرض', ['only' => ['AddLoanPage','PostAddLoan']]);
        $this->middleware('permission:القروض', ['only' => ['LoanPage','DeleteLoan']]);
        $this->middleware('permission:اقساط الموظفين', ['only' => ['EmpInstallmentPage','EmpInstallBillDone','EmpUnInstallBill','EmpInstallDone','EmpUnInstall']]);
        $this->middleware('permission:صرف راتب', ['only' => ['AddSalaryPage','PostAddSalary']]);
        $this->middleware('permission:جدول الرواتب', ['only' => ['SalarySechdulesPage','DeletePaySalary']]);
        $this->middleware('permission:صرف عمولات', ['only' => ['ExchangeCommissionsPage','PostExchangeCommissions']]);
        $this->middleware('permission:جدول صرف العمولات', ['only' => ['ExchangeCommissionsSechdule']]);
        $this->middleware('permission:اهدافي', ['only' => ['MyGoals']]);
        $this->middleware('permission:طلب استقاله', ['only' => ['ResignationRequest']]);
        $this->middleware('permission:طلبات استقاله', ['only' => ['ResignationRequestSechdule']]);
        $this->middleware('permission:اخلاء طرف', ['only' => ['Disclaimer']]);
        $this->middleware('permission:جهاز البصمة', ['only' => ['Fingerprint']]);



    }


    //======  WorkDepartments =======
    public function WorkDepartmentsPage(){
        $itemss=WorkDepartments::all();
        $Presdient=WorkDepartments::where('Parent',0)->orderBy('id','desc')->first();
        $items=WorkDepartments::where('Parent',$Presdient->id)->get();
        $Employess=Employess::type()->get();
        $Emp=Employess::type()->where('Department',$Presdient->id)->latest('id')->first();
        return view('admin.HR.WorkDepartments',get_defined_vars());
    }

    public function AddWorkDepartments(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Arabic_Name'=>'required',



        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);


            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


            $data['Arabic_Name']=request('Arabic_Name');


            $data['Parent'] = request('Parent');

        $data['Budget']=request('Budget');
        $data['English_Name']=$english_name;
        WorkDepartments::create($data);


            $dataUser=[
                'screen_ar'=>'اقسام العمل',
                'screen_en'=>'Work Departments',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();
        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditWorkDepartments(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'English_Name'=>'required',
        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

        $id=request('ID');


        if(!empty(request('Parent'))){
            $data['Parent']=request('Parent');
        }else{
            $data['Parent']=request('ParentCurrent');
        }



        $data['Budget']=request('Budget');
        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        WorkDepartments::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'اقسام العمل',
                'screen_en'=>'Work Departments',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();
        session()->flash('success',trans('admin.Updated'));
        return back();
        }catch(\Exception $ex){

            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteWorkDepartments(){

        try {
            DB::beginTransaction();
        $id=request('ID');
        $del=WorkDepartments::find($id);

            $dataUser=[
                'screen_ar'=>'اقسام العمل',
                'screen_en'=>'Work Departments',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);

        $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=WorkDepartments::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditDepartment(Request $request){

        $states=[];
        $ID = $request->get('countryId');
        $item=WorkDepartments::find($ID);

        if(app()->getLocale() == 'ar' ){
            $states  +=['Ar'=>$item->Arabic_Name,'En'=>$item->English_Name,'parent'=>$item->Parent,'d'=>$item->id,'parentName'=>$item->Parent()->first()->Arabic_Name,'budget'=>$item->Budget];
        }else{
            $states  +=['Ar'=>$item->Arabic_Name,'En'=>$item->English_Name,'parent'=>$item->Parent,'d'=>$item->id,'parentName'=>$item->Parent()->first()->English_Name,'budget'=>$item->Budget];

        }

        return response()->json($states);

    }


    //Employment_levels
    public function Employment_levels(){
        $items=Employment_levels::all();
        return view('admin.HR.Employment_levels',['items'=>$items]);
    }

    public function AddEmployment_levels(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['English_Name']=$english_name;
        $data['Arabic_Name']=request('Arabic_Name');
        Employment_levels::create($data);




            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();
        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditEmployment_levels($id){

        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'English_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);



        $data['Arabic_Name']=request('Arabic_Name');

            $data['English_Name']=request('English_Name');

        Employment_levels::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteEmployment_levels($id){

        try {
            DB::beginTransaction();
        $del=Employment_levels::find($id);

        $dataUser['User']=auth()->guard('admin')->user()->id;
        $dataUser['Date']=date('Y-m-d');
        $dataUser['Time']=date("h:i:s a", time());
        $dataUser['Screen']='مستويات التوظيف';
        $dataUser['ScreenEn']='Employment levels';
        $dataUser['Type']='حذف';
        $dataUser['TypeEn']='Delete';
        $dataUser['Explain']=$del->Arabic_Name;
        $dataUser['ExplainEn']=$del->English_Name;
        UsersMoves::create($dataUser);


            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->Arabic_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employment_levels::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

//Insurance_companies
    public function Insurance_companies(){
        $items=Insurance_companies::all();
        return view('admin.HR.Insurance_companies',['items'=>$items]);
    }

    public function AddInsurance_companies(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
        Insurance_companies::create($data);

            $dataUser=[
                'screen_ar'=>'شركات التأمين',
                'screen_en'=>'Insurance companies',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditInsurance_companies($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        Insurance_companies::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'شركات التأمين',
                'screen_en'=>'Insurance companies',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();


        session()->flash('success',trans('admin.Updated'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteInsurance_companies($id){

        try {
            DB::beginTransaction();
        $del=Insurance_companies::find($id);


            $dataUser=[
                'screen_ar'=>'شركات التأمين',
                'screen_en'=>'Insurance companies',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();

            session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Insurance_companies::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  JobsTypes =======
    public function Jobs_TypePage(){
        $items=JobsTypes::all();
        return view('admin.HR.JobsTypes',['items'=>$items]);
    }

    public function AddJobs_Type(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;

        JobsTypes::create($data);

            $dataUser=[
                'screen_ar'=>'انواع الوظائف',
                'screen_en'=>'Jobs Type',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditJobs_Type($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        JobsTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع الوظائف',
                'screen_en'=>'Jobs Type',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();


        }catch(\Exception $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteJobs_Type($id){
        try {
            DB::beginTransaction();
        $del=JobsTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع الوظائف',
                'screen_en'=>'Jobs Type',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=JobsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }


    //======  BeneftisTypes =======
    public function Benefits_TypesPage(){
        $items=BeneftisTypes::all();
        return view('admin.HR.BeneftisTypes',['items'=>$items]);
    }

    public function AddBenefits_Types(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);


            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }
        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
        BeneftisTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع الاستحقاقات',
                'screen_en'=>'Benefits Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditBenefits_Types($id){


        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);



        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        BeneftisTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع الاستحقاقات',
                'screen_en'=>'Benefits Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteBenefits_Types($id){

        try {
            DB::beginTransaction();
        $del=BeneftisTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع الاستحقاقات',
                'screen_en'=>'Benefits Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=BeneftisTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Deductions_Types =======
    public function Deductions_TypesPage(){
        $items=DeducationsTypes::all();
        return view('admin.HR.DeducationsTypes',['items'=>$items]);
    }

    public function AddDeductions_Types(){

        try {
            DB::beginTransaction();
            $data= $this->validate(request(),[
                'Arabic_Name'=>'required',


            ],[
                'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
                'English_Name.required' => trans('admin.English_NameRequired'),

            ]);


            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
        DeducationsTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع الاستقطاعات',
                'screen_en'=>'Deductions Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditDeductions_Types($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);



        $data['Arabic_Name']=request('Arabic_Name');

            $data['English_Name']=request('English_Name');


        DeducationsTypes::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'انواع الاستقطاعات',
                'screen_en'=>'Deductions Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteDeductions_Types($id){

        try {
            DB::beginTransaction();
        $del=DeducationsTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع الاستقطاعات',
                'screen_en'=>'Deductions Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=DeducationsTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  HolidaysTypes =======
    public function Holidays_TypesPage(){
        $items=HolidaysTypes::all();
        return view('admin.HR.HolidaysTypes',['items'=>$items]);
    }

    public function AddHolidays_Types(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'Days'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),
            'Days.required' => trans('admin.DaysNumbersRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


        $data['From_Date']=request('From_Date');
        $data['To_Date']=request('To_Date');
        $data['Arabic_Name']=request('Arabic_Name');
        $data['Days']=request('Days');
            $data['English_Name']=$english_name;
        HolidaysTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع الاجازات',
                'screen_en'=>'Holidays Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditHolidays_Types($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'Days'=>'required',

        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),
            'Days.required' => trans('admin.DaysNumbersRequired'),
        ]);


        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        $data['Days']=request('Days');
        $data['From_Date']=request('From_Date');
        $data['To_Date']=request('To_Date');
        HolidaysTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع الاجازات',
                'screen_en'=>'Holidays Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();


        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteHolidays_Types($id){
        try {
            DB::beginTransaction();
        $del=HolidaysTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع الاجازات',
                'screen_en'=>'Holidays Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=HolidaysTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  OverTimes =======
    public function OvertimePage(){
        $items=OverTimes::all();
        return view('admin.HR.OverTimes',['items'=>$items]);
    }

    public function AddOvertime(){
        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'Hour'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),
            'Hour.required' => trans('admin.CostHourRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }


        $data['Arabic_Name']=request('Arabic_Name');
        $data['Hour']=request('Hour');
            $data['English_Name']=$english_name;
        OverTimes::create($data);


            $dataUser=[
                'screen_ar'=>'الساعات الاضافيه',
                'screen_en'=>'Overtime',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditOvertime($id){
        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',
            'Hour'=>'required',

        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),
            'Hour.required' => trans('admin.CostHourRequired'),
        ]);



        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        $data['Hour']=request('Hour');
        OverTimes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'الساعات الاضافيه',
                'screen_en'=>'Overtime',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteOvertime($id){

        try {
            DB::beginTransaction();
        $del=OverTimes::find($id);

            $dataUser=[
                'screen_ar'=>'الساعات الاضافيه',
                'screen_en'=>'Overtime',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=OverTimes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    //======  Loan_Types =======
    public function Loan_TypesPage(){
        $items=LoanTypes::all();
        return view('admin.HR.LoanTypes',['items'=>$items]);
    }

    public function AddLoan_Types(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);

            if(!empty(request('English_Name'))){

                $english_name=request('English_Name');
            }else{

                $english_name=request('Arabic_Name');
            }

            $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=$english_name;
        LoanTypes::create($data);


            $dataUser=[
                'screen_ar'=>'انواع القروض',
                'screen_en'=>'Loan Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();


            session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditLoan_Types($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Arabic_Name'=>'required',


        ],[
            'Arabic_Name.required' => trans('admin.Arabic_NameRequired'),
            'English_Name.required' => trans('admin.English_NameRequired'),

        ]);



        $data['Arabic_Name']=request('Arabic_Name');
            $data['English_Name']=request('English_Name');
        LoanTypes::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'انواع القروض',
                'screen_en'=>'Loan Types',
                'explain_ar'=>request('Arabic_Name'),
                'explain_en'=>request('English_Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }



    }

    public function DeleteLoan_Types($id){

        try {
            DB::beginTransaction();
        $del=LoanTypes::find($id);

            $dataUser=[
                'screen_ar'=>'انواع القروض',
                'screen_en'=>'Loan Types',
                'explain_ar'=>$del->Arabic_Name,
                'explain_en'=>$del->English_Name,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=LoanTypes::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  EmpsProducationPoint =======
    public function ProducationPoints(){
        $items=EmpsProducationPoint::paginate(100);
        return view('admin.HR.ProducationPoint',['items'=>$items]);
    }

    public function AddProducationPoints(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Month'=>'required',
            'Point'=>'required',
            'Emp'=>'required',
            'Date'=>'required',


        ],[

        ]);

        $data['Month']=request('Month');
        $data['Point']=request('Point');
        $data['Emp']=request('Emp');
        $data['Date']=request('Date');
        EmpsProducationPoint::create($data);

            $dataUser=[
                'screen_ar'=>'نقاط الانتاج',
                'screen_en'=>'Producation Points',
                'explain_ar'=>request('Month'),
                'explain_en'=>request('Month'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();


        }catch(\Exception $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditProducationPoints($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Month'=>'required',
            'Point'=>'required',
            'Emp'=>'required',
            'Date'=>'required',


        ],[

        ]);



        $data['Month']=request('Month');
        $data['Point']=request('Point');
        $data['Emp']=request('Emp');
        $data['Date']=request('Date');

        EmpsProducationPoint::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'نقاط الانتاج',
                'screen_en'=>'Producation Points',
                'explain_ar'=>request('Month'),
                'explain_en'=>request('Month'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteProducationPoints($id){
        try {
            DB::beginTransaction();
        $del=EmpsProducationPoint::find($id);

            $dataUser=[
                'screen_ar'=>'نقاط الانتاج',
                'screen_en'=>'Producation Points',
                'explain_ar'=>$del->Month,
                'explain_en'=>$del->Month,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();


        }catch(\Exception $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=EmpsProducationPoint::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


    //======  Entitlement =======
    public function EntitlementsPage(){
        $items=Entitlement::paginate(100);
        $Coins=Coins::all();
        $BeneftisTypes=BeneftisTypes::all();
        $Code=$this->ReturnCode(Entitlement::class);
        return view('admin.HR.Entitlement',get_defined_vars());
    }

    public function AddEntitlements(){


        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Code'=>'required',
            'Draw'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Draw']=request('Draw');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Coin']=request('Coin');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;
        Entitlement::create($data);

            $dataUser=[
                'screen_ar'=>'الاستحقاقات',
                'screen_en'=>'Entitlements',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditEntitlements($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Code'=>'required',
            'Draw'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Draw']=request('Draw');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Coin']=request('Coin');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;


        Entitlement::where('id',$id)->update($data);
            $dataUser=[
                'screen_ar'=>'الاستحقاقات',
                'screen_en'=>'Entitlements',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();


        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteEntitlements($id){

        try {
            DB::beginTransaction();
        $del=Entitlement::find($id);


            $dataUser=[
                'screen_ar'=>'الاستحقاقات',
                'screen_en'=>'Entitlements',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Entitlement::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Deduction =======
    public function DeducationPage(){
        $items=Deduction::paginate(100);
        $Coins=Coins::all();
        $DeducationsTypes=DeducationsTypes::all();
        $Code=$this->ReturnCode(Deduction::class);
        return view('admin.HR.Deduction',get_defined_vars());
    }

    public function AddDeducation(){


        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Code'=>'required',
            'Draw'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Draw']=request('Draw');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Coin']=request('Coin');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;
        Deduction::create($data);


            $dataUser=[
                'screen_ar'=>'الاستقطاعات',
                'screen_en'=>'Deduction',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditDeducation($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Code'=>'required',
            'Draw'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Draw']=request('Draw');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Coin']=request('Coin');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;


        Deduction::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'الاستقطاعات',
                'screen_en'=>'Deduction',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteDeducation($id){

        try {
            DB::beginTransaction();
        $del=Deduction::find($id);


            $dataUser=[
                'screen_ar'=>'الاستقطاعات',
                'screen_en'=>'Deduction',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Deduction::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    //Disclaimer
    public function Disclaimer(){

        $EMps=Employess::type()->get();
        $items=Disclaimer::paginate(100);

        return view('admin.HR.Disclaimer',get_defined_vars());
    }

    public function AddDisclaimer(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[

            'Date'=>'required',
            'Note'=>'required',


        ],[

        ]);


            $image=request()->file('File');
            $zFile=$this->UploadFile($image);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=null;
            }



            $data['Date']=request('Date');
        $data['Emp']=request('Emp');
        $data['Note']=request('Note');
        Disclaimer::create($data);


            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>request('Date'),
                'explain_en'=>request('Date'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }
    }

    public function EditDisclaimer($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[

            'Date'=>'required',

            'Note'=>'required',

        ],[

        ]);

            $image=request()->file('File');
            $zFile=$this->UploadFile($image);

            if(!empty($zFile)){

                $data['File']=$zFile;

            }else{

                $data['File']=\request('Files');
            }


            $data['Date']=request('Date');
        $data['Emp']=request('Emp');
        $data['Note']=request('Note');
        Disclaimer::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>request('Date'),
                'explain_en'=>request('Date'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteDisclaimer($id){

        try {
            DB::beginTransaction();
        $del=Disclaimer::find($id);

            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>$del->Date,
                'explain_en'=>$del->Date,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=Disclaimer::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function PrintDisclaimer($id){
        $disc=Disclaimer::find($id);
        $item=Employess::find($disc->Emp);
        return view('admin.HR.PrintDisclaimer',get_defined_vars());

    }


    //RegOverTime
    public function RegOverTimePage(){
        $items=RegOverTime::paginate(100);

        $Types=OverTimes::all();
        $Code=$this->ReturnCode(RegOverTime::class);
        return view('admin.HR.RegOverTime',get_defined_vars());
    }

    public function AddRegOverTime(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);

        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Hours_Number']=request('Hours_Number');
        $data['Hour_Rate']=request('Hour_Rate');
        $data['Total_Hours']=request('Total_Hours');
        $data['Hour_Cost']=request('Hour_Cost');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;

        RegOverTime::create($data);

            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditRegOverTime($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);

        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Hours_Number']=request('Hours_Number');
        $data['Hour_Rate']=request('Hour_Rate');
        $data['Total_Hours']=request('Total_Hours');
        $data['Hour_Cost']=request('Hour_Cost');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;

        RegOverTime::where('id',$id)->update($data);


            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();


        session()->flash('success',trans('admin.Updated'));
        return back();
        }catch(\Exception $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteRegOverTime($id){

        try {
            DB::beginTransaction();
        $del=RegOverTime::find($id);

            $dataUser=[
                'screen_ar'=>'اخلاء طرف',
                'screen_en'=>'Disclaimer',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=RegOverTime::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function OverTimeTypeFilter($type,$emp) {

        $empp=Employess::find($emp);
        $typp=OverTimes::find($type);

        $z = $empp->Salary /  $empp->Hours_Numbers  ;

        $states=[];
        $states += ['rate' => $typp->Hour , 'cost' => $z];

        return response()->json($states);

    }


    //EmpInstallmentPage
    public function EmpInstallmentPage(){
        $items=EmpInstallment::paginate(100);
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->lazy();
        $Clients = AcccountingManual::where('Parent',121)->where('Type',1)->get();
        return view('admin.HR.EmpInstallment',get_defined_vars());
    }

    public function EmpInstallBillDone($id){

        EmpInstallment::where('id',$id)->update(['Status'=>1]);
        $del=EmpInstallment::find($id);
        session()->flash('success',trans('admin.InstallmentDone'));
        return back();

    }

    public function EmpUnInstallBill($id){

        EmpInstallment::where('id',$id)->update(['Status'=>0]);
        $del=EmpInstallment::find($id);
        session()->flash('error',trans('admin.UnInstallmentDone'));
        return back();

    }

    public function InstallEmpPrint($id,$inst){

        $item=EmpInstallment::find($id);
        $details=EmpInstallmentDetails::find($inst);
        return view('admin.HR.InstallmentEmptPrint',get_defined_vars());
    }

    public function EmpInstallDone(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Creditor'=>'required',
            'Account'=>'required',
            'Safe'=>'required',
            'Coin'=>'required',
            'Draw'=>'required',


        ],[

            'Creditor.required' => trans('admin.CreditorRequired'),
            'Account.required' => trans('admin.AccountRequired'),
            'Safe.required' => trans('admin.SafeRequired'),
            'Coin.required' => trans('admin.CoinRequired'),
            'Draw.required' => trans('admin.DrawRequired'),

        ]);

        $Creditor = request('Creditor');
        $AccountCode = request('Account');
        $Safe = request('Safe');
        $Coin = request('Coin');
        $Draw = request('Draw');

        $IDD = DB::table('recipt_vouchers')->insertGetId(

            array(

                'Date' => date('Y-m-d'),
                'Draw' => $Draw,
                'Coin' => $Coin,
                'Safe' => $Safe,
                'Cost_Center' => null,
                'Total_Creditor' => $Creditor,
                'Shift' => null,
                'Store' => null,
                'Note' => null,
                'User' => auth()->guard('admin')->user()->emp,

            )
        );
        $Code=ReciptVoucher::findOrFail($IDD)->Code;


        $PRODUCTS['RV_ID']=$IDD;
        $PRODUCTS['Creditor']=$Creditor;
        $PRODUCTS['Account']=$AccountCode;
        $PRODUCTS['Statement']=null;
        ReciptVoucherDetails::create($PRODUCTS);

        $ID = DB::table('journalizings')->insertGetId(

            array(

                'Type' =>'سند قبض',
                'TypeEn' => 'Receipt Voucher',
                'Code_Type' => $Code,
                'Date' => date('Y-m-d'),
                'Draw' => $Draw,
                'Coin' => $Coin,
                'Cost_Center' => null,
                'Total_Debaitor' => $Creditor,
                'Total_Creditor' => $Creditor,
                'Note' => null,

            )
        );


        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$Creditor;
        $PRODUCTSS['Account']=$AccountCode;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);


            $Codee=Journalizing::findOrFail($ID)->Code;

        $Gen['Code']=$Codee;
        $Gen['Code_Type']=$Code;
        $Gen['Date']=date('Y-m-d');
        $Gen['Type']='سند قبض';
        $Gen['TypeEn']='Receipt Voucher';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$Creditor;
        $Gen['Statement']=null;
        $Gen['Draw']=$Draw;
        $Gen['Debitor_Coin']= $Draw * 0;
        $Gen['Creditor_Coin']=$Draw * $Creditor;
        $Gen['Account']=$AccountCode;
        $Gen['Coin']= $Coin;
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);


        $PRODUCTSSS['Joun_ID']=$ID;
        $PRODUCTSSS['Debitor']=$Creditor;
        $PRODUCTSSS['Creditor']=0;
        $PRODUCTSSS['Account']=$Safe;
        $PRODUCTSSS['Statement']=null;
        JournalizingDetails::create($PRODUCTSSS);

        $Genn['Code']=$Codee;
        $Genn['Code_Type']=$Code;
        $Genn['Date']=date('Y-m-d');
        $Genn['Type']='سند قبض';
        $Genn['TypeEn']='Receipt Voucher';
        $Genn['Debitor']=$Creditor;
        $Genn['Creditor']=0;
        $Genn['Statement']=null;
        $Genn['Draw']=$Draw;
        $Genn['Debitor_Coin']= $Draw * $Creditor;
        $Genn['Creditor_Coin']=$Draw * 0;
        $Genn['Account']=$Safe;
        $Genn['Coin']= $Coin;
        $Genn['Cost_Center']= null;
        $Genn['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Genn);



        $id=request('ID');

        EmpInstallmentDetails::where('id',$id)->update(['Status'=>1]);

        $del=EmpInstallmentDetails::find($id);

            $dataUser=[
                'screen_ar'=>'اقساط الموظفين',
                'screen_en'=>'Employee Installment',
                'type_ar'=>'قسط قرض',
                'type_en'=>'Loan Installment',
                'explain_ar'=>$del->Install()->first()->Loan,
                'explain_en'=>$del->Install()->first()->Loan,
            ];
            $this->UserCustomMoves($dataUser);
            DB::commit();


        session()->flash('success',trans('admin.InstallmentDone'));
        return redirect('InstallEmpPrint/'.$del->Install.'/'.$id);

        }catch(\Exception $ex){

            $MODEL=ReciptVoucher::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){

            $MODEL=ReciptVoucher::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");
            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EmpUnInstall($id){

        EmpInstallmentDetails::where('id',$id)->update(['Status'=>0]);
        $del=EmpInstallmentDetails::find($id);
        session()->flash('error',trans('admin.UnInstallmentDone'));
        return back();

    }


    //======  Employess =======
    public function AddEmpPage(){

        $Departments=WorkDepartments::all();
        $JobsTypes=JobsTypes::all();
        $Employment_levels=Employment_levels::all();
        $Insurance_companies=Insurance_companies::all();
        $Branches=Branches::all();
        $Countris=Countris::all();
        $Groups=ItemsGroups::all();
        $wf=60;
        $wff=61;
        $wfff=62;
        $Accounts=AcccountingManual::orderBy('Code','asc')
            ->where('Code','like', $wf.'%')
            ->orWhere('Code','like', $wff.'%')
            ->orWhere('Code','like', $wfff.'%')
            ->where('Type',0)
            ->get();
        $Code=$this->ReturnCode(Employess::class);
        $Stores=Stores::all();
        $Safes=AcccountingManual::whereIn('Parent',[28,29])->get();
        $Aloownces=BeneftisTypes::all();
        $Discounts=DeducationsTypes::all();
        return view('admin.HR.Employee',get_defined_vars());
    }

    public function EmpSechdulePage(){
        $items=Employess::where('EmpSort',1)->whereNotIn('id',[38,39,40,41,42])->paginate(50);
        SalaryDue::dispatch();
        return view('admin.HR.EmployeesSechdule',['items'=>$items]);
    }

    public function JobRequestsSechdule(){
        $items=Employess::where('EmpSort',2)->get();
        return view('admin.HR.JobRequestsSechdule',['items'=>$items]);
    }

    public function PostAddEmp(EmpRequest $request,HRService $service){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

            if(!empty(request('NameEn'))){

                $english_name=request('NameEn');
            }else{

                $english_name=request('Name');
            }


            $image=request()->file('Image');
            $NewImage=$this->UploadFile($image);
            if(!empty($NewImage)){

                $data['Image']=$NewImage;

            }else{

                $data['Image']=null;
            }

            $CV=request()->file('CV');
            $NewCV=$this->UploadFile($CV);
            if(!empty($NewCV)){

                $data['CV']=$NewCV;

            }else{

                $data['CV']=null;
            }

            $ID_Image=request()->file('ID_Image');
            $NewID_Image=$this->UploadFile($ID_Image);
            if(!empty($NewID_Image)){
                $data['ID_Image']=$NewID_Image;
            }else{

                $data['ID_Image']=null;
            }

            $Criminal_status=request()->file('Criminal_status');
            $NewCriminal_status=$this->UploadFile($Criminal_status);
            if(!empty($NewCriminal_status)){
                $data['Criminal_status']=$NewCriminal_status;
            }else{

                $data['Criminal_status']=null;
            }

            $Contract=request()->file('Contract');
            $NewContract=$this->UploadFile($Contract);
            if(!empty($NewContract)){
                $data['Contract']=$NewContract;
            }else{

                $data['Contract']=null;
            }


            $health_certificate=request()->file('health_certificate');
            $Newhealth_certificate=$this->UploadFile($health_certificate);
            if(!empty($Newhealth_certificate)){
                $data['health_certificate']=$Newhealth_certificate;
            }else{

                $data['health_certificate']=null;
            }

            $Search_Card=request()->file('Search_Card');
            $NewSearch_Card=$this->UploadFile($Search_Card);
            if(!empty($NewSearch_Card)){
                $data['Search_Card']=$NewSearch_Card;
            }else{

                $data['Search_Card']=null;
            }

            $Recruitment_certificate=request()->file('Recruitment_certificate');
            $NewRecruitment_certificate=$this->UploadFile($Recruitment_certificate);
            if(!empty($NewRecruitment_certificate)){
                $data['Recruitment_certificate']=$NewRecruitment_certificate;
            }else{

                $data['Recruitment_certificate']=null;
            }


            $employee_profile=request()->file('employee_profile');
            $Newemployee_profile=$this->UploadFile($employee_profile);
            if(!empty($Newemployee_profile)){
                $data['employee_profile']=$Newemployee_profile;
            }else{

                $data['employee_profile']=null;
            }

            $Acc=$this->CreateAccount(request('Name'),$english_name,request('Account'),request('Note'));
            $mola=$this->CreateAccount(request('Name').' '.' عموله ',$english_name.' '.' Commission ',164,request('Note'));
            $ohda=$this->CreateAccount(request('Name').' '.' عهده ',$english_name.' '.' Custody ',121,request('Note'));
            $esthkak=$this->CreateAccount(request('Name').' '.' استحقاق ',$english_name.' '.' Merit ',43,request('Note'));

        $data['Name']=request('Name');
        $data['NameEn']=$english_name;
        $data['Emp_Type']=request('Emp_Type');
        $data['Salary']=request('Salary');
        $data['Attendence']=request('Attendence');
        $data['Departure']=request('Departure');
        $data['Hours_Numbers']=request('Hours_Numbers');
        $data['Days_Numbers']=request('Days_Numbers');
        $data['Day_Price']=request('Day_Price');
        $data['Precentage_of_Sales']=request('Precentage_of_Sales');
        $data['Precentage_of_Profits']=request('Precentage_of_Profits');
        $data['Precentage_of_Execution']=request('Precentage_of_Execution');
        $data['Note']=request('Note');
        $data['Bank_Account']=request('Bank_Account');
        $data['Qualifications']=request('Qualifications');
        $data['Address']=request('Address');
        $data['Social_Status']=request('Social_Status');
        $data['ID_Number']=request('ID_Number');
        $data['Contract_Start']=request('Contract_Start');
        $data['Contract_End']=request('Contract_End');
        $data['Phone']=request('Phone');
        $data['Phone2']=request('Phone2');
        $data['Email']=request('email');
        $data['Password']=request('Password');
        $data['Job']=request('Job');
        $data['Department']=request('Department');
        $data['Account']=request('Account');
        $data['Price_Level']=request('Price_Level');
        $data['Account_Emp']=$Acc;
        $data['Commission']=$mola;
        $data['Covenant']=$ohda;
        $data['Merit']=$esthkak;
        $data['User']=auth()->guard('admin')->user()->id;
        $data['Bill_Num']=request('Bill_Num');
        $data['NumbersOfBill']=request('NumbersOfBill');
        $data['EmpSort']=request('EmpSort');
        $data['duration_criminal_investigation']=request('duration_criminal_investigation');
        $data['Birthdate']=request('Birthdate');
        $data['Attitude_recruiting']=request('Attitude_recruiting');
        $data['Job_Number']=request('Job_Number');
        $data['date_resignation']=request('date_resignation');
        $data['Living']=request('Living');
        $data['Branch']=request('Branch');
        $data['Level']=request('Level');
        $data['Religion']=request('Religion');
        $data['Insurance_salary']=request('Insurance_salary');
        $data['Insurance_companies']=request('Insurance_companies');
        $data['Previous_experience']=request('Previous_experience');
        $data['Nationality']=request('Nationality');
        $data['MonthlyTarget']=request('MonthlyTarget');
        $data['QuarterTarget']=request('QuarterTarget');
        $data['SemiTarget']=request('SemiTarget');
        $data['YearlyTarget']=request('YearlyTarget');
        $data['IDExpireDate']=request('IDExpireDate');
        $data['LicensExpireDate']=request('LicensExpireDate');
        $data['PassportExpireDate']=request('PassportExpireDate');
        $data['Pro_Group']=request('Pro_Group');
        $data['SearchCode']=request('SearchCode');
        $data['Active']=1;
        Employess::create($data);

        $IDD= Employess::latest('id')->first();

        //Service Events
            $service->EmpEvents($request->all(),$IDD);

//Emp Stores
        if(!empty(request('POSStores'))){

            $Store=request('POSStores');

            for ($i=0; $i < count($Store); $i++) {

                $uu['Store']=$Store[$i];
                $uu['Emp']=$IDD->id;
                EmpPOSStores::create($uu);

            }

        }

            //Emp Safes
        if(!empty(request('POSSafes'))){

            $Safe=request('POSSafes');

            for ($i=0; $i < count($Safe); $i++) {

                $uu['Safe']=$Safe[$i];
                $uu['Emp']=$IDD->id;
                EmpSafes::create($uu);

            }

        }


        //Precents
            $service->EmpPrecents($request->all(),$IDD);


        //Create Store for Employee
        if(request('STORE') == 1){
            $Module=ModuleSettingsNum::orderBy('id','desc')->first();
            if($Module->Store_Select == 1){

                $count=Stores::count();

                if($Module->Store_Num <= $count){

                    session()->flash('error',trans('admin.Alert_Maximum_Add'));
                    return back();
                }


            }

            $Accc=$this->CreateAccount(request('Name').' '.' مخزن ',$english_name.' '.' Store ',27,request('Note'));
            $NewAccc=$this->CreateAccount(request('Name').' '.' عميل مخزن  ',$english_name.' '.' Client Store  ',24,request('Note'));

            $dataa['Date']=date('Y-m-d');
            $dataa['Time']=date("h:i:s a", time());
            $dataa['Name']=request('Name').' '.' مخزن ';
            $dataa['NameEn']=$english_name.' '.' Store ';
            $dataa['Phone']=null;
            $dataa['Address']=null;
            $dataa['Account']=$Accc;
            $dataa['Account_Client']=$NewAccc;
            $dataa['User']=auth()->guard('admin')->user()->id;
            Stores::create($dataa);


        }



        // Fingerprint Device
            $setting=ModuleSettingsNum::latest('id')->first();
if($setting->Fingerprint == 1){

    $zk = new ZKTeco($setting->Fingerprint_IP);
    $zk->connect();
    $zk->setUser($uid=$IDD->id,$userid=$IDD->id,$name=$IDD->Name,$password='123456');

}



            $dataUser=[
                'screen_ar'=>'الموظفين',
                'screen_en'=>'Employee',
                'explain_ar'=>request('Name'),
                'explain_en'=>$english_name,
            ];
            $this->UserCreateMoves($dataUser);



            DB::commit();
        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteEmp($id,HRService $service){

        try {
            DB::beginTransaction();
        $del=Employess::find($id);


        $result=$service->RemoveEmployee($id);

        if($result == 1){

            session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
            return back();

        }

            $dataUser=[
                'screen_ar'=>'الموظفين',
                'screen_en'=>'Employee',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->NameEn,
            ];
            $this->UserDeleteMoves($dataUser);



            // Fingerprint Device
            $setting=ModuleSettingsNum::latest('id')->first();
            if($setting->Fingerprint == 1){

                $zk = new ZKTeco($setting->Fingerprint_IP);
                $zk->connect();
                $zk->removeUser($del->id);

            }



            Employess::where('id',$id)->update(['Active'=>0,'Delete'=>1]);

            DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function UnActiveEmp($id){
        Employess::where('id',$id)->update(['Active'=>0]);
        session()->flash('success',trans('admin.Updated'));
        return back();

    }

    public function ActiveEmp($id){
        Employess::where('id',$id)->update(['Active'=>1]);
        session()->flash('success',trans('admin.Updated'));
        return back();

    }


    public function EditEmp($id){

        $Departments=WorkDepartments::all();
        $JobsTypes=JobsTypes::all();
        $wf=60;
        $wff=61;
        $wfff=62;
        $Accounts=AcccountingManual::orderBy('Code','asc')
            ->where('Code','like', $wf.'%')
            ->orWhere('Code','like', $wff.'%')
            ->orWhere('Code','like', $wfff.'%')
            ->where('Type',0)->get();
        $item=Employess::find($id);
        $ratios=EmpRatio::where('Emp',$item->id)->get();
        $POSS=EmpPOSStores::where('Emp',$item->id)->get();
        $Qties=EmpsProducationQuantity::where('Emp',$item->id)->get();
        $Employment_levels=Employment_levels::all();
        $Insurance_companies=Insurance_companies::all();
        $Stores=Stores::all();
        $Branches=Branches::all();
        $Countris=Countris::all();
        $Aloownces=BeneftisTypes::all();
        $Discounts=DeducationsTypes::all();
        $alow=AllowencesEmp::where('Emp',$item->id)->get();
        $disco=DiscountsEmp::where('Emp',$item->id)->get();
        $Atts=AttendencePolicyEmp::where('Emp',$item->id)->get();
        $Deps=DepaarturePolicyEmp::where('Emp',$item->id)->get();
        $Groups=ItemsGroups::all();
        $Safes=AcccountingManual::whereIn('Parent',[28,29])->get();
        $POSSafes=EmpSafes::where('Emp',$item->id)->get();
        return view('admin.HR.EditEmployee',get_defined_vars());
    }

    public function PostEditEmp($id,EmpRequest $request,HRService $service){
        try {
            DB::beginTransaction();

            $validated = $request->validated();

        $del=Employess::find($id);

        AcccountingManual::where('id',$del->Account_Emp)->update(['Name'=>request('Name'),'NameEn'=>request('NameEn')]);
        AcccountingManual::where('id',$del->Covenant)->update(['Name'=>request('Name').' '.' عهده ','NameEn'=>request('NameEn').' '.' Custody ']);
        AcccountingManual::where('id',$del->Commission)->update(['Name'=>request('Name').' '.' عموله ','NameEn'=>request('NameEn').' '.' Commission ']);
        AcccountingManual::where('id',$del->Merit)->update(['Name'=>request('Name').' '.' استحقاق ','NameEn'=>request('NameEn').' '.' Merit ']);

            EmpRatio::where('Emp',$id)->delete();
            AllowencesEmp::where('Emp',$id)->delete();
            DiscountsEmp::where('Emp',$id)->delete();
            EmpsProducationQuantity::where('Emp',$id)->delete();
            AttendencePolicyEmp::where('Emp',$id)->delete();
            DepaarturePolicyEmp::where('Emp',$id)->delete();

            $image=request()->file('Image');
            $NewImage=$this->UploadFile($image);
            if(!empty($NewImage)){

                $data['Image']=$NewImage;

            }else{

                $data['Image']=request('Images');
            }

            $CV=request()->file('CV');
            $NewCV=$this->UploadFile($CV);
            if(!empty($NewCV)){

                $data['CV']=$NewCV;

            }else{

                $data['CV']=request('CVs');
            }

            $ID_Image=request()->file('ID_Image');
            $NewID_Image=$this->UploadFile($ID_Image);
            if(!empty($NewID_Image)){
                $data['ID_Image']=$NewID_Image;
            }else{

                $data['ID_Image']=request('ID_Images');
            }

            $Criminal_status=request()->file('Criminal_status');
            $NewCriminal_status=$this->UploadFile($Criminal_status);
            if(!empty($NewCriminal_status)){
                $data['Criminal_status']=$NewCriminal_status;
            }else{

                $data['Criminal_status']=request('Criminal_statuss');
            }

            $Contract=request()->file('Contract');
            $NewContract=$this->UploadFile($Contract);
            if(!empty($NewContract)){
                $data['Contract']=$NewContract;
            }else{

                $data['Contract']=request('Contracts');
            }


            $health_certificate=request()->file('health_certificate');
            $Newhealth_certificate=$this->UploadFile($health_certificate);
            if(!empty($Newhealth_certificate)){
                $data['health_certificate']=$Newhealth_certificate;
            }else{

                $data['health_certificate']=request('health_certificates');
            }

            $Search_Card=request()->file('Search_Card');
            $NewSearch_Card=$this->UploadFile($Search_Card);
            if(!empty($NewSearch_Card)){
                $data['Search_Card']=$NewSearch_Card;
            }else{

                $data['Search_Card']=request('Search_Cards');
            }

            $Recruitment_certificate=request()->file('Recruitment_certificate');
            $NewRecruitment_certificate=$this->UploadFile($Recruitment_certificate);
            if(!empty($NewRecruitment_certificate)){
                $data['Recruitment_certificate']=$NewRecruitment_certificate;
            }else{

                $data['Recruitment_certificate']=request('Recruitment_certificates');
            }


            $employee_profile=request()->file('employee_profile');
            $Newemployee_profile=$this->UploadFile($employee_profile);
            if(!empty($Newemployee_profile)){
                $data['employee_profile']=$Newemployee_profile;
            }else{

                $data['employee_profile']=request('employee_profiles');
            }

            $data['Code']=request('Code');
        $data['Name']=request('Name');
        $data['NameEn']=request('NameEn');
        $data['Emp_Type']=request('Emp_Type');
        $data['Salary']=request('Salary');
        $data['Attendence']=request('Attendence');
        $data['Departure']=request('Departure');
        $data['Hours_Numbers']=request('Hours_Numbers');
        $data['Days_Numbers']=request('Days_Numbers');
        $data['Day_Price']=request('Day_Price');
        $data['Precentage_of_Sales']=request('Precentage_of_Sales');
        $data['Precentage_of_Profits']=request('Precentage_of_Profits');
        $data['Precentage_of_Execution']=request('Precentage_of_Execution');
        $data['Note']=request('Note');
        $data['Bank_Account']=request('Bank_Account');
        $data['Qualifications']=request('Qualifications');
        $data['Address']=request('Address');
        $data['Social_Status']=request('Social_Status');
        $data['ID_Number']=request('ID_Number');
        $data['Contract_Start']=request('Contract_Start');
        $data['Contract_End']=request('Contract_End');
        $data['Phone']=request('Phone');
        $data['Phone2']=request('Phone2');
        $data['Email']=request('Email');
        $data['Password']=request('Password');
        $data['Job']=request('Job');
        $data['Department']=request('Department');
        $data['Account']=request('Account');
        $data['Account_Emp']=request('Account_Emp');
        $data['User']=auth()->guard('admin')->user()->id;
        $data['Price_Level']=request('Price_Level');
        $data['Bill_Num']=request('Bill_Num');
        $data['NumbersOfBill']=request('NumbersOfBill');
        $data['EmpSort']=request('EmpSort');
        $data['duration_criminal_investigation']=request('duration_criminal_investigation');
        $data['Birthdate']=request('Birthdate');
        $data['Attitude_recruiting']=request('Attitude_recruiting');
        $data['Job_Number']=request('Job_Number');
        $data['date_resignation']=request('date_resignation');
        $data['Living']=request('Living');
        $data['Branch']=request('Branch');
        $data['Level']=request('Level');
        $data['Religion']=request('Religion');
        $data['Insurance_salary']=request('Insurance_salary');
        $data['Insurance_companies']=request('Insurance_companies');
        $data['Previous_experience']=request('Previous_experience');
        $data['Nationality']=request('Nationality');
        $data['MonthlyTarget']=request('MonthlyTarget');
        $data['QuarterTarget']=request('QuarterTarget');
        $data['SemiTarget']=request('SemiTarget');
        $data['YearlyTarget']=request('YearlyTarget');
        $data['IDExpireDate']=request('IDExpireDate');
        $data['LicensExpireDate']=request('LicensExpireDate');
        $data['PassportExpireDate']=request('PassportExpireDate');
        $data['Pro_Group']=request('Pro_Group');
        $data['SearchCode']=request('SearchCode');
        Employess::where('id',$id)->update($data);

        $IDD=Employess::find($id);
        Event::where('Type_Code',$del->Code)->where('Type','الموظفين')->delete();

        if(!empty(request('POSStores'))){
            EmpPOSStores::where('Emp',$id)->delete();
            $Store=request('POSStores');

            for ($i=0; $i < count($Store); $i++) {

                $uu['Store']=$Store[$i];
                $uu['Emp']=$id;
                EmpPOSStores::create($uu);

            }

        }

            //Emp Safes
            if(!empty(request('POSSafes'))){
                EmpSafes::where('Emp',$id)->delete();
                $Safes=request('POSSafes');

                for ($i=0; $i < count($Safes); $i++) {

                    $uu['Safe']=$Safes[$i];
                    $uu['Emp']=$IDD->id;
                    EmpSafes::create($uu);

                }

            }

            //Service Events
            $service->EmpEvents($request->all(),$IDD);

            //Precents
            $service->EmpPrecents($request->all(),$IDD);


            $dataUser=[
                'screen_ar'=>'الموظفين',
                'screen_en'=>'Employee',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('NameEn'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return redirect('EmpSechdule');


        }catch(\Exception $ex){

            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Employess::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    public function TransToEmp($id){
        Employess::where('id',$id)->update(['EmpSort'=>1]);
        session()->flash('success',trans('admin.TransferedSuccessfully'));
        return back();

    }


    public function PrintEmp($id){
        $item=Employess::find($id);
        return view('admin.HR.PrintEmp',['item'=>$item]);
    }

    public function PrintCardEmp($id){
        $item=Employess::find($id);
        return view('admin.HR.PrintCardEmp',['item'=>$item]);
    }

    public function MyGoals(){

        $d = new DateTime('first day of this month');
        $fromP=date('Y-m-d', strtotime(date('Y-m')." -1 month"));
        $ToP=date('Y-m-t',strtotime('last month'));
        $from=$d->format('Y-m-d');
        $to=date('Y-m-t',strtotime('today'));

        $fromQ=date('Y-m-d', strtotime('first day of january this year'));
        $toQ=date('Y-m-d', strtotime("+3 months", strtotime($fromQ)));

        $fromS=date('Y-m-d', strtotime('first day of january this year'));
        $toS=date('Y-m-d', strtotime("+6 months", strtotime($fromS)));

        $fromY=date('Y-m-d', strtotime('first day of january this year'));
        $toY=date('Y-m-d', strtotime('Dec 31'));



        $previousMonthT=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromP,$ToP])
            ->get()->sum('Total_Price');

        $previousMonthTax=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromP,$ToP])
            ->get()->sum('Total_Taxes');

        $previousMonthDisc=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromP,$ToP])
            ->get()->sum('Total_Discount');

        $previousMonth=  ($previousMonthT +  $previousMonthTax)  - $previousMonthDisc ;


        $CurrentMonthT=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$from,$to])
            ->get()->sum('Total_Price');

        $CurrentMonthTax=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$from,$to])
            ->get()->sum('Total_Taxes');

        $CurrentMonthDisc=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$from,$to])
            ->get()->sum('Total_Discount');

        $CurrentMonth=  ($CurrentMonthT +  $CurrentMonthTax)  - $CurrentMonthDisc ;


        $QMonthT=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromQ,$toQ])
            ->get()->sum('Total_Price');

        $QMonthTax=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromQ,$toQ])
            ->get()->sum('Total_Taxes');

        $QMonthDisc=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromQ,$toQ])
            ->get()->sum('Total_Discount');

        $QMonth=  ($QMonthT +  $QMonthTax)  - $QMonthDisc ;


        $SMonthT=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromS,$toS])
            ->get()->sum('Total_Price');

        $SMonthTax=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromS,$toS])
            ->get()->sum('Total_Taxes');

        $SMonthDisc=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromS,$toS])
            ->get()->sum('Total_Discount');

        $SMonth=  ($SMonthT +  $SMonthTax)  - $SMonthDisc ;




        $YMonthT=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromY,$toY])
            ->get()->sum('Total_Price');

        $YMonthTax=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromY,$toY])
            ->get()->sum('Total_Taxes');

        $YMonthDisc=Sales::where('Delegate',auth()->guard('admin')->user()->emp)
            ->whereBetween('Date',[$fromY,$toY])
            ->get()->sum('Total_Discount');

        $YMonth=  ($YMonthT +  $YMonthTax)  - $YMonthDisc ;

        $Emp=Employess::find(auth()->guard('admin')->user()->emp);

        return view('admin.HR.MyGoals',get_defined_vars());

    }


//Salary
    public function AddSalaryPage(){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->whereIn('Parent',[28,29])->get();
        $Code=$this->ReturnCode(PaySalary::class);
        return view('admin.HR.AddSalary',get_defined_vars());

    }

    public function SalarySechdulesPage(){
        $items=PaySalary::paginate(100);
        return view('admin.HR.Salaries',get_defined_vars());
    }

    public function EmpCheckSalary($Emp,$Month) {

        $month=$Month.'-01';
        $point=0;
        $newpp=0;
        $LATER= 0  ;
        $s=0;
        $xx=0;
        $xxx=0;
        $xxxx=0;
        $e=0;
        $PS=0;
        $PEX=0;

        $Sal=Employess::find($Emp);
        $x = Borrowa::where('Delete','!=',1)->where("Month",$Month)->where('Emp',$Emp)->get()->sum('Amount');
        $pp = EmpsProducationPoint::where("Month",$Month)->where('Emp',$Emp)->get()->sum('Point');
        $SETT=Settlement::where('Date','>=',$month)->where('Account_Dificit',$Sal->Account_Emp)->get()->sum('Total_Dificit_Price');
        $SETT +=Consists::where('Delete','!=',1)->where('Date','>=',$month)->where('Account',$Sal->Account_Emp)->get()->sum('Total_Price');
        $saleslater=Sales::where('Delete','!=',1)->where('Edit','!=',1)->where('Status',1)
            ->where('Date','>=',$month)->where('Delegate',$Emp)
            ->where('Payment_Method','Later')->where('Later_Collection',0)
            ->get()->sum('Total_Price');
        $DED=Deduction::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;
        $ENTIT=Entitlement::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;
        $OVER=RegOverTime::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Amount') ;
        $Attendence=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Hours_Number') ;
        $DiscountLate=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Disc_Late') ;
        $DiscountDeparture=DepartureEmp::where('Month',$Month)->where('Emp',$Emp)->get()->sum('Disc_Early') ;
        $Holidays=Holidays::where('Month',$Month)->where('Emp',$Emp)->where('Discount',1)->get()->sum('Num_of_Days') ;
        $Allowances=AllowencesEmp::where('Emp',$Emp)->get()->sum('AmountAllow');
        $Discounts=DiscountsEmp::where('Emp',$Emp)->get()->sum('AmountDiscount');


        $PaySalary = PaySalary::where('Delete','!=',1)->where("Month",$Month)->where('Emp',$Emp)->first();
        $sales=Sales::where('Delete','!=',1)->where('Edit','!=',1)->where('Status',1)->where('Delegate',$Emp)->get();
        $Ex=Sales::where('Delete','!=',1)->where('Edit','!=',1)->where('Status',1)->where('Executor',$Emp)->get();
        $ShP=ShippingList::where('Status',1)->where('Driver',$Emp)->get();
        $Ratios=EmpRatio::where('Emp',$Emp)->get();
        $Qties=EmpsProducationQuantity::where('Emp',$Emp)->get();
        $EmpDets=EmpInstallmentDetails::where('Emp',$Emp)->get() ;

        //Points
        foreach($Qties as $qty){

            if($qty->FromQ <= $pp){
                if($qty->ToQ <= $pp){
                    $newpp=$pp - $qty->ToQ ;
                    $point+=$qty->ValueQ * ($pp - $newpp);

                }

                if($qty->ToQ >= $pp){
                    if($newpp != 0){
                        $point+=$qty->ValueQ * $newpp;
                    }else{

                        $point+=$qty->ValueQ * $pp;
                    }
                }

            }

        }

        //Total Sales
        foreach($sales as $sel){

            $date=$sel->Date;
            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $s += $sel->Total_Net;
            }

        }

        //Total Sales For Executpr
        foreach($Ex as $ex){

            $date=$ex->Date;

            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $xx += $ex->Total_Net;
            }

        }

        //Total Shipping for Driver
        foreach($ShP as $shp){

            $date=$shp->Date;

            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $xxxx += $shp->Total_Price;
            }

        }

        //Employee Installments (Loans)
        foreach($EmpDets as $emD){

            $date=$emD->Date;

            $time=strtotime($date);
            $month=date("Y-m",$time);

            if($month == $Month){
                $xxx += $emD->Value;
            }

        }


        //Take Slaray This Month or Not
        if(!empty($PaySalary)){

            $New = 1 ;

        }else{

            $New = 0 ;
        }


        //Ratios
        foreach($Ratios as $r){

            //Ratio of Shipping
            if($r->Typee == 1){

                if($r->From  <=  $xxxx  and $r->To  >=  $xxxx ){

                    $z=$r->Rate  / 100 ;
                    $zz= $z *  $xxxx ;
                    $e += $zz;

                }else{

                    $e+=0;

                }


            }

//Ratio of Sales
            if($r->Typee == 1){

                if($r->From  <=  $s  and $r->To  >=  $s ){

                    $z=$r->Rate  / 100 ;
                    $zz= $z *  $s ;
                    $PS += $zz;

                }else{

                    $PS+=0;

                }


            }

//Ratio of Execute
            if($r->Typee == 2){

                if($r->From  <=  $xx  and $r->To  >=  $xx ){

                    $z=$r->Rate  / 100 ;
                    $zz= $z *  $xx ;
                    $PEX += $zz;

                }else{

                    $PEX+=0;

                }


            }

        }


        $HourCost=$Sal->Salary / $Sal->Hours_Numbers ;
        $disc= $Attendence * $HourCost ;
        $discT= $Sal->Salary - $disc ;
        $WorkDay =  $Sal->Hours_Numbers / 30 ;
        $HoliDiscount = ($HourCost * $WorkDay) * $Holidays ;


        $states=[];
        $states += [
            "Total" => $x ,
            'Salary' => $Sal->Salary ,
            'Sales' => $PS,
            'Exec' =>$PEX ,
            'Dedu' =>$DED ,
            'Entit' =>$ENTIT ,
            'Loan' =>$xxx ,
            'Over' =>$OVER ,
            'HWork' =>$Sal->Hours_Numbers,
            'Att' =>$Attendence  ,
            'AttDisc' =>$discT ,
            'Holi' =>$Holidays  ,
            'HoliDisc' =>$HoliDiscount,
            'New'=>$New,
            'Settle'=>$SETT,
            'later'=>$LATER,
            'Allowances'=>$Allowances,
            'Discounts'=>$Discounts,
            'Points'=>$point,
            'DiscountLate'=>$DiscountLate,
            'DiscountDeparture'=>$DiscountDeparture,
            'Shipping_Precent'=>$e
        ];


        return response()->json($states);

    }

    public function PostAddSalary(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Resduial_Salary'=>'required',
            'Draw'=>'required',
            'Safe'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
        ],[


        ]);

            $AccDefff=AccountsDefaultData::latest('id')->first();

            //Safe Credit
        $SafyFatora=request('Resduial_Salary');
        $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);
        if($SafeBalance == 1){
            session()->flash('error',trans('admin.SafeNotEnoughMoney'));
            return back();

        }


        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Salary']=request('Salary');
        $data['Pre_Sales']=request('Pre_Sales');
        $data['Pre_Execu']=request('Pre_Execu');
        $data['Deduction']=request('Deduction');
        $data['Entitlement']=request('Entitlement');
        $data['Borrow']=request('Borrow');
        $data['Overtime']=request('Overtime');
        $data['Attendence_Hours']=request('Attendence_Hours');
        $data['Attendence']=request('Attendence');
        $data['Loan']=request('Loan');
        $data['Holidays']=request('Holidays');
        $data['Resduial_Salary']=request('Resduial_Salary');
        $data['Note']=request('Note');
        $data['Draw']=request('Draw');
        $data['Safe']=request('Safe');
        $data['Coin']=request('Coin');
        $data['Cost_Center']=request('Cost_Center');
        $data['Emp']=request('Emp');
        $data['Settlements']=request('Settlements');
        $data['Later_Sales_Bill']=request('Later_Sales_Bill');
        $data['Attendence_Discount']=request('Attendence_Discount');
        $data['Holiday_Discount']=request('Holiday_Discount');
        $data['Allowances']=request('Allowances');
        $data['Discounts']=request('Discounts');
        $data['ProducationPoints']=request('ProducationPoints');
        $data['DiscountLate']=request('DiscountLate');
        $data['DiscountDeparture']=request('DiscountDeparture');
        $data['Shipping_Precent']=request('Shipping_Precent');
        $data['User']=auth()->guard('admin')->user()->id;

        PaySalary::create($data);

        $CodeT=PaySalary::latest('id')->first()->Code;

            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'صرف راتب',
                    'TypeEn' => 'Pay Salary',
                    'Code_Type' => $CodeT,
                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => request('Cost_Center'),
                    'Total_Debaitor' => request('Amount'),
                    'Total_Creditor' => request('Amount'),
                    'Note' => request('Note'),

                )
            );

            $Code=Journalizing::findOrFail($ID)->first()->Code;
            $Emp=Employess::find(request('Emp'));

        if($AccDefff->Salary == 2){

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=request('Resduial_Salary');
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$Emp->Merit;
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']= 'صرف راتب';
            $Gen['TypeEn']='Pay Salary';
            $Gen['Debitor']=request('Resduial_Salary');
            $Gen['Creditor']=0;
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * request('Resduial_Salary');
            $Gen['Creditor_Coin']=request('Draw') * 0;
            $Gen['Account']=$Emp->Merit;
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=request('Resduial_Salary');
            $PRODUCTSS['Account']=request('Safe');
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']= 'صرف راتب';
            $Gen['TypeEn']='Pay Salary';
            $Gen['Debitor']=0;
            $Gen['Creditor']=request('Resduial_Salary');
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * 0;
            $Gen['Creditor_Coin']=request('Draw') * request('Resduial_Salary');
            $Gen['Account']=request('Safe');
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);

        }else{


            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=request('Resduial_Salary');
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$Emp->Account_Emp;
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']= 'صرف راتب';
            $Gen['TypeEn']='Pay Salary';
            $Gen['Debitor']=request('Resduial_Salary');
            $Gen['Creditor']=0;
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * request('Resduial_Salary');
            $Gen['Creditor_Coin']=request('Draw') * 0;
            $Gen['Account']=$Emp->Account_Emp;
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=request('Resduial_Salary');
            $PRODUCTSS['Account']=request('Safe');
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']= 'صرف راتب';
            $Gen['TypeEn']='Pay Salary';
            $Gen['Debitor']=0;
            $Gen['Creditor']=request('Resduial_Salary');
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * 0;
            $Gen['Creditor_Coin']=request('Draw') * request('Resduial_Salary');
            $Gen['Account']=request('Safe');
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);
        }

        if(request('Loan') != 0){


            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'قسط قرض',
                    'TypeEn' =>'Loan Installment',
                    'Code_Type' => $CodeT,
                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => request('Cost_Center'),
                    'Total_Debaitor' => request('Loan'),
                    'Total_Creditor' => request('Loan'),
                    'Note' => request('Note'),

                )
            );
            $Code=Journalizing::findOrFail($ID)->first()->Code;


            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=request('Loan');
            $PRODUCTSS['Account']=$Emp->Covenant;
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='قسط قرض';
            $Gen['TypeEn']='Loan Installment';
            $Gen['Debitor']=0;
            $Gen['Creditor']= request('Loan');
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * 0;
            $Gen['Creditor_Coin']=request('Draw') *  request('Loan');
            $Gen['Account']=$Emp->Covenant;
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=request('Loan');
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=request('Safe');
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='قسط قرض';
            $Gen['TypeEn']='Loan Installment';
            $Gen['Debitor']=request('Loan');
            $Gen['Creditor']=0;
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * request('Loan');
            $Gen['Creditor_Coin']=request('Draw') * 0;
            $Gen['Account']=request('Safe');
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;
            GeneralDaily::create($Gen);


            $FromDate=request('Month').'-01';
            $ToDate = date("Y-m-t", strtotime($FromDate));

            $date=EmpInstallmentDetails::where('Emp',request('Emp'))->whereBetween('Date',[$FromDate,$ToDate])->latest('id')->first();


              EmpInstallmentDetails::where('id',$date->id)->update(['Status'=>1]);


        }


            $dataUser=[
                'screen_ar'=>'الرواتب',
                'screen_en'=>'Salaries',
                'explain_ar'=>$CodeT,
                'explain_en'=>$CodeT,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=PaySalary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=PaySalary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeletePaySalary($id){

        try {
            DB::beginTransaction();

            $del=PaySalary::find($id);

        GeneralDaily::where('Code_Type',$del->Code)->where('Type','صرف راتب')->delete();
        GeneralDaily::where('Code_Type',$del->Code)->where('Type','قسط قرض')->delete();
        Journalizing::where('Code_Type',$del->Code)->where('Type','صرف راتب')->update(['Delete'=>1]);
        Journalizing::where('Code_Type',$del->Code)->where('Type','قسط قرض')->update(['Delete'=>1]);
        PaySalary::where('id',$id)->update(['Delete'=>1]);

            $dataUser=[
                'screen_ar'=>'الرواتب',
                'screen_en'=>'Salaries',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=PaySalary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=PaySalary::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //Exchange Commissions
    public function ExchangeCommissionsPage(){
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->whereIn('Parent',[28,29])->get();
        $Code=$this->ReturnCode(ExchangeCommissions::class);
        return view('admin.HR.ExchangeCommissions',get_defined_vars());

    }

    public function EmpCheckCommision($Emp) {

        $s=0;
        $sR=0;
        $e=0;

        $EXX=ExchangeCommissions::where('Delete','!=',1)->where('Emp',$Emp)->get()->sum('Amount');
        $sales=Sales::where('Delete','!=',1)->where('Edit','!=',1)->where('Status',1)->where('Delegate',$Emp)->where('Later_Collection',1)->get()->sum('Total_Net');
        $Recipts=ReciptVoucher::where('Delete','!=',1)->where('Edit','!=',1)->where('Status',1)->where('Collector',$Emp)->get()->sum('Total_Creditor');
        $Ratios=EmpRatio::where('Emp',$Emp)->get();
        $Executors=ProductSales::whereRelation('Sales','Delete','!=',1)->whereRelation('Sales','Delete','!=',1)->where('Executor',$Emp)->where('Later_Collection',1)->get()->sum('Total_Net');
        $ExecutorsCost=ProductSales::whereRelation('Sales','Delete','!=',1)->whereRelation('Sales','Delete','!=',1)->where('Executor',$Emp)->where('Later_Collection',1)->get()->sum('TotCostNew');

        $diff= $Executors - $ExecutorsCost ;

        //Ratios
        foreach($Ratios as $r){
            if($r->Typee == 3){

                if($r->From  <=  $Recipts  and $r->To  >=  $Recipts ){


                    $xR=$r->Rate  / 100 ;
                    $xxR= $xR *  $Recipts ;
                    $sR+=$xxR;

                }else{

                    $sR+=0;

                }


            }

            if($r->Typee == 1){

                if($r->From  <=  $sales  and $r->To  >=  $sales ){

                    $x=$r->Rate  / 100 ;
                    $xx= $x *  $sales ;
                    $s+=$xx;

                }else{

                    $s+=0;

                }


            }

            if($r->Typee == 2){

                if($r->From  <=  $diff  and $r->To  >=  $diff ){

                    $z=$r->Rate  / 100 ;
                    $zz= $z *  $diff ;
                    $e += $zz;

                }else{

                    $e+=0;

                }


            }

        }


        $states=[];
        $states += ['Sales' => $s, 'Exec' =>$e , 'Retu' =>0 , 'Ex' =>$EXX,'collector'=>$sR];

        return response()->json($states);

    }

    public function PostExchangeCommissions(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Date'=>'required',
            'Draw'=>'required',
            'Safe'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
        ],[


        ]);
            $AccDefff=AccountsDefaultData::orderBy('id','desc')->first();


            //Safe Credit
            $SafyFatora=request('Amount');
            $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);
            if($SafeBalance == 1){
                session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                return back();

            }


            $data['Date']=request('Date');
        $data['Month']=null;
        $data['Note']=request('Note');
        $data['Draw']=request('Draw');
        $data['Amount']=request('Amount');
        $data['Commision']=request('Commision');
        $data['Total_Exchange_Commision']=request('Total_Exchange_Commision');
        $data['Pre_Sales']=request('Pre_Sales');
        $data['Pre_Execu']=request('Pre_Execu');
        $data['Return_Maintaince']=request('Return_Maintaince');
        $data['Safe']=request('Safe');
        $data['Coin']=request('Coin');
        $data['Cost_Center']=request('Cost_Center');
        $data['Emp']=request('Emp');
        $data['Collection']=request('Collection');
        $data['User']=auth()->guard('admin')->user()->id;;
        ExchangeCommissions::create($data);


            $CodeT=ExchangeCommissions::latest('id')->first()->Code;


            $ID = DB::table('journalizings')->insertGetId(

                array(

                    'Type' => 'صرف عمولات',
                    'TypeEn' => 'Exchange Commissions',
                    'Code_Type' =>$CodeT,
                    'Date' => request('Date'),
                    'Draw' => request('Draw'),
                    'Coin' => request('Coin'),
                    'Cost_Center' => request('Cost_Center'),
                    'Total_Debaitor' => request('Amount'),
                    'Total_Creditor' => request('Amount'),
                    'Note' => request('Note'),

                )
            );



            $Code=Journalizing::findOrFail($ID)->first()->Code;
            $Emp=Employess::find(request('Emp'));

        if($AccDefff->Commission == 2){

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=request('Amount');
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$Emp->Merit;
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف عمولات';
            $Gen['TypeEn']='Exchange Commissions';
            $Gen['Debitor']=request('Amount');
            $Gen['Creditor']=0;
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * request('Amount');
            $Gen['Creditor_Coin']=request('Draw') * 0;
            $Gen['Account']=$Emp->Merit;
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=request('Amount');
            $PRODUCTSS['Account']=request('Safe');
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف عمولات';
            $Gen['TypeEn']='Exchange Commissions';
            $Gen['Debitor']=0;
            $Gen['Creditor']=request('Amount');
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * 0;
            $Gen['Creditor_Coin']=request('Draw') * request('Amount');
            $Gen['Account']=request('Safe');
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);

        }else{


            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=request('Amount');
            $PRODUCTSS['Creditor']=0;
            $PRODUCTSS['Account']=$Emp->Commission;
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف عمولات';
            $Gen['TypeEn']='Exchange Commissions';
            $Gen['Debitor']=request('Amount');
            $Gen['Creditor']=0;
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * request('Amount');
            $Gen['Creditor_Coin']=request('Draw') * 0;
            $Gen['Account']=$Emp->Commission;
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);

            $PRODUCTSS['Joun_ID']=$ID;
            $PRODUCTSS['Debitor']=0;
            $PRODUCTSS['Creditor']=request('Amount');
            $PRODUCTSS['Account']=request('Safe');
            $PRODUCTSS['Statement']=null;
            JournalizingDetails::create($PRODUCTSS);

            $Gen['Code']=$Code;
            $Gen['Code_Type']=$CodeT;
            $Gen['Date']=request('Date');
            $Gen['Type']='صرف عمولات';
            $Gen['TypeEn']='Exchange Commissions';
            $Gen['Debitor']=0;
            $Gen['Creditor']=request('Amount');
            $Gen['Statement']=null;
            $Gen['Draw']=request('Draw');
            $Gen['Debitor_Coin']= request('Draw') * 0;
            $Gen['Creditor_Coin']=request('Draw') * request('Amount');
            $Gen['Account']=request('Safe');
            $Gen['Coin']= request('Coin');
            $Gen['Cost_Center']= request('Cost_Center');
            $Gen['userr']= auth()->guard('admin')->user()->id;

            GeneralDaily::create($Gen);
        }


            $dataUser=[
                'screen_ar'=>'صرف عموله',
                'screen_en'=>'Exchange Commissions',
                'explain_ar'=>$CodeT,
                'explain_en'=>$CodeT,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ExchangeCommissions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ExchangeCommissions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function ExchangeCommissionsSechdule(){
        $items=ExchangeCommissions::paginate(100);
        return view('admin.HR.ExchangeCommissionsSechules',[
            'items'=>$items,
        ]);
    }

    public function DeleteCommission($id){

        try {
            DB::beginTransaction();
        $del=ExchangeCommissions::find($id);

        GeneralDaily::where('Code_Type',$del->Code)->where('Type','صرف عمولات')->delete();
        Journalizing::where('Code_Type',$del->Code)->where('Type','صرف عمولات')->update(['Delete'=>1]);
        ExchangeCommissions::where('id',$id)->update(['Delete'=>1]);


            $dataUser=[
                'screen_ar'=>'صرف عموله',
                'screen_en'=>'Exchange Commissions',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=ExchangeCommissions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ExchangeCommissions::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


    //======  Borrow =======
    public function BorrowPage(){
        $items=Borrowa::paginate(100);
        return view('admin.HR.Borrows',['items'=>$items,]);
    }

    public function AddBorrowPage(){

        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->whereIn('Parent',[28,29])->get();
        $Code=$this->ReturnCode(Borrowa::class);
        return view('admin.HR.AddBorrow',[
            'CostCenters'=>$CostCenters,
            'Coins'=>$Coins,
            'Safes'=>$Safes,
            'Code'=>$Code,
        ]);

    }

    public function EmpCheck($Emp,$Month) {

        $Sal=Employess::find($Emp);
        $x = Borrowa::where('Delete','!=',1)->where("Month",$Month)->where('Emp',$Emp)->get()->sum('Amount');
        $TakeSalary = PaySalary::where('Delete','!=',1)->where("Month",$Month)->where('Emp',$Emp)->get();
        if(count($TakeSalary) != 0){
            $salary=1;
        }else{
            $salary=0;
        }

        $states=[];
        $states += ["Total" => $x ,'Salary' => $Sal->Salary,'TakeSalary'=>$salary];
        return response()->json($states);

    }

    public function PostAddBorrow(){

        try {
            DB::beginTransaction();


            $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Draw'=>'required',
            'Safe'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
        ],[


        ]);

            //Safe Credit
            $SafyFatora=request('Amount');
            $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);
            if($SafeBalance == 1){
                session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                return back();

            }


        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Draw']=request('Draw');
        $data['Note']=request('Note');
        $data['Safe']=request('Safe');
        $data['Emp']=request('Emp');
        $data['Coin']=request('Coin');
        $data['Cost_Center']=request('Cost_Center');
        $data['User']=auth()->guard('admin')->user()->id;

        Borrowa::create($data);


            $CodeT=Borrowa::latest('id')->first()->Code;
        $ID = DB::table('journalizings')->insertGetId(

            array(

                'Type' => 'سلفه موظف',
                'TypeEn' => 'Employee Borrow',
                'Code_Type' => $CodeT,
                'Date' => request('Date'),
                'Draw' => request('Draw'),
                'Coin' => request('Coin'),
                'Cost_Center' => request('Cost_Center'),
                'Total_Debaitor' => request('Amount'),
                'Total_Creditor' => request('Amount'),
                'Note' => request('Note'),

            )
        );

            $Code=Journalizing::findOrFail($ID)->first()->Code;
        $Emp=Employess::find(request('Emp'));

        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=request('Amount');
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$Emp->Account_Emp;
        $PRODUCTSS['Statement']=null;
        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$CodeT;
        $Gen['Date']=request('Date');
        $Gen['Type']='سلفه موظف';
        $Gen['TypeEn']='Employee Borrow';
        $Gen['Debitor']=request('Amount');
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * request('Amount');
        $Gen['Creditor_Coin']=request('Draw') * 0;
        $Gen['Account']=$Emp->Account_Emp;
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']= request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;
        GeneralDaily::create($Gen);

        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=request('Amount');
        $PRODUCTSS['Account']=request('Safe');
        $PRODUCTSS['Statement']=null;
        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$CodeT;
        $Gen['Date']=request('Date');
        $Gen['Type']='سلفه موظف';
        $Gen['TypeEn']='Employee Borrow';
        $Gen['Debitor']=0;
        $Gen['Creditor']=request('Amount');
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * 0;
        $Gen['Creditor_Coin']=request('Draw') * request('Amount');
        $Gen['Account']=request('Safe');
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']= request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;
        GeneralDaily::create($Gen);


            $dataUser=[
                'screen_ar'=>'السلف',
                'screen_en'=>'Borrows',
                'explain_ar'=>$CodeT,
                'explain_en'=>$CodeT,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Borrowa::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Borrowa::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteBorrow($id){

        try {
            DB::beginTransaction();


            $del=Borrowa::find($id);

        GeneralDaily::where('Code_Type',$del->Code)->where('Type','سلفه موظف')->delete();
        Journalizing::where('Code_Type',$del->Code)->where('Type','سلفه موظف')->update(['Delete'=>1]);
            Borrowa::where('id',$id)->update(['Delete'=>1]);

        $dataUser=[
            'screen_ar'=>'السلف',
            'screen_en'=>'Borrows',
            'explain_ar'=>$del->Code,
            'explain_en'=>$del->Code,
        ];
        $this->UserDeleteMoves($dataUser);
        DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();

    }catch(\Exception $ex){

$MODEL=Borrowa::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=Borrowa::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}

    }

    //Loan
    public function AddLoanPage(){

        $Types=LoanTypes::all();
        $CostCenters=CostCenter::all();
        $Coins=Coins::all();
        $Safes = AcccountingManual::where('Type',1)->whereIn('Parent',[28,29])->get();
        $Code=$this->ReturnCode(Loan::class);
        return view('admin.HR.AddLoan',get_defined_vars());

    }

    public function PostAddLoan(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Date'=>'required',
            'Month'=>'required',
            'Amount'=>'required',
            'Draw'=>'required',
            'Safe'=>'required',
            'Emp'=>'required',
            'Coin'=>'required',
        ],[


        ]);

            //Safe Credit
            $SafyFatora=request('Amount');
            $SafeBalance=$this->SafeCredit(request('Safe'),$SafyFatora);
            if($SafeBalance == 1){
                session()->flash('error',trans('admin.SafeNotEnoughMoney'));
                return back();

            }

        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Amount']=request('Amount');
        $data['Years_Number']=request('Years_Number');
        $data['First_Date']=request('First_Date');
        $data['Install']=request('Install');
        $data['Install_Numbers']=request('Install_Numbers');
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['Cost_Center']=request('Cost_Center');
        $data['Draw']=request('Draw');
        $data['Safe']=request('Safe');
        $data['Coin']=request('Coin');
        $data['User']=auth()->guard('admin')->user()->id;
        Loan::create($data);

            $CodeT=Borrowa::latest('id')->first()->Code;

        $ID = DB::table('journalizings')->insertGetId(

            array(

                'Type' => 'قرض موظف',
                'TypeEn' => 'Employee Loan',
                'Code_Type' => $CodeT,
                'Date' => request('Date'),
                'Draw' => request('Draw'),
                'Coin' => request('Coin'),
                'Cost_Center' => request('Cost_Center'),
                'Total_Debaitor' => request('Amount'),
                'Total_Creditor' => request('Amount'),
                'Note' => request('Note'),

            )
        );

            $Code=Journalizing::findOrFail($ID)->first()->Code;
        $Emp=Employess::find(request('Emp'));

        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=request('Amount');
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$Emp->Covenant;
        $PRODUCTSS['Statement']=null;
        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$CodeT;
        $Gen['Date']=request('Date');
        $Gen['Type']='قرض موظف';
        $Gen['TypeEn']='Employee Loan';
        $Gen['Debitor']=request('Amount');
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * request('Amount');
        $Gen['Creditor_Coin']=request('Draw') * 0;
        $Gen['Account']=$Emp->Covenant;
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']= request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);

        $PRODUCTSS['Joun_ID']=$ID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=request('Amount');
        $PRODUCTSS['Account']=request('Safe');
        $PRODUCTSS['Statement']=null;
        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$CodeT;
        $Gen['Date']=request('Date');
        $Gen['Type']='قرض موظف';
        $Gen['TypeEn']='Employee Loan';
        $Gen['Debitor']=0;
        $Gen['Creditor']=request('Amount');
        $Gen['Statement']=null;
        $Gen['Draw']=request('Draw');
        $Gen['Debitor_Coin']= request('Draw') * 0;
        $Gen['Creditor_Coin']=request('Draw') * request('Amount');
        $Gen['Account']=request('Safe');
        $Gen['Coin']= request('Coin');
        $Gen['Cost_Center']= request('Cost_Center');
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);



        //Loans Installments
        $L=Loan::latest('id')->first();

        $installmentsID = DB::table('emp_installments')->insertGetId(
            array(

                'Amount' => request('Amount'),
                'Years_Number' => request('Years_Number'),
                'First_Date' => request('First_Date'),
                'Install' => request('Install'),
                'Install_Numbers' => request('Install_Numbers'),
                'Status' => 0,
                'Emp' => request('Emp'),
                'Loan' => $L->id,

            )
        );
        $resdTotal=request('Amount') ;
        $monthly = request('Years_Number') * 12 ;
        $valueMonth = $resdTotal / $monthly ;


        $date=request('First_Date');
        for($i=0 ; $i < $monthly ; $i++){

            $inst['Date']=$date;
            $inst['Value']=$valueMonth;
            $inst['Status']=0;
            $inst['Emp']=request('Emp');
            $inst['Install']=$installmentsID;
            EmpInstallmentDetails::create($inst);


            $event['Start_Date']=$date;
            $event['End_Date']=$date;
            $event['Event_Ar_Name']='قسط موظف';
            $event['Event_En_Name']='Employee Installment';
            $event['Type']='قسط موظف';
            $event['Type_ID']=null;
            $event['Type_Code']=$CodeT;
            $event['Emp']=request('Emp');
            $event['Client']=null;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);


            $date = date('Y-m-d',strtotime('+1 month',strtotime($date))) ;


        }


            $dataUser=[
                'screen_ar'=>'القروض',
                'screen_en'=>'Loans',
                'explain_ar'=>$CodeT,
                'explain_en'=>$CodeT,
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();


        }catch(\Exception $ex){

            $MODEL=Loan::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Loan::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function LoanPage(){
        $items=Loan::paginate(100);
        return view('admin.HR.Loan',['items'=>$items]);
    }

    public function DeleteLoan($id){

        try {
            DB::beginTransaction();

        $del=Loan::find($id);
        GeneralDaily::where('Code_Type',$del->Code)->where('Type','قرض موظف')->delete();
        Journalizing::where('Code_Type',$del->Code)->where('Type','قرض موظف')->update(['Delete'=>1]);
        Loan::where('id',$id)->update(['Delete'=>1]);
        Event::where('Type_Code',$del->Code)->where('Type','قسط موظف')->delete();
        EmpInstallment::where('Loan',$del->id)->delete();


            $dataUser=[
                'screen_ar'=>'القروض',
                'screen_en'=>'Loans',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Loan::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Loan::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //ResignationRequest
    public function ResignationRequest(){
        $items=ResignationRequest::where('Emp',auth()->guard('admin')->user()->emp)->paginate(100);
        $Code=$this->ReturnCode(ResignationRequest::class);
        return view('admin.HR.ResignationRequest',get_defined_vars());
    }

    public function AddResignationRequest(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',


        ],[

        ]);

        $image=request()->file('File');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='Resignation_DateImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }
        if(!empty($image_url)){

            $data['File']=$image_url;

        }else{
            $data['File']=null;
        }


        $data['Date']=request('Date');
        $data['Resignation_Date']=request('Resignation_Date');
        $data['Emp']=auth()->guard('admin')->user()->emp;
        $data['Note']=request('Note');
        $data['Status']=0;
        $data['Reason']=null;
        ResignationRequest::create($data);

            $dataUser=[
                'screen_ar'=>'طلب استقاله',
                'screen_en'=>'Resignation Request',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();
        }catch(\Exception $ex){

            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditResignationRequest($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[

            'Date'=>'required',


        ],[

        ]);

        $image=request()->file('File');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='Resignation_DateImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        if(!empty($image_url)){

            $data['File']=$image_url;

        }else{
            $data['File']=request('Files');
        }

        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Resignation_Date']=request('Resignation_Date');
        $data['Emp']=auth()->guard('admin')->user()->emp;
        $data['Note']=request('Note');
        $data['Status']=request('Status');
        $data['Reason']=request('Reason');


        ResignationRequest::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'طلب استقاله',
                'screen_en'=>'Resignation Request',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();
        }catch(\Exception $ex){

            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteResignationRequest($id){
        try {
            DB::beginTransaction();
        $del=ResignationRequest::find($id);

            $dataUser=[
                'screen_ar'=>'طلب استقاله',
                'screen_en'=>'Resignation Request',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();

        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=ResignationRequest::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function ResignationRequestSechdule(){
        $items=ResignationRequest::where('Status',0)->paginate(100);
        return view('admin.HR.ResignationRequestSechdule',['items'=>$items,]);
    }

    public function AcceptResignation($id){
        ResignationRequest::where('id',$id)->update(['Status'=>1]);
        session()->flash('success',trans('admin.Accepted'));
        return back();

    }

    public function RefuseResignation(){
        $id=request('ID');
        ResignationRequest::where('id',$id)->update(['Status'=>2,'Reason'=>request('Reason')]);
        session()->flash('success',trans('admin.Refused'));
        return back();

    }



    //======  Holidays =======
    public function HolidaysPage(){
        $items=Holidays::where('Status',0)->paginate(100);
        $HolidaysTypes=HolidaysTypes::all();
        $Code=$this->ReturnCode(Holidays::class);
        return view('admin.HR.Holidays',get_defined_vars());
    }

    public function AddHolidays(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Num_of_Days'=>'required',
            'Start_Date'=>'required',
            'Discount'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);

        $Emp=request('Emp');

        for($i=0 ; $i < count($Emp) ;  $i++){

            $data['Date']=request('Date');
            $data['Month']=request('Month');
            $data['Num_of_Days']=request('Num_of_Days');
            $data['Start_Date']=request('Start_Date');
            $data['Discount']=request('Discount');
            $data['Status']=0;
            $data['Note']=request('Note');
            $data['Emp']=$Emp[$i];
            $data['Type']=request('Type');
            $data['User']=auth()->guard('admin')->user()->id;
            Holidays::create($data);

            $Code=Holidays::latest('id')->first()->Code;

            $event['Start_Date']=request('Start_Date');
            $event['End_Date']=date('Y-m-d', strtotime(request('Start_Date'). ' + '.request('Num_of_Days').' days'));
            $event['Event_Ar_Name']='اجازة موظف';
            $event['Event_En_Name']='Employee leave';
            $event['Type']='الاجازات';
            $event['Type_ID']=null;
            $event['Type_Code']=$Code;
            $event['Emp']=$Emp[$i];
            $event['Client']=null;
            $event['Product']=null;
            $event['Customer']=null;
            Event::create($event);

            $dataUser=[
                'screen_ar'=>'الاجازات',
                'screen_en'=>'Holidays',
                'explain_ar'=>$Code,
                'explain_en'=>$Code,
            ];
            $this->UserCreateMoves($dataUser);


        }

            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();


        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditHolidays($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Num_of_Days'=>'required',
            'Start_Date'=>'required',
            'Discount'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Num_of_Days']=request('Num_of_Days');
        $data['Start_Date']=request('Start_Date');
        $data['Discount']=request('Discount');
        $data['Status']=0;
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;
        Holidays::where('id',$id)->update($data);

            $dataUser=[
                'screen_ar'=>'الاجازات',
                'screen_en'=>'Holidays',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();
        session()->flash('success',trans('admin.Updated'));
        return back();


        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteHolidays($id){

        try {
            DB::beginTransaction();

        $del=Holidays::find($id);

            $dataUser=[
                'screen_ar'=>'الاجازات',
                'screen_en'=>'Holidays',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserUpdateMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function HolidaysTypeFilter($type) {

        $typ=HolidaysTypes::find($type);
        $states=[];
        $states += ["Total" => $typ->Days ];
        return response()->json($states);

    }



    //======  Holidays Order =======
    public function HolidaysOrderPage(){
        $items=Holidays::where('Status',1)->paginate(100);
        $HolidaysTypes=HolidaysTypes::all();
        $Code=$this->ReturnCode(Holidays::class);
        return view('admin.HR.HolidaysOrders',get_defined_vars());
    }

    public function AddHolidaysOrder(){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Num_of_Days'=>'required',
            'Start_Date'=>'required',
            'Discount'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Num_of_Days']=request('Num_of_Days');
        $data['Start_Date']=request('Start_Date');
        $data['Discount']=request('Discount');
        $data['Status']=1;
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;

        Holidays::create($data);


        $notii['Date']=date('Y-m-d');
        $notii['Status']=0;
        $notii['Noti_Ar_Name']='طلب اجازة';
        $notii['Noti_En_Name']='Holiday Request';
        $notii['Type']='الاجازات';
        $notii['TypeEn']='Holidays';
        $notii['Type_Code']=request('Code');
        $notii['Emp']=request('Emp');
        $notii['Client']=null;
        $notii['Product']=null;
        $notii['Store']=null;
        $notii['Safe']=null;
        Notifications::create($notii);

        notify()->success(trans('admin.HolidayRequest'));


            $dataUser=[
                'screen_ar'=>'طلب اجازه',
                'screen_en'=>'Holiday Order',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

            session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditHolidaysOrder($id){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',
            'Num_of_Days'=>'required',
            'Start_Date'=>'required',
            'Discount'=>'required',
            'Emp'=>'required',
            'Type'=>'required',


        ],[

        ]);


        $del=Holidays::find($id);
        Notifications::where('Type_Code',$del->Code)->where('Type','الاجازات')->delete();

        $data['Code']=request('Code');
        $data['Date']=request('Date');
        $data['Month']=request('Month');
        $data['Num_of_Days']=request('Num_of_Days');
        $data['Start_Date']=request('Start_Date');
        $data['Discount']=request('Discount');
        $data['Status']=1;
        $data['Note']=request('Note');
        $data['Emp']=request('Emp');
        $data['Type']=request('Type');
        $data['User']=auth()->guard('admin')->user()->id;
        Holidays::where('id',$id)->update($data);


        $notii['Date']=date('Y-m-d');
        $notii['Status']=0;
        $notii['Noti_Ar_Name']='طلب اجازة';
        $notii['Noti_En_Name']='Holiday Request';
        $notii['Type']='الاجازات';
        $notii['TypeEn']='Holidays';
        $notii['Type_Code']=request('Code');
        $notii['Emp']=request('Emp');
        $notii['Client']=null;
        $notii['Product']=null;
        $notii['Store']=null;
        $notii['Safe']=null;
        Notifications::create($notii);
        notify()->success(trans('admin.HolidayRequest'));

            $dataUser=[
                'screen_ar'=>'طلب اجازه',
                'screen_en'=>'Holiday Order',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DeleteHolidaysOrder($id){

        try {
            DB::beginTransaction();
        $del=Holidays::find($id);
        Notifications::where('Type_Code',$del->Code)->where('Type','الاجازات')->delete();

            $dataUser=[
                'screen_ar'=>'طلب اجازه',
                'screen_en'=>'Holiday Order',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return back();
        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function HolidaysOrderTypeFilter($type) {
        $typ=HolidaysTypes::find($type);
        $states=[];
        $states += ["Total" => $typ->Days ];
        return response()->json($states);
    }

    public function TransToHoilday($id){

        try {
            DB::beginTransaction();


        Holidays::where('id',$id)->update(['Status'=>0]);
        $del=Holidays::find($id);
        $event['Start_Date']=$del->Start_Date;
        $event['End_Date']=date('Y-m-d', strtotime($del->Start_Date. ' + '.$del->Num_of_Days.' days'));
        $event['Event_Ar_Name']='اجازة موظف';
        $event['Event_En_Name']='Employee leave';
        $event['Type']='الاجازات';
        $event['Type_ID']=null;
        $event['Type_Code']=$del->Code;
        $event['Emp']=$del->Emp;
        $event['Client']=null;
        $event['Product']=null;
        $event['Customer']=null;
        Event::create($event);
            DB::commit();
        session()->flash('success',trans('admin.Converted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Holidays::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }


//Attendance
    public function AttendancePage(){
        $Code=$this->ReturnCode(Attendance::class);
        return view('admin.HR.Attendance',get_defined_vars());
    }

    public function EmpNameFilter($Emp) {

        $emp=Employess::find($Emp);
        $states=[];

        if(app()->getLocale() == 'ar' ){
            $states += ['name' => $emp->Name];
        }else{
            $states += ['name' => $emp->NameEn];
        }

        return response()->json($states);

    }

    public function AddAttendance(){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',



        ],[

        ]);

        $ID = DB::table('attendances')->insertGetId(

            array(


                'Date' => request('Date'),
                'Month' => request('Month'),
                'Note' => request('Note'),
                'Status' => 0,
                'User' =>auth()->guard('admin')->user()->id,
            )
        );


        if(!empty(request('Emp'))){

            $Emp=request('Emp');
            $In_Time=request('In_Time');
            $NoteEmp=request('NoteEmp');

            for($i=0 ; $i < count($Emp) ; $i++){

                $emp['In_Time']=$In_Time[$i];
                $emp['Date']=request('Date');
                $emp['Month']=request('Month');
                $emp['Note']=$NoteEmp[$i];
                $emp['Attend']=$ID;
                $emp['Emp']=$Emp[$i];
                AttendanceEmp::create($emp);
            }
        }


            $dataUser=[
                'screen_ar'=>'الحضور',
                'screen_en'=>'Attendance',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);

            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function AttendanceSechdulePage(){
        $items=Attendance::orderBy('id','desc')->paginate(100);
        return view('admin.HR.AttendanceSechdule',['items'=>$items,]);
    }

    public function DeleteAttendance($id){

        try {
            DB::beginTransaction();
        $del=Attendance::find($id);

            $dataUser=[
                'screen_ar'=>'الحضور',
                'screen_en'=>'Attendance',
                'explain_ar'=>$del->Code,
                'explain_en'=>$del->Code,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();


        session()->flash('error',trans('admin.Deleted'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditAttendancePage($id){
        $item=Attendance::find($id);
        $details=AttendanceEmp::where('Attend',$item->id)->get();
        return view('admin.HR.EditAttendance',get_defined_vars());
    }

    public function PostEditAttendance($id){
        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',



        ],[

        ]);

        $data['Code'] = request('Code');
        $data['Date'] = request('Date');
        $data['Month'] = request('Month');
        $data['Note'] = request('Note');
        $data['Status'] = 0;
        $data['User'] =auth()->guard('admin')->user()->id;
        Attendance::where('id',$id)->update($data);

        if(!empty(request('Emp'))){

            AttendanceEmp::where('Attend',$id)->delete();
            $Emp=request('Emp');
            $In_Time=request('In_Time');
            $NoteEmp=request('NoteEmp');

            for($i=0 ; $i < count($Emp) ; $i++){

                $emp['In_Time']=$In_Time[$i];
                $emp['Date']=request('Date');
                $emp['Month']=request('Month');
                $emp['Note']=$NoteEmp[$i];
                $emp['Attend']=$id;
                $emp['Emp']=$Emp[$i];
                AttendanceEmp::create($emp);
            }
        }

            $dataUser=[
                'screen_ar'=>'الحضور',
                'screen_en'=>'Attendance',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);

            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return redirect('AttendanceSechdule');

        }catch(\Exception $ex){

            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Attendance::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }


//Departure
    public function DeparturePage($id){

        $item=Attendance::find($id);
        $details=AttendanceEmp::where('Attend',$item->id)->get();
        $Code=$this->ReturnCode(Departure::class);

        return view('admin.HR.Departure',get_defined_vars());
    }

    public function AddDeparture($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',



        ],[

        ]);

        $ID = DB::table('departures')->insertGetId(

            array(
                'Date' => request('Date'),
                'Month' => request('Month'),
                'Note' => request('Note'),
                'Attend' => $id,
                'User' =>auth()->guard('admin')->user()->id,
            )
        );


        if(!empty(request('Emp'))){

            $Emp=request('Emp');
            $In_Time=request('In_Time');
            $NoteEmp=request('NoteEmp');
            $Out_Time=request('Out_Time');
            $Hours_Number=request('Hours_Number');



            for($i=0 ; $i < count($Emp) ; $i++){


                $Mwzf=Employess::find($Emp[$i]);

                $Att = new DateTime($Mwzf->Attendence);
                $AttTime = new DateTime($In_Time[$i]);
                $DifTimeAtt = $Att->diff($AttTime);



                $Dep = new DateTime($Mwzf->Departure);
                $DepTime = new DateTime($Out_Time[$i]);
                $DifTimeDep = $DepTime->diff($Dep);

                $x=$DifTimeAtt->format("%h:%i:%s");
                $y=$DifTimeDep->format("%h:%i:%s");



                $tAtt = explode(':', $x);
                $tDep = explode(':', $y);
                $CountMinAtt= ($tAtt[0]*60) + ($tAtt[1]) + ($tAtt[2]/60);
                $CountMinDep= ($tDep[0]*60) + ($tDep[1]) + ($tDep[2]/60);



                $AttValue=AttendencePolicyEmp::where('Emp',$Emp[$i])
                    ->where('From','<=',$CountMinAtt)
                    ->where('To','>=',$CountMinAtt)
                    ->get()
                    ->sum('Discount');

                $DepartValue=DepaarturePolicyEmp::where('Emp',$Emp[$i])
                    ->where('From','<=',$CountMinDep)
                    ->where('To','>=',$CountMinDep)
                    ->get()
                    ->sum('Discount');




                $emp['In_Time']=$In_Time[$i];
                $emp['Date']=request('Date');
                $emp['Month']=request('Month');
                $emp['Note']=$NoteEmp[$i];
                $emp['Out_Time']=$Out_Time[$i];
                $emp['Hours_Number']=$Hours_Number[$i];
                $emp['Departure']=$ID;
                $emp['Emp']=$Emp[$i];

                $emp['Disc_Late']=$AttValue;
                $emp['Disc_Early']=$DepartValue;

                DepartureEmp::create($emp);

            }
        }

        Attendance::where('id',$id)->update(['Status'=>1]);

            $dataUser=[
                'screen_ar'=>'الانصراف',
                'screen_en'=>'Departure',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Added_Successfully'));
        return redirect('DepartureSechdule');

        }catch(\Exception $ex){

            $MODEL=Departure::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Departure::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function DepartureSechdulePage(){
        $items=Departure::orderBy('id','desc')->paginate(100);
        return view('admin.HR.DepartureSechdule',['items'=>$items]);
    }

    public function EditDeparturePage($id){

        $item=Departure::find($id);
        $details=DepartureEmp::where('Departure',$item->id)->get();
        return view('admin.HR.EditDeparture',[
            'item'=>$item,
            'details'=>$details,
        ]);
    }

    public function PostEditDeparture($id){

        try {
            DB::beginTransaction();
        $data= $this->validate(request(),[
            'Code'=>'required',
            'Date'=>'required',
            'Month'=>'required',



        ],[

        ]);

        $data['Code'] = request('Code');
        $data['Date'] = request('Date');
        $data['Month'] = request('Month');
        $data['Note'] = request('Note');
        $data['Attend'] = request('Attend');
        $data['User'] =auth()->guard('admin')->user()->id;

        Departure::where('id',$id)->update($data);

        if(!empty(request('Emp'))){
            DepartureEmp::where('Departure',$id)->delete();
            $Emp=request('Emp');
            $In_Time=request('In_Time');
            $NoteEmp=request('NoteEmp');
            $Out_Time=request('Out_Time');
            $Hours_Number=request('Hours_Number');



            for($i=0 ; $i < count($Emp) ; $i++){

                $Mwzf=Employess::find($Emp[$i]);

                $Att = new DateTime($Mwzf->Attendence);
                $AttTime = new DateTime($In_Time[$i]);
                $DifTimeAtt = $Att->diff($AttTime);



                $Dep = new DateTime($Mwzf->Departure);
                $DepTime = new DateTime($Out_Time[$i]);
                $DifTimeDep = $DepTime->diff($Dep);

                $x=$DifTimeAtt->format("%h:%i:%s");
                $y=$DifTimeDep->format("%h:%i:%s");



                $tAtt = explode(':', $x);
                $tDep = explode(':', $y);
                $CountMinAtt= ($tAtt[0]*60) + ($tAtt[1]) + ($tAtt[2]/60);
                $CountMinDep= ($tDep[0]*60) + ($tDep[1]) + ($tDep[2]/60);



                $AttValue=AttendencePolicyEmp::where('Emp',$Emp[$i])
                    ->where('From','<=',$CountMinAtt)
                    ->where('To','>=',$CountMinAtt)
                    ->get()
                    ->sum('Discount');

                $DepartValue=DepaarturePolicyEmp::where('Emp',$Emp[$i])
                    ->where('From','<=',$CountMinDep)
                    ->where('To','>=',$CountMinDep)
                    ->get()
                    ->sum('Discount');


                $emp['Disc_Late']=$AttValue;
                $emp['Disc_Early']=$DepartValue;
                $emp['In_Time']=$In_Time[$i];
                $emp['Date']=request('Date');
                $emp['Month']=request('Month');
                $emp['Note']=$NoteEmp[$i];
                $emp['Out_Time']=$Out_Time[$i];
                $emp['Hours_Number']=$Hours_Number[$i];
                $emp['Departure']=$id;
                $emp['Emp']=$Emp[$i];
                DepartureEmp::create($emp);

            }
        }


            $dataUser=[
                'screen_ar'=>'الانصراف',
                'screen_en'=>'Departure',
                'explain_ar'=>request('Code'),
                'explain_en'=>request('Code'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return redirect('DepartureSechdule');


    }catch(\Exception $ex){

$MODEL=Departure::class;
DB::rollBack();
Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
return back();

}catch(\Error $ex){


    $MODEL=Departure::class;
    DB::rollBack();
    Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

    session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
    return back();

}

    }


    //EmpCovenant
    public function EmpCovenant(){
        $items=EmpCovenant::all();
        $Emps=Employess::type()->get();
        return view('admin.HR.EmpCovenant',get_defined_vars());
    }

    public function AddEmpCovenant(){

        try {
            DB::beginTransaction();
            $data= $this->validate(request(),[
                'Emp'=>'required',
                'Date'=>'required',
                'Name'=>'required',
                'Price'=>'required',


            ],[

            ]);



            $data['Emp']=request('Emp');
            $data['Date']=request('Date');
            $data['Name']=request('Name');
            $data['Price']=request('Price');
            $data['Reason']=request('Reason');
            $data['Life_Expectancy']=request('Life_Expectancy');
            EmpCovenant::create($data);




            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('Name'),
            ];
            $this->UserCreateMoves($dataUser);
            DB::commit();
            session()->flash('success',trans('admin.Added_Successfully'));
            return back();

        }catch(\Exception $ex){

            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function EditEmpCovenant($id){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
                'Emp'=>'required',
                'Date'=>'required',
                'Name'=>'required',
                'Price'=>'required',


            ],[

            ]);



            $data['Emp']=request('Emp');
            $data['Date']=request('Date');
            $data['Name']=request('Name');
            $data['Price']=request('Price');
            $data['Reason']=request('Reason');
            $data['Life_Expectancy']=request('Life_Expectancy');
            EmpCovenant::where('id',$id)->update($data);




            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>request('Name'),
                'explain_en'=>request('Name'),
            ];
            $this->UserUpdateMoves($dataUser);
            DB::commit();

            session()->flash('success',trans('admin.Updated'));
            return back();

        }catch(\Exception $ex){

            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteEmpCovenant($id){

        try {
            DB::beginTransaction();
            $del=EmpCovenant::find($id);



            $dataUser=[
                'screen_ar'=>'مستويات التوظيف',
                'screen_en'=>'Employment levels',
                'explain_ar'=>$del->Name,
                'explain_en'=>$del->Name,
            ];
            $this->UserDeleteMoves($dataUser);
            $del->delete();
            DB::commit();
            session()->flash('error',trans('admin.Deleted'));
            return back();
        }catch(\Exception $ex){

            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=EmpCovenant::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }



    //Fingerprint
    public function Fingerprint(){



        $setting=ModuleSettingsNum::latest('id')->first();

        return view('admin.HR.Fingerprint',get_defined_vars());
    }

    public function ShutdownFP(){


        try {



        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->shutdown();
                session()->flash('success',trans('admin.Shutdown'));
            }
        }


        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }

    public function RestartFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->restart();
                session()->flash('success',trans('admin.Restart'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function SleepFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->sleep();
                session()->flash('success',trans('admin.Sleep'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function ResumeFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->resume();
                session()->flash('success',trans('admin.Resume'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function ConnectFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->testVoice();
                session()->flash('success',trans('admin.Connect'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function DisconnectFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->disconnect();
                session()->flash('success',trans('admin.Disconnect'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }

   public function ClearAttendenceFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->clearAttendance();
                session()->flash('success',trans('admin.ClearAttendence'));
            }
        }


        return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function AttendenceFP(){

        try {


        $setting=ModuleSettingsNum::latest('id')->first();

        $type='';

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $attendanceData = $zk->getAttendance();
                $currentDate = date('Y-m-d');
                // Filter attendance data for today
                $todaysAttendance = array_filter($attendanceData, function ($record) use ($currentDate) {
                    // Assuming the date format in the attendance data is 'Y-m-d H:i:s'
                    return substr($record['timestamp'], 0, 10) === $currentDate;
                });
            } else {
                $todaysAttendance = '';
            }
        }else{

            $todaysAttendance = '';
        }

        return view('admin.HR.AttendenceFingerprint',get_defined_vars());

        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }

    }

    public function FilterAttendenceFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        $type=request('Type');

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $attendanceData = $zk->getAttendance();
                $currentDate = request('Date');
                // Filter attendance data for today
                $todaysAttendance = array_filter($attendanceData, function ($record) use ($currentDate) {
                    // Assuming the date format in the attendance data is 'Y-m-d H:i:s'
                    return substr($record['timestamp'], 0, 10) === $currentDate;
                });
            } else {
                $todaysAttendance = '';
            }
        }else{

            $todaysAttendance = '';
        }

        return view('admin.HR.AttendenceFingerprint',get_defined_vars());
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }


    public function UsersFPFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();


        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $Users=$zk->getUser();

            } else {
                $Users = '';
            }
        }else{

            $Users = '';
        }

        return view('admin.HR.UsersFingerprint',get_defined_vars());
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }

    public function DeleteUserFP($id){


        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $zk->removeUser($id);
                session()->flash('success',trans('admin.Deleted'));
            }
        }


            return back();
        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }

    }


    public function RegisterAttendanceFP(){

        try{
        $setting=ModuleSettingsNum::latest('id')->first();

        if($setting->Fingerprint == 1) {
            $zk = new ZKTeco($setting->Fingerprint_IP);
            if (!empty($zk)) {
                $zk->connect();
                $attendanceData = $zk->getAttendance();

                    $currentDate = date('Y-m-d');
                    $currentDateMonth = date('Y-m');


                    $IfAttendDate=Attendance::where('Date',$currentDate)->count();
                    $IfDepDate=Departure::where('Date',$currentDate)->count();


                    if($IfAttendDate == 0) {
                        //Attendence
                        $AttendID = DB::table('attendances')->insertGetId(

                            array(
                                'Date' => $currentDate,
                                'Month' => $currentDateMonth,
                                'Note' => null,
                                'Status' => 1,
                                'User' => auth()->guard('admin')->user()->id,
                            )
                        );
                    }else{
                        $AttendDate=Attendance::where('Date',$currentDate)->first();

                        $AttendID=$AttendDate->id;
                    }


                    if($IfDepDate == 0) {
                        //Departure
                        $DepID = DB::table('departures')->insertGetId(

                            array(
                                'Date' => $currentDate,
                                'Month' => $currentDateMonth,
                                'Note' => null,
                                'Attend' => $AttendID,
                                'User' => auth()->guard('admin')->user()->id,
                            )
                        );
                    }else{
                        $DepDate=Departure::where('Date',$currentDate)->first();
                        $DepID=$DepDate->id;
                    }

                        $todaysAttendance = array_filter($attendanceData, function ($record) use ($currentDate, $AttendID, $DepID) {

                            $dateTimeString = $record['timestamp'];
                            $dateTimeObject = new DateTime($dateTimeString);
                            $datePart = $dateTimeObject->format('Y-m-d');
                            $datePartMonth = $dateTimeObject->format('Y-m');
                            $timePart = $dateTimeObject->format('H:i');

                            if ($currentDate == $datePart) {

                                $Mwzf = Employess::find($record['id']);

                                if(!empty($Mwzf)){


                                //Attendence

                                if ($record['type'] == 0) {

                                    $EMPIn = AttendanceEmp::where('Date', $datePart)->where('Emp', $record['id'])->count();

                                        if($EMPIn == 0) {
                                            $emp['In_Time'] = $timePart;
                                            $emp['Date'] = $datePart;
                                            $emp['Month'] = $datePartMonth;
                                            $emp['Note'] = null;
                                            $emp['Attend'] = $AttendID;
                                            $emp['Emp'] = $record['id'];
                                            AttendanceEmp::create($emp);
                                        }
                                }


                                //Departure
                                if ($record['type'] == 1) {

                                    $EMPOut = DepartureEmp::where('Date', $datePart)->where('Emp', $record['id'])->count();

                                    if($EMPOut == 0) {

                                    $INTIME = AttendanceEmp::where('Date', $datePart)->where('Emp', $record['id'])->first();


                                    $Att = new DateTime($Mwzf->Attendence);


                                    $AttTime = new DateTime($INTIME->In_Time);
                                    $DifTimeAtt = $Att->diff($AttTime);


                                    $Dep = new DateTime($Mwzf->Departure);
                                    $DepTime = new DateTime($timePart);
                                    $DifTimeDep = $DepTime->diff($Dep);

                                    $x = $DifTimeAtt->format("%h:%i:%s");
                                    $y = $DifTimeDep->format("%h:%i:%s");


                                    $tAtt = explode(':', $x);
                                    $tDep = explode(':', $y);
                                    $CountMinAtt = ($tAtt[0] * 60) + ($tAtt[1]) + ($tAtt[2] / 60);
                                    $CountMinDep = ($tDep[0] * 60) + ($tDep[1]) + ($tDep[2] / 60);


                                    $AttValue = AttendencePolicyEmp::where('Emp', $record['id'])
                                        ->where('From', '<=', $CountMinAtt)
                                        ->where('To', '>=', $CountMinAtt)
                                        ->get()
                                        ->sum('Discount');

                                    $DepartValue = DepaarturePolicyEmp::where('Emp', $record['id'])
                                        ->where('From', '<=', $CountMinDep)
                                        ->where('To', '>=', $CountMinDep)
                                        ->get()
                                        ->sum('Discount');


                                    $timeIn1 = $INTIME->In_Time;
                                    $timeOut1 = $timePart;
                                        $dummyDate = '2000-01-01';

                                            $checkIn = new DateTime($dummyDate . ' ' . $timeIn1);
                                            $checkOut = new DateTime($dummyDate . ' ' . $timeOut1);

                                            if ($checkOut < $checkIn) {
                                                $checkOut->modify('+1 day');
                                            }

                                            $interval = $checkOut->diff($checkIn);
                                            $hours = $interval->h;
                                            $minutes = $interval->i;
                                            $totalHours = $hours + ($minutes / 60);


                                    $emp['In_Time'] = $INTIME->In_Time;
                                    $emp['Date'] = $datePart;
                                    $emp['Month'] = $datePartMonth;
                                    $emp['Note'] = null;
                                    $emp['Out_Time'] = $timePart;
                                    $emp['Hours_Number'] = number_format($totalHours,2);
                                    $emp['Departure'] = $DepID;
                                    $emp['Emp'] = $record['id'];

                                    $emp['Disc_Late'] = $AttValue;
                                    $emp['Disc_Early'] = $DepartValue;

                                    DepartureEmp::create($emp);


                                }
                                }

                                }


                            }


                        });



            }
        }


        return back();

        }catch(\Exception $ex){


            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }catch(\Error $ex){

            DB::rollBack();
            session()->flash('error',trans('admin.Disconnect'));
            return back();

        }
    }



}
