<?php

namespace App\Http\Controllers;

use App\Models\Products;
use App\Models\ProductSales;
use App\Models\SalesOrder;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\UsersMoves;
use App\Models\CompanyData;
use App\Models\ItemsGroups;
use App\Models\Stores;
use App\Models\Employess;
use App\Models\Vendors;
use App\Models\ShippingCompany;
use App\Models\Customers;
use App\Models\AcccountingManual;
use App\Models\ProductUnits;
use App\Models\Brands;
use App\Models\ModuleSettingsNum;
use App\Mail\AdminResetPassword;
use App\Mail\CliendSendMail;
use Carbon\Carbon;
use Spatie\Permission\Models\Role;
use App\Models\ProductsQty;
use App\Models\Sales;
use App\Models\GeneralDaily;
use App\Models\ReturnSales;
use App\Models\IncomChecks;
use App\Models\Purchases;
use App\Models\InsurancePaper;
use App\Models\ReturnPurch;
use App\Models\ExportChecks;
use App\Models\Packages;
use App\Models\Event;
use App\Models\CustomersGroup;
use Artisan;
use Calendar;
use File;
use Mail;
use Auth;
use URL;
use SpamProtector;
use Storage;
use DB ;
use Str ;
use Spatie\Permission\Models\Permission;


class AdminController extends Controller
{

    function __construct()
    {

        $this->middleware('permission:المستخدمين', ['only' => ['AdminsPage','AddAdmin','EditAdmin','DeleteAdmin']]);
        $this->middleware('permission:قائمة الزوار', ['only' => ['GusetListPrice']]);
        $this->middleware('permission:الاحصائيات', ['only' => ['StatisticsTotal','StatisticsGraph']]);
        $this->middleware('permission:جدول المواعيد', ['only' => ['CalendarMeet']]);



    }


    //Welcome Page   ===========================================================

    public function Welcome(Request $request){

        return view('welcome');

    }



    //Auth   ===========================================================

    public function LoginPage(Request $request){

        return view('admin.Login');

    }

    public function Login(){

        $data= $this->validate(request(),[
            'email'=>'required|email',
            'password'=>'required|min:6|max:50',
        ],[
        ]);

        $rememberme = request('rememberme') == 1?true:false;

        if(auth()->guard('admin')->attempt(['email'=>request('email'),'password'=>request('password')],$rememberme)){


            if(auth()->guard('admin')->user()->expire_type == 1) {

                if (auth()->guard('admin')->user()->expire < date('Y-m-d')){

                            session()->flash('error', trans('admin.Expired_Subscribe'));
                           auth()->guard('admin')->logout();
                              return redirect('AdminLogin');


              }

              }

            $data['User']=auth()->guard('admin')->user()->id;
            $data['Date']=date('Y-m-d');
            $data['Time']=date("h:i:s a", time());
            $data['Screen']='تسجيل الدخول';
            $data['ScreenEn']='Login';
            $data['Type']='تسجيل الدخول';
            $data['TypeEn']='Login';
            $data['Explain']='تسجيل الدخول';
            $data['ExplainEn']='Login';

            UsersMoves::create($data);

            return redirect('KlarAdmin');

        }else{
            session()->flash('error',trans('admin.incorrect_information_login'));
            return redirect('AdminLogin');
        }



    }

    public function Logout(){
        auth()->guard('admin')->logout();
        return redirect('AdminLogin');
    }

    public function forgotpasswordPage(){
        return view('admin.forgotpassword');

    }

    public function forgotpassword(){

        try {
            DB::beginTransaction();

            if(SpamProtector::isSpamEmail(request('email')))
        {
            return back();
        }


        $data= $this->validate(request(),[
            'email'=>'required|email',
        ],[
        ]);

        $admin = Admin::where('email',request('email'))->first();
        if(!empty($admin)){

            $token = app('auth.password.broker')->createToken($admin);
            $data = DB::table('password_resets')->insert([
                'email'  => $admin->email,
                'token'  => $token,
                'created_at'  => Carbon::now(),

            ]);

            Mail::to($admin->email)->send(new AdminResetPassword(['data'=>$admin,'token'=>$token]));
            DB::commit();
            session()->flash('success',trans('admin.Reset_Password'));
            return back();

        }else{

            DB::rollBack();
            session()->flash('success',trans('admin.WrongEmail'));
            return back();

        }



        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function reset_password($token){


        $check_token = DB::table('password_resets')->where('token',$token)->where('created_at','>',Carbon::now()->subHours(2) ) ->first();

        if(!empty($check_token)){
            return view('admin.reset_password',['data'=>$check_token]);

        }else{

            return redirect('AdminLogin');
        }
    }

    public function reset_password_final($token){

        $this->validate(request(),[
            'password' => 'required|confirmed',
            'password_confirmation' => 'required',
        ],[
            'password.required' => trans('admin.passwordRequired'),
            'password_confirmation.required' => trans('admin.password_confirmationRequired'),

        ]);
        $check_token = DB::table('password_resets')->where('token',$token)->where('created_at','>',Carbon::now()->subHours(2) ) ->first();
        if(!empty($check_token)){
            $admin = Admin::where('email', $check_token->email)->update([
                'email' => $check_token->email,
                'password' =>bcrypt(request('password'))

            ]);
            DB::table('password_resets')->where('email',request('email'))->delete();
            auth()->guard('admin')->attempt(['email'=>$check_token->email,'password'=>request('password')],true);
            return redirect('KlarAdmin');

        }else{

            return redirect('AdminLogin');
        }

    }



    //Admin  ===========================================================

    public function AdminsPage(){
        $items=Admin::type()->get();
        $Stores=Stores::all();
        $Packages=Packages::all();
        $Safes = AcccountingManual::where('Type',1)->safetype()->get();

        if(auth()->guard('admin')->user()->email != 'Klar@test.com'){

            if(app()->getLocale() == 'ar' ){
                $roles = Role::where('name','!=','Owner')->pluck('name','name');
            }else{

                $roles = Role::where('name','!=','Owner')->pluck('nameEn','name');
            }
        }else{

            if(app()->getLocale() == 'ar' ){
                $roles = Role::pluck('name','name')->all();
            }else{

                $roles = Role::pluck('nameEn','name')->all();
            }

        }


        return view('admin.Admins',get_defined_vars());
    }

    public function AddAdmin(){

        try {
            DB::beginTransaction();

        $Module=ModuleSettingsNum::orderBy('id','desc')->first();
        if($Module->Users_Select == 1){

            $count=Admin::where('hidden',0)->count();

            if($Module->Users_Num <= $count){

                session()->flash('error',trans('admin.Alert_Maximum_Add'));
                return back();
            }


        }

        $data= $this->validate(request(),[
            'name'=>'required',
            'email'=>'required|email|unique:admins',
            'password'=>'required|min:6',
            'roles_name' => 'required',
            'image'=>'image|mimes:jpeg,png,jpg|max:2048',
        ],[
            'name.required' => trans('admin.nameRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),
            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),

        ]);

        $image=request()->file('image');
        if($image){
            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }


        if(!empty($image_url)){

            $data['image']=$image_url;

        }else{
            $data['image']=null;
        }

        if(request('Type') == 'Admin'){
            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $data['account']=0;

        }elseif(request('Type') == 'Emp'){


            $data= $this->validate(request(),[
                'emp'=>'required',
            ]);



            $data['emp']=request('emp');
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $cust=Employess::find(request('emp'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Ship'){


            $data= $this->validate(request(),[
                'ship'=>'required',
            ]);



            $data['emp']=0;
            $data['ship']=request('ship');
            $data['vend']=0;
            $data['cli']=0;

            $cust=ShippingCompany::find(request('ship'));
            $data['account']=$cust->Account;

        }elseif(request('Type') == 'Vend'){

            $data= $this->validate(request(),[
                'vend'=>'required',
            ]);



            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=request('vend');
            $data['cli']=0;

            $cust=Vendors::find(request('vend'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Client'){


            $data= $this->validate(request(),[
                'cli'=>'required',
            ]);


            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=request('cli');

            $cust=Customers::find(request('cli'));
            $data['account']=$cust->Account;

        }


        $data['name']=request('name');


        if(!empty(request('nameEn'))){
            $data['nameEn']=request('nameEn');
        }else{
            $data['nameEn']=request('name');
        }
        $data['email']=request('email');
        $data['phone']=request('phone');
        $data['password']=bcrypt(request('password'));
        $data['hidden']=0;
        $data['status']=0;
        $data['safe']=request('safe');
        $data['store']=request('store');
        $data['type']=request('Type');
        $data['roles_name']=request('roles_name');
        $data['price_sale']=request('price_sale');
        $data['discount']=request('discount');
        $data['price_1']=request('price_1');
        $data['price_2']=request('price_2');
        $data['price_3']=request('price_3');
        $data['pos_pay']=request('pos_pay');
        $data['executor']=request('executor');
        $data['cost_price']=request('cost_price');
        $data['pos_stores']=request('pos_stores');
        $data['pos_hold']=request('pos_hold');
        $data['cost_price_purch']=request('cost_price_purch');
        $data['cost_price_sales']=request('cost_price_sales');
        $data['manu_order_precent']=request('manu_order_precent');
        $data['pos_product']=request('pos_product');
        $data['Cash']=request('Cash');
        $data['Later']=request('Later');
        $data['Check']=request('Check');
        $data['Installment']=request('Installment');
        $data['Cash_Visa']=request('Cash_Visa');
        $data['Cash_Collection']=request('Cash_Collection');
        $data['Delivery']=request('Delivery');
        $data['Date']=request('Date');
        $data['ticket_price']=request('ticket_price');
        $data['ticket_discount']=request('ticket_discount');
        $data['InstallmentCompanies']=request('InstallmentCompanies');
        $data['package']=request('package');
        $data['job_order_price']=request('job_order_price');
        $data['Visa_Network']=request('Visa_Network');
        $data['bill_discount']=request('bill_discount');
        $data['pos_safes']=request('pos_safes');
        $data['expire']=request('expire');
        $data['expire_type']=request('expire_type');
        Admin::create($data);

        $user=Admin::orderBy('id','desc')->first();

        $user->assignRole(request('roles_name'));

            DB::commit();
        session()->flash('success',trans('admin.NewAddAdmin'));
        return redirect('Admins');


        }catch(\Exception $ex){

            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function EditAdmin($id , Request $request){

        try {
            DB::beginTransaction();

        $data= $this->validate(request(),[
            'name'=>'required',
            'email'=>'required|email|unique:admins,email,'.$id,
            'password'=>'sometimes|nullable|min:6',
            'image'=>'sometimes|nullable|image|mimes:jpeg,png,jpg|max:2048',

            'roles_name' => 'required',
        ],[
            'name.required' => trans('admin.nameRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),
            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),


        ]);

        $image=request()->file('image');

        if($image){

            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(empty($image_url)){$data['image']=request('images') ; }else{$data['image']=$image_url;}

        if(request('Type') == 'Admin'){
            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $data['account']=0;

        }elseif(request('Type') == 'Emp'){

            $data= $this->validate(request(),[
                'emp'=>'required',
            ]);

            $data['emp']=request('emp');
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $cust=Employess::find(request('emp'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Ship'){


            $data= $this->validate(request(),[
                'ship'=>'required',
            ]);


            $data['emp']=0;
            $data['ship']=request('ship');
            $data['vend']=0;
            $data['cli']=0;

            $cust=ShippingCompany::find(request('ship'));
            $data['account']=$cust->Account;

        }elseif(request('Type') == 'Vend'){

            $data= $this->validate(request(),[
                'vend'=>'required',
            ]);

            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=request('vend');
            $data['cli']=0;

            $cust=Vendors::find(request('vend'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Client'){


            $data= $this->validate(request(),[
                'cli'=>'required',
            ]);

            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=request('cli');

            $cust=Customers::find(request('cli'));
            $data['account']=$cust->Account;

        }

            if(request()->has('password')){


                $data['password']  =bcrypt(request('password'));

            }

            if(empty (request('password'))){

                $data['password']  = request('passwords');

            }



        $data['nameEn']=request('nameEn');
        $data['email']=request('email');
        $data['phone']=request('phone');
        $data['hidden']=request('hidden');
        $data['status']=request('status');
        $data['safe']=request('safe');
        $data['store']=request('store');
        $data['type']=request('Type');
        $data['price_sale']=request('price_sale');
        $data['discount']=request('discount');
        $data['price_1']=request('price_1');
        $data['price_2']=request('price_2');
        $data['price_3']=request('price_3');
        $data['pos_pay']=request('pos_pay');
        $data['executor']=request('executor');
        $data['cost_price']=request('cost_price');
        $data['pos_stores']=request('pos_stores');
        $data['pos_hold']=request('pos_hold');
        $data['roles_name']=request('roles_name');
        $data['cost_price_purch']=request('cost_price_purch');
        $data['cost_price_sales']=request('cost_price_sales');
        $data['manu_order_precent']=request('manu_order_precent');
        $data['pos_product']=request('pos_product');
        $data['Cash']=request('Cash');
        $data['Later']=request('Later');
        $data['Check']=request('Check');
        $data['Installment']=request('Installment');
        $data['Cash_Visa']=request('Cash_Visa');
        $data['Cash_Collection']=request('Cash_Collection');
        $data['Delivery']=request('Delivery');
        $data['Date']=request('Date');
        $data['ticket_price']=request('ticket_price');
        $data['ticket_discount']=request('ticket_discount');
        $data['InstallmentCompanies']=request('InstallmentCompanies');
        $data['package']=request('package');
        $data['job_order_price']=request('job_order_price');
        $data['Visa_Network']=request('Visa_Network');
        $data['bill_discount']=request('bill_discount');
        $data['pos_safes']=request('pos_safes');
            $data['expire']=request('expire');
            $data['expire_type']=request('expire_type');
        Admin::where('id',$id)->update($data);


        $user=Admin::find($id);



        $user->removeRole(request('roles'));
        $user->assignRole(request('roles_name'));

            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }


    }

    public function DeleteAdmin($id){

        try {
            DB::beginTransaction();
        $del=Admin::find($id);
        $del->delete();
            DB::commit();
        session()->flash('error',trans('admin.Deleted'));
        return redirect('Admins');

        }catch(\Exception $ex){

            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function Profile(){
        $item=Admin::find(auth()->guard('admin')->user()->id);
        return view('admin.Profile',['item'=> $item]);

    }

    public function UpdateAdminProfile($id){

        try {
            DB::beginTransaction();

            $data= $this->validate(request(),[
            'name'=>'required',
            'email'=>'required|email|unique:admins,email,'.$id,
            'password'=>'sometimes|nullable|min:6',
            'image'=>'sometimes|nullable|image|mimes:jpeg,png,jpg|max:2048',

        ],[
            'name.required' => trans('admin.nameRequired'),
            'email.required' => trans('admin.emailRequired'),
            'email.email' =>trans('admin.emailEmail'),
            'email.unique' =>trans('admin.emailUnique'),
            'password.required' =>trans('admin.passwordRequired'),
            'password.min' => trans('admin.passwordmin_6'),


        ]);

        $image=request()->file('image');

        if($image){

            $image_name=Str::random(20);
            $ext=strtolower($image->getClientOriginalExtension());
            $image_full_name=$image_name .'.' . $ext ;
            $upload_path='AdminsImages/';
            $image_url=$upload_path.$image_full_name;
            $success=$image->move($upload_path,$image_full_name);
        }

        if(empty($image_url)){$data['image']=request('images') ; }else{$data['image']=$image_url;}

        if(request()->has('password')){

            $data['password']  =bcrypt(request('password'));

        }

        if(empty (request('password'))){

            $data['password']  = request('passwords');

        }



        if(request('Type') == 'Admin'){
            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $data['account']=0;

        }elseif(request('Type') == 'Emp'){

            $data['emp']=request('emp');
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=0;
            $cust=Employess::find(request('emp'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Ship'){

            $data['emp']=0;
            $data['ship']=request('ship');
            $data['vend']=0;
            $data['cli']=0;

            $cust=ShippingCompany::find(request('ship'));
            $data['account']=$cust->Account;

        }elseif(request('Type') == 'Vend'){

            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=request('vend');
            $data['cli']=0;

            $cust=Vendors::find(request('vend'));
            $data['account']=$cust->Account;


        }elseif(request('Type') == 'Client'){

            $data['emp']=0;
            $data['ship']=0;
            $data['vend']=0;
            $data['cli']=request('cli');

            $cust=Customers::find(request('cli'));
            $data['account']=$cust->Account;

        }

        $data['nameEn']=request('nameEn');
        $data['phone']=request('phone');
        $data['hidden']=request('hidden');
        $data['status']=request('status');
        $data['safe']=request('safe');
        $data['store']=request('store');
        $data['type']=request('Type');
        $data['roles_name']=request('roles_name');
        Admin::where('id',$id)->update($data);


        $user=Admin::find($id);
            DB::commit();

        session()->flash('success',trans('admin.Updated'));
        return back();

        }catch(\Exception $ex){

            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=Admin::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }

    }

    public function UnHide($id){

        Admin::where('id',$id)->update(['hidden'=>1]);
        session()->flash('success',trans('admin.Updated'));
        return redirect('Admins');

    }

    public function Hide($id){

        Admin::where('id',$id)->update(['hidden'=>0]);
        session()->flash('success',trans('admin.Updated'));
        return redirect('Admins');

    }


    //   =======  GusetListPrice   ===========================================================

    public function GusetListPrice(){
        $Products=ProductUnits::distinct(['P_Ar_Name'])->get();
        $Groups=ItemsGroups::whereIn('Store_Show',[2,3])->get();
        $Brands=Brands::whereIn('Store_Show',[2,3])->get();
        $company=CompanyData::orderBy('id','desc')->first();
        return view('admin.GusetListPrice',get_defined_vars());
    }

    function PriceListFilter(Request $request)

    {

        if($request->ajax())
        {
            $output = '';
            $brand = $request->get('Brand');
            $group = $request->get('Group');
            $HP = $request->get('HP');
            $LP = $request->get('LP');
            $Search = $request->get('Search');

            if($brand != '' or $group != '' or $HP != '' or $LP != '' or $Search != '')
            {

                if($Search != ''){

                    if($HP != '' and $LP != ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [$LP, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP != '' and $LP == ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [0, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP != ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [0,$LP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP == ''){

                        $Prods=ProductUnits::where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }



                }else{

                    if($HP != '' and $LP != ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [$LP, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP != '' and $LP == ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [0, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP != ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [0,$LP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP == ''){

                        $Prods=ProductUnits::  distinct(['P_Ar_Name'])    ->get();
                    }


                }

            }

            $total_row = $Prods->count();
            if($total_row > 0)
            {

                foreach($Prods as $pro){
                    if($pro->Product()->first()->Store_Show == 2 or $pro->Product()->first()->Store_Show == 3){
                        if($brand != '' and $group != '')
                        {
                            if($pro->Product()->first()->Group == $group){

                                if($pro->Product()->first()->Brand == $brand){

                                    if(!empty($pro->Product()->first()->Image)){
                                        $img='<img src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                    }else{
                                        $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                    }

                                    if(auth()->guard('admin')->user()->price_level == 1){
                                        $price=$pro->Price;
                                    }elseif(auth()->guard('admin')->user()->price_level == 2){
                                        $price=$pro->Price_Two;
                                    }elseif(auth()->guard('admin')->user()->price_level == 3){
                                        $price= $pro->Price_Three;
                                    }

                                    if(!empty($pro->Product()->first()->Ar_Desc)){

                                        if(app()->getLocale() == 'ar' ){
                                            $Desc=$pro->Product()->first()->Ar_Desc;
                                        }else{

                                            $Desc=$pro->Product()->first()->En_Desc;
                                        }

                                    }else{
                                        $Desc='';
                                    }
                                    if(auth()->guard('admin')->user()->email  != 'GuestH@test.com'){
                                        $priceX='<p>'.trans('admin.Price').': <span>'.$price.'</span></p>';
                                    }else{
                                        $priceX='';
                                    }



                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$pro->P_Ar_Name;
                                        $UnitName=$pro->Unit()->first()->Name;


                                    }else{
                                        $PrrroName=$pro->P_En_Name;
                                        $UnitName=$pro->Unit()->first()->NameEn;


                                    }


                                    $output .='

                          <div class="col-md-2">
                    <div class="product">
                    <div class="row">
                        <div class="col-md-6 col-6">
                      '.$img.'
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                            <h5>'.$PrrroName.' </h5>
                            <h6>'.$UnitName.'</h6>
                        '.$priceX.'
                            <p> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                    </div>
            </div>
                </div>

    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';



                                }
                            }

                        }elseif($brand != '' and $group == ''){


                            if($pro->Product()->first()->Brand == $brand){

                                if(!empty($pro->Product()->first()->Image)){
                                    $img='<img src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                }else{
                                    $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                }

                                if(auth()->guard('admin')->user()->price_level == 1){
                                    $price=$pro->Price;
                                }elseif(auth()->guard('admin')->user()->price_level == 2){
                                    $price=$pro->Price_Two;
                                }elseif(auth()->guard('admin')->user()->price_level == 3){
                                    $price= $pro->Price_Three;
                                }

                                if(!empty($pro->Product()->first()->Ar_Desc)){

                                    if(app()->getLocale() == 'ar' ){
                                        $Desc=$pro->Product()->first()->Ar_Desc;
                                    }else{

                                        $Desc=$pro->Product()->first()->En_Desc;
                                    }

                                }else{
                                    $Desc='';
                                }
                                if(auth()->guard('admin')->user()->email  != 'GuestH@test.com'){
                                    $priceX='<p>'.trans('admin.Price').': <span>'.$price.'</span></p>';
                                }else{
                                    $priceX='';
                                }



                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$pro->P_Ar_Name;
                                    $UnitName=$pro->Unit()->first()->Name;


                                }else{
                                    $PrrroName=$pro->P_En_Name;
                                    $UnitName=$pro->Unit()->first()->NameEn;


                                }


                                $output .='

                          <div class="col-md-2">
                    <div class="product">
                    <div class="row">
                        <div class="col-md-6 col-6">
                      '.$img.'
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                            <h5>'.$PrrroName.' </h5>
                            <h6>'.$UnitName.'</h6>
                        '.$priceX.'
                            <p> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                    </div>
            </div>
                </div>

    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';



                            }


                        }elseif($brand == '' and $group != ''){

                            if($pro->Product()->first()->Group == $group){
                                if(!empty($pro->Product()->first()->Image)){
                                    $img='<img src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                }else{
                                    $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                }

                                if(auth()->guard('admin')->user()->price_level == 1){
                                    $price=$pro->Price;
                                }elseif(auth()->guard('admin')->user()->price_level == 2){
                                    $price=$pro->Price_Two;
                                }elseif(auth()->guard('admin')->user()->price_level == 3){
                                    $price= $pro->Price_Three;
                                }

                                if(!empty($pro->Product()->first()->Ar_Desc)){

                                    if(app()->getLocale() == 'ar' ){
                                        $Desc=$pro->Product()->first()->Ar_Desc;
                                    }else{

                                        $Desc=$pro->Product()->first()->En_Desc;
                                    }

                                }else{
                                    $Desc='';
                                }
                                if(auth()->guard('admin')->user()->email  != 'GuestH@test.com'){
                                    $priceX='<p>'.trans('admin.Price').': <span>'.$price.'</span></p>';
                                }else{
                                    $priceX='';
                                }



                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$pro->P_Ar_Name;
                                    $UnitName=$pro->Unit()->first()->Name;


                                }else{
                                    $PrrroName=$pro->P_En_Name;
                                    $UnitName=$pro->Unit()->first()->NameEn;


                                }


                                $output .='

                          <div class="col-md-2">
                    <div class="product">
                    <div class="row">
                        <div class="col-md-6 col-6">
                      '.$img.'
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                            <h5>'.$PrrroName.' </h5>
                            <h6>'.$UnitName.'</h6>
                        '.$priceX.'
                            <p> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                    </div>
            </div>
                </div>

    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';




                            }

                        }elseif($brand == '' and $group == ''){


                            if(!empty($pro->Product()->first()->Image)){
                                $img='<img src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                            }else{
                                $img='<img src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                            }

                            if(auth()->guard('admin')->user()->price_level == 1){
                                $price=$pro->Price;
                            }elseif(auth()->guard('admin')->user()->price_level == 2){
                                $price=$pro->Price_Two;
                            }elseif(auth()->guard('admin')->user()->price_level == 3){
                                $price= $pro->Price_Three;
                            }

                            if(!empty($pro->Product()->first()->Ar_Desc)){

                                if(app()->getLocale() == 'ar' ){
                                    $Desc=$pro->Product()->first()->Ar_Desc;
                                }else{

                                    $Desc=$pro->Product()->first()->En_Desc;
                                }

                            }else{
                                $Desc='';
                            }
                            if(auth()->guard('admin')->user()->email  != 'GuestH@test.com'){
                                $priceX='<p>'.trans('admin.Price').': <span>'.$price.'</span></p>';
                            }else{
                                $priceX='';
                            }



                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$pro->P_Ar_Name;
                                $UnitName=$pro->Unit()->first()->Name;


                            }else{
                                $PrrroName=$pro->P_En_Name;
                                $UnitName=$pro->Unit()->first()->NameEn;


                            }


                            $output .='

                          <div class="col-md-2">
                    <div class="product">
                    <div class="row">
                        <div class="col-md-6 col-6">
                      '.$img.'
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                            <h5>'.$PrrroName.' </h5>
                            <h6>'.$UnitName.'</h6>
                        '.$priceX.'
                            <p> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                    </div>
            </div>
                </div>

    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';




                        }

                    }


                }

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }

    public function GUESTLIST(){
        $Products=ProductUnits::distinct(['P_Ar_Name'])->get();
        $Groups=ItemsGroups::whereIn('Store_Show',[2,3])->get();
        $Brands=Brands::whereIn('Store_Show',[2,3])->get();
        $company=CompanyData::orderBy('id','desc')->first();
        return view('GUESTLIST',get_defined_vars());
    }

    function GUESTLISTFilter(Request $request)
    {


        if($request->ajax())
        {
            $output = '';
            $brand = $request->get('Brand');
            $group = $request->get('Group');
            $HP = $request->get('HP');
            $LP = $request->get('LP');
            $Search = $request->get('Search');
            if($brand != '' or $group != '' or $HP != '' or $LP != '' or $Search != '')
            {
                if($Search != ''){

                    if($HP != '' and $LP != ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [$LP, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP != '' and $LP == ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [0, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP != ''){
                        $Prods=ProductUnits::
                        where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->whereBetween('Price', [0,$LP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP == ''){

                        $Prods=ProductUnits::where('P_Ar_Name','ILIKE', "%{$Search}%")
                            ->orWhere('P_En_Name','ILIKE', "%{$Search}%")
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }



                }else{

                    if($HP != '' and $LP != ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [$LP, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP != '' and $LP == ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [0, $HP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP != ''){
                        $Prods=ProductUnits::
                        whereBetween('Price', [0,$LP])
                            ->distinct(['P_Ar_Name'])
                            ->get();
                    }elseif($HP == '' and $LP == ''){

                        $Prods=ProductUnits:: distinct(['P_Ar_Name'])    ->get();
                    }


                }
            }

            $total_row = $Prods->count();
            if($total_row > 0)
            {

                foreach($Prods as $pro){
                    if($pro->Product()->first()->Store_Show == 2 or $pro->Product()->first()->Store_Show == 3){
                        if($brand != '' and $group != '')
                        {
                            if($pro->Product()->first()->Group == $group){

                                if($pro->Product()->first()->Brand == $brand){

                                    if(!empty($pro->Product()->first()->Image)){
                                        $img='<img onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                    }else{
                                        $img='<img  onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                    }


                                    $price=$pro->Price;


                                    if(!empty($pro->Product()->first()->Ar_Desc)){

                                        if(app()->getLocale() == 'ar' ){
                                            $Desc=$pro->Product()->first()->Ar_Desc;
                                        }else{

                                            $Desc=$pro->Product()->first()->En_Desc;
                                        }


                                    }else{
                                        $Desc='';
                                    }




                                    $priceX=$price;


                                    if(app()->getLocale() == 'ar' ){
                                        $PrrroName=$pro->P_Ar_Name;
                                        $UniiName=$pro->Unit()->first()->Name;


                                    }else{
                                        $PrrroName=$pro->P_En_Name;
                                        $UniiName=$pro->Unit()->first()->NameEn;


                                    }
                                    $output .='

                  <div class="col-md-2">
                  <div class="product">
                     <div class="row">
                        <div class="col-md-6 col-6 text-center">
                            '.$img.'
                          <!-- The Modal -->
<div id="myModal'.$pro->id.'" class="modal-img">
  <span class="close-img" id="close'.$pro->id.'">&times;</span>
  <img class="modal-content" id="img'.$pro->id.'">
  <div id="caption'.$pro->id.'"></div>
</div>
       <h6 style="color:#82b0ee;text-align: center;font-size:140%;margin: 5px 0 0 0;">'.$UniiName.' </h6>
                           <p style="color:blue; text-align: center;font-size:140%;"> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                           <h5>'.$PrrroName.' </h5>
                           <br>
                           <p class="price">'.trans('admin.Price').': <span>'.$priceX.'</span></p>

                        </div>
                     </div>
                  </div>
               </div>


    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';



                                }
                            }

                        }elseif($brand != '' and $group == ''){


                            if($pro->Product()->first()->Brand == $brand){


                                if(!empty($pro->Product()->first()->Image)){
                                    $img='<img onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                }else{
                                    $img='<img  onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                }


                                $price=$pro->Price;


                                if(!empty($pro->Product()->first()->Ar_Desc)){

                                    if(app()->getLocale() == 'ar' ){
                                        $Desc=$pro->Product()->first()->Ar_Desc;
                                    }else{

                                        $Desc=$pro->Product()->first()->En_Desc;
                                    }


                                }else{
                                    $Desc='';
                                }




                                $priceX=$price;


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$pro->P_Ar_Name;
                                    $UniiName=$pro->Unit()->first()->Name;


                                }else{
                                    $PrrroName=$pro->P_En_Name;
                                    $UniiName=$pro->Unit()->first()->NameEn;


                                }
                                $output .='

                  <div class="col-md-2">
                  <div class="product">
                     <div class="row">
                        <div class="col-md-6 col-6 text-center">
                            '.$img.'
                          <!-- The Modal -->
<div id="myModal'.$pro->id.'" class="modal-img">
  <span class="close-img" id="close'.$pro->id.'">&times;</span>
  <img class="modal-content" id="img'.$pro->id.'">
  <div id="caption'.$pro->id.'"></div>
</div>
       <h6 style="color:#82b0ee;text-align: center;font-size:140%;margin: 5px 0 0 0;">'.$UniiName.' </h6>
                           <p style="color:blue; text-align: center;font-size:140%;"> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                           <h5>'.$PrrroName.' </h5>
                           <br>
                           <p class="price">'.trans('admin.Price').': <span>'.$priceX.'</span></p>

                        </div>
                     </div>
                  </div>
               </div>


    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';




                            }


                        }elseif($brand == '' and $group != ''){

                            if($pro->Product()->first()->Group == $group){

                                if(!empty($pro->Product()->first()->Image)){
                                    $img='<img onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                                }else{
                                    $img='<img  onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                                }


                                $price=$pro->Price;


                                if(!empty($pro->Product()->first()->Ar_Desc)){

                                    if(app()->getLocale() == 'ar' ){
                                        $Desc=$pro->Product()->first()->Ar_Desc;
                                    }else{

                                        $Desc=$pro->Product()->first()->En_Desc;
                                    }


                                }else{
                                    $Desc='';
                                }




                                $priceX=$price;


                                if(app()->getLocale() == 'ar' ){
                                    $PrrroName=$pro->P_Ar_Name;
                                    $UniiName=$pro->Unit()->first()->Name;


                                }else{
                                    $PrrroName=$pro->P_En_Name;
                                    $UniiName=$pro->Unit()->first()->NameEn;


                                }
                                $output .='

                  <div class="col-md-2">
                  <div class="product">
                     <div class="row">
                        <div class="col-md-6 col-6 text-center">
                            '.$img.'
                          <!-- The Modal -->
<div id="myModal'.$pro->id.'" class="modal-img">
  <span class="close-img" id="close'.$pro->id.'">&times;</span>
  <img class="modal-content" id="img'.$pro->id.'">
  <div id="caption'.$pro->id.'"></div>
</div>
       <h6 style="color:#82b0ee;text-align: center;font-size:140%;margin: 5px 0 0 0;">'.$UniiName.' </h6>
                           <p style="color:blue; text-align: center;font-size:140%;"> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                           <h5>'.$PrrroName.' </h5>
                           <br>
                           <p class="price">'.trans('admin.Price').': <span>'.$priceX.'</span></p>

                        </div>
                     </div>
                  </div>
               </div>


    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';





                            }

                        }elseif($brand == '' and $group == ''){


                            if(!empty($pro->Product()->first()->Image)){
                                $img='<img onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.URL::to($pro->Product()->first()->Image).'" alt="">';
                            }else{
                                $img='<img  onclick="OPEN('.$pro->id.')" id="myImg'.$pro->id.'" src="'.asset('Admin/img/demo/gallery/5.jpg').'" alt="">';
                            }


                            $price=$pro->Price;


                            if(!empty($pro->Product()->first()->Ar_Desc)){

                                if(app()->getLocale() == 'ar' ){
                                    $Desc=$pro->Product()->first()->Ar_Desc;
                                }else{

                                    $Desc=$pro->Product()->first()->En_Desc;
                                }


                            }else{
                                $Desc='';
                            }




                            $priceX=$price;


                            if(app()->getLocale() == 'ar' ){
                                $PrrroName=$pro->P_Ar_Name;
                                $UniiName=$pro->Unit()->first()->Name;


                            }else{
                                $PrrroName=$pro->P_En_Name;
                                $UniiName=$pro->Unit()->first()->NameEn;


                            }
                            $output .='

                  <div class="col-md-2">
                  <div class="product">
                     <div class="row">
                        <div class="col-md-6 col-6 text-center">
                            '.$img.'
                          <!-- The Modal -->
<div id="myModal'.$pro->id.'" class="modal-img">
  <span class="close-img" id="close'.$pro->id.'">&times;</span>
  <img class="modal-content" id="img'.$pro->id.'">
  <div id="caption'.$pro->id.'"></div>
</div>
       <h6 style="color:#82b0ee;text-align: center;font-size:140%;margin: 5px 0 0 0;">'.$UniiName.' </h6>
                           <p style="color:blue; text-align: center;font-size:140%;"> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description'.$pro->id.'"> '.trans('admin.Desc').'</button></p>
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                           <h5>'.$PrrroName.' </h5>
                           <br>
                           <p class="price">'.trans('admin.Price').': <span>'.$priceX.'</span></p>

                        </div>
                     </div>
                  </div>
               </div>


    <div class="modal fade" id="description'.$pro->id.'" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        '.trans('admin.Desc').'
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
           '.$Desc.'
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>





             ';




                        }

                    }


                }

            }else
            {
                $output = '
        <div class="col-md-12"> '.trans('admin.No_Data_Find').'</div>
       ';
            }
            $data = array(
                'table_data'  => $output,
            );
            echo json_encode($data);
        }
    }


//ReSubscribtion =============================

    public function ReSubscribtion(){

        return view('ReSubscribtion');
    }


    //Top Menu  ======================================================

    public function KlarAdmin(){


        //Sales
        $SalesJan=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesFeb=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMar=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesApr=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMay=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesJun=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesJul=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesAug=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesSep=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesOct=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesNov=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesDec=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');




        //Purchases
        $PurchJan=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchFeb=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMar=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Status',1)

     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchApr=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Status',1)

     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMay=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Status',1)

                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchJun=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Status',1)

                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchJul=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchAug=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Status',1)

     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchSep=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchOct=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Status',1)
     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchNov=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchDec=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Status',1)
                 ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //ReturnSales
        $ReturnSalesJan=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesFeb=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesMar=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesApr=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesMay=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesJun=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesJul=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesAug=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesSep=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesOct=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesNov=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesDec=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


//ReturnPurch
        $ReturnPurchJan=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchFeb=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchMar=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchApr=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchMay=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchJun=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchJul=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchAug=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchSep=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchOct=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchNov=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchDec=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        //Expenses
        $AMsrfoat=AcccountingManual::where('id',20)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }





        $TotalDebMasrofatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJan=  $TotalDebMasrofatJan -  $TotalCredMasrofatJan ;



        $TotalDebMasrofatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatFeb=  $TotalDebMasrofatFeb -  $TotalCredMasrofatFeb ;



        $TotalDebMasrofatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMar=  $TotalDebMasrofatMar -  $TotalCredMasrofatMar ;



        $TotalDebMasrofatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatApr=  $TotalDebMasrofatApr -  $TotalCredMasrofatApr ;



        $TotalDebMasrofatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMay=  $TotalDebMasrofatMay -  $TotalCredMasrofatMay ;



        $TotalDebMasrofatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJun=  $TotalDebMasrofatJun -  $TotalCredMasrofatJun ;


        $TotalDebMasrofatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJul=  $TotalDebMasrofatJul -  $TotalCredMasrofatJul ;




        $TotalDebMasrofatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatAug=  $TotalDebMasrofatAug -  $TotalCredMasrofatAug ;


        $TotalDebMasrofatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSep=  $TotalDebMasrofatSep -  $TotalCredMasrofatSep ;




        $TotalDebMasrofatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatOct=  $TotalDebMasrofatOct -  $TotalCredMasrofatOct ;




        $TotalDebMasrofatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatNov=  $TotalDebMasrofatNov -  $TotalCredMasrofatNov ;



        $TotalDebMasrofatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatDec=  $TotalDebMasrofatDec -  $TotalCredMasrofatDec ;



        //Vouchers
        $PaymentVoucherJan=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJan=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherFeb=GeneralDaily::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherFeb=GeneralDaily::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherMar=GeneralDaily::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMar=GeneralDaily::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');




        $PaymentVoucherApr=GeneralDaily::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherApr=GeneralDaily::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherMay=GeneralDaily::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMay=GeneralDaily::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherJun=GeneralDaily::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJun=GeneralDaily::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherJul=GeneralDaily::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJul=GeneralDaily::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherAug=GeneralDaily::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherAug=GeneralDaily::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherSep=GeneralDaily::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSep=GeneralDaily::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherOct=GeneralDaily::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherOct=GeneralDaily::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherNov=GeneralDaily::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherNov=GeneralDaily::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherDec=GeneralDaily::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherDec=GeneralDaily::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        //Checks
        $IncomChecksJan=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJan=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $IncomChecksFeb=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksFeb=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksMar=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMar=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksApr=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksApr=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksMay=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMay=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksJun=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJun=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksJul=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJul=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksAug=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksAug=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksSep=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSep=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksOct=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksOct=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksNov=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksNov=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksDec=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksDec=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
        $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
        $datemon = date("Y-m-d",strtotime('monday this week'));
        $datetue = date("Y-m-d",strtotime("tuesday this week"));
        $datewed = date("Y-m-d",strtotime("wednesday this week"));
        $datethu = date("Y-m-d",strtotime("thursday this week"));
        $datefri = date("Y-m-d",strtotime("friday this week"));


        //Sales
        $SalesSat=Sales::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesSun=Sales::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMon=Sales::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesTue=Sales::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesWed=Sales::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesThr=Sales::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesFri=Sales::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //Purchases
        $PurchSat=Purchases::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchSun=Purchases::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMon=Purchases::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchTue=Purchases::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchWed=Purchases::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchThr=Purchases::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchFri=Purchases::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //ReturnSales
        $ReturnSalesSat=ReturnSales::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnSalesSun=ReturnSales::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesMon=ReturnSales::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesTue=ReturnSales::orderBy('id','desc')
            ->where('Date',$datetue)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesWed=ReturnSales::orderBy('id','desc')
            ->where('Date',$datewed)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesThr=ReturnSales::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesFri=ReturnSales::orderBy('id','desc')
            ->where('Date',$datefri)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

//ReturnPurch
        $ReturnPurchSat=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datesat)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchSun=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchMon=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datemon)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchTue=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datetue)
   ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchWed=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datewed)
   ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchThr=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datethu)

   ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchFri=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datefri)
   ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');



        //Vouchers


        $PaymentVoucherSat=GeneralDaily::where('Date',$datesat)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSat=GeneralDaily::where('Date',$datesat)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherSun=GeneralDaily::where('Date',$datesun)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSun=GeneralDaily::where('Date',$datesun)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherMon=GeneralDaily::where('Date',$datemon)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMon=GeneralDaily::where('Date',$datemon)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherTue=GeneralDaily::where('Date',$datetue)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherTue=GeneralDaily::where('Date',$datetue)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherWed=GeneralDaily::where('Date',$datewed)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherWed=GeneralDaily::where('Date',$datewed)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherThr=GeneralDaily::where('Date',$datethu)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherThr=GeneralDaily::where('Date',$datethu)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherFri=GeneralDaily::where('Date',$datefri)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherFri=GeneralDaily::where('Date',$datefri)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');





        //Checks
        $IncomChecksSat=IncomChecks::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSat=ExportChecks::orderBy('id','desc')
            ->where('Date',$datesat)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksSun=IncomChecks::orderBy('id','desc')
            ->where('Date',$datesun)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSun=ExportChecks::orderBy('id','desc')
            ->where('Date',$datesun)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksMon=IncomChecks::orderBy('id','desc')
            ->where('Date',$datemon)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMon=ExportChecks::orderBy('id','desc')
            ->where('Date',$datemon)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksTue=IncomChecks::orderBy('id','desc')
            ->where('Date',$datetue)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksTue=ExportChecks::orderBy('id','desc')
            ->where('Date',$datetue)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksWed=IncomChecks::orderBy('id','desc')
            ->where('Date',$datewed)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksWed=ExportChecks::orderBy('id','desc')
            ->where('Date',$datewed)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksThr=IncomChecks::orderBy('id','desc')
            ->where('Date',$datethu)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksThr=ExportChecks::orderBy('id','desc')
            ->where('Date',$datethu)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksFri=IncomChecks::orderBy('id','desc')
            ->where('Date',$datefri)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksFri=ExportChecks::orderBy('id','desc')
            ->where('Date',$datefri)
                   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');




        //Expenses

        $TotalDebMasrofatSat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesat);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesat);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSat=  $TotalDebMasrofatSat -  $TotalCredMasrofatSat ;



        $TotalDebMasrofatSun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesun);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesun);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSun=  $TotalDebMasrofatSun -  $TotalCredMasrofatSun ;



        $TotalDebMasrofatMon = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datemon = date("Y-m-d",strtotime('monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datemon);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMon = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datemon = date("Y-m-d",strtotime('monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datemon);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMon=  $TotalDebMasrofatMon -  $TotalCredMasrofatMon ;



        $TotalDebMasrofatTue = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datetue = date("Y-m-d",strtotime("tuesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datetue);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatTue = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datetue = date("Y-m-d",strtotime("tuesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datetue);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatTue=  $TotalDebMasrofatTue -  $TotalCredMasrofatTue ;


        $TotalDebMasrofatWed = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datewed = date("Y-m-d",strtotime("wednesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datewed);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatWed = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datewed = date("Y-m-d",strtotime("wednesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datewed);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatWed=  $TotalDebMasrofatWed -  $TotalCredMasrofatWed ;


        $TotalDebMasrofatThr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datethu = date("Y-m-d",strtotime("thursday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datethu);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatThr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datethu = date("Y-m-d",strtotime("thursday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datethu);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatThr=  $TotalDebMasrofatThr -  $TotalCredMasrofatThr ;





        $TotalDebMasrofatFri = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datefri = date("Y-m-d",strtotime("friday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datefri);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatFri = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datefri = date("Y-m-d",strtotime("friday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datefri);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatFri=  $TotalDebMasrofatFri -  $TotalCredMasrofatFri ;




        $Y1F=date("Y-01-01",strtotime("-1 year"));
        $Y1T=date("Y-12-31",strtotime("-1 year"));


        $Y2F=date("Y-01-01",strtotime("-2 year"));
        $Y2T=date("Y-12-31",strtotime("-2 year"));


        $Y3F=date("Y-01-01",strtotime("-3 year"));
        $Y3T=date("Y-12-31",strtotime("-3 year"));


        $Y4F=date("Y-01-01",strtotime("-4 year"));
        $Y4T=date("Y-12-31",strtotime("-4 year"));



        $YCF=date("Y-01-01");
        $YCT=date("Y-12-31");



        //Sales
        $SalesPrevY1=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesPrevY2=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesPrevY3=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesPrevY4=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                     ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesPrevYC=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //Purchases
        $PurchPrevY1=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Status',1)
           ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchPrevY2=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Status',1)
           ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchPrevY3=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Status',1)
           ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchPrevY4=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Status',1)
           ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchPrevYC=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])
            ->where('Status',1)
           ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //ReturnSales
        $ReturnSalesPrevY1=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnSalesPrevY2=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesPrevY3=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesPrevY4=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesPrevYC=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');
//ReturnPurch
        $ReturnPurchPrevY1=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnPurchPrevY2=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnPurchPrevY3=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchPrevY4=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchPrevYC=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        //Expenses

        $TotalDebMasrofatY1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y1F=date("Y-01-01",strtotime("-1 year"));
                $Y1T=date("Y-12-31",strtotime("-1 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y1F,$Y1T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y1F=date("Y-01-01",strtotime("-1 year"));
                $Y1T=date("Y-12-31",strtotime("-1 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y1F,$Y1T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY1=  $TotalDebMasrofatY1 -  $TotalCredMasrofatY1 ;



        $TotalDebMasrofatY2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y2F=date("Y-01-01",strtotime("-2 year"));
                $Y2T=date("Y-12-31",strtotime("-2 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y2F,$Y2T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y2F=date("Y-01-01",strtotime("-2 year"));
                $Y2T=date("Y-12-31",strtotime("-2 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y2F,$Y2T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY2=  $TotalDebMasrofatY2 -  $TotalCredMasrofatY2 ;




        $TotalDebMasrofatY3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y3F=date("Y-01-01",strtotime("-3 year"));
                $Y3T=date("Y-12-31",strtotime("-3 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y3F,$Y3T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y3F=date("Y-01-01",strtotime("-3 year"));
                $Y3T=date("Y-12-31",strtotime("-3 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y3F,$Y3T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY3=  $TotalDebMasrofatY3 -  $TotalCredMasrofatY3 ;



        $TotalDebMasrofatY4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y4F=date("Y-01-01",strtotime("-4 year"));
                $Y4T=date("Y-12-31",strtotime("-4 year"));


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y4F,$Y4T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y4F=date("Y-01-01",strtotime("-4 year"));
                $Y4T=date("Y-12-31",strtotime("-4 year"));


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y4F,$Y4T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY4=  $TotalDebMasrofatY4 -  $TotalCredMasrofatY4 ;




        $TotalDebMasrofatCY = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $YCF=date("Y-01-01");
                $YCT=date("Y-12-31");
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$YCF,$YCT]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatCY = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $YCF=date("Y-01-01");
                $YCT=date("Y-12-31");
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$YCF,$YCT]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatCY=  $TotalDebMasrofatCY -  $TotalCredMasrofatCY ;


        // =============  Safy Rab7   ===============


        $AMsrfoat=AcccountingManual::where('id',17)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }
        $AErydaaat=AcccountingManual::where('id',18)->first();

        if($AErydaaat->Parent == 0){

            $wordsX=$AErydaaat->Code.'0';

        }else{

            $wordsX=$AErydaaat->Code;

        }


        $ATaklfaaat=AcccountingManual::where('id',19)->first();

        if($ATaklfaaat->Parent == 0){

            $wordssX=$ATaklfaaat->Code.'0';

        }else{

            $wordssX=$ATaklfaaat->Code;

        }


        $AMasroffffffffat=AcccountingManual::where('id',20)->first();

        if($AMasroffffffffat->Parent == 0){

            $wordsssX=$AMasroffffffffat->Code.'0';

        }else{

            $wordsssX=$AMasroffffffffat->Code;

        }


        $TotalDebErydatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJan=$TotalCredErydatJan - $TotalDebErydatJan  ;




        $TotalDebTaklfaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJan=$TotalDebTaklfaatJan - $TotalCredTaklfaatJan  ;


        $TotalDebMasrofaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJan=$TotalDebMasrofaatJan - $TotalCredMasrofaatJan  ;


        $fgJan= $EgmalyTaklfaatJan + $EgmalyMasrofaatJan;
        if($EgmalyErydatJan >  $fgJan){
            if($fgJan  <  0 ){

                $SafyRab7Jan =$EgmalyErydatJan + ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;
            }else{

                $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

            }
        }elseif($EgmalyErydatJan <  $fgJan){

            if($fgJan  <  0 ){

                $SafyRab7Jan =$EgmalyErydatJan + ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;
            }else{

                $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

            }


        }elseif($EgmalyErydatJan ==  $fgJan){

            $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

        }


        $TotalDebErydatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatFeb=$TotalCredErydatFeb - $TotalDebErydatFeb  ;




        $TotalDebTaklfaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatFeb=$TotalDebTaklfaatFeb - $TotalCredTaklfaatFeb  ;


        $TotalDebMasrofaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatFeb=$TotalDebMasrofaatFeb - $TotalCredMasrofaatFeb  ;


        $fgFeb= $EgmalyTaklfaatFeb + $EgmalyMasrofaatFeb;
        if($EgmalyErydatFeb >  $fgFeb){
            if($fgFeb  <  0 ){

                $SafyRab7Feb =$EgmalyErydatFeb + ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;
            }else{

                $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

            }
        }elseif($EgmalyErydatFeb <  $fgFeb){

            if($fgFeb  <  0 ){

                $SafyRab7Feb =$EgmalyErydatFeb + ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;
            }else{

                $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

            }


        }elseif($EgmalyErydatFeb ==  $fgFeb){

            $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

        }



        $TotalDebErydatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatMar=$TotalCredErydatMar - $TotalDebErydatMar  ;




        $TotalDebTaklfaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatMar=$TotalDebTaklfaatMar - $TotalCredTaklfaatMar  ;


        $TotalDebMasrofaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatMar=$TotalDebMasrofaatMar - $TotalCredMasrofaatMar  ;


        $fgMar= $EgmalyTaklfaatMar + $EgmalyMasrofaatMar;
        if($EgmalyErydatMar >  $fgMar){
            if($fgMar  <  0 ){

                $SafyRab7Mar =$EgmalyErydatMar + ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;
            }else{

                $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

            }
        }elseif($EgmalyErydatMar <  $fgMar){

            if($fgMar  <  0 ){

                $SafyRab7Mar =$EgmalyErydatMar + ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;
            }else{

                $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

            }


        }elseif($EgmalyErydatMar ==  $fgMar){

            $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

        }

        $TotalDebErydatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatApr=$TotalCredErydatApr - $TotalDebErydatApr  ;




        $TotalDebTaklfaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatApr=$TotalDebTaklfaatApr - $TotalCredTaklfaatApr  ;


        $TotalDebMasrofaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatApr=$TotalDebMasrofaatApr - $TotalCredMasrofaatApr  ;


        $fgApr= $EgmalyTaklfaatApr + $EgmalyMasrofaatApr;
        if($EgmalyErydatApr >  $fgApr){
            if($fgApr  <  0 ){

                $SafyRab7Apr =$EgmalyErydatApr + ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;
            }else{

                $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

            }
        }elseif($EgmalyErydatApr <  $fgApr){

            if($fgApr  <  0 ){

                $SafyRab7Apr =$EgmalyErydatApr + ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;
            }else{

                $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

            }


        }elseif($EgmalyErydatApr ==  $fgApr){

            $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

        }


        $TotalDebErydatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatMay=$TotalCredErydatMay - $TotalDebErydatMay  ;




        $TotalDebTaklfaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatMay=$TotalDebTaklfaatMay - $TotalCredTaklfaatMay  ;


        $TotalDebMasrofaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatMay=$TotalDebMasrofaatMay - $TotalCredMasrofaatMay  ;


        $fgMay= $EgmalyTaklfaatMay + $EgmalyMasrofaatMay;
        if($EgmalyErydatMay >  $fgMay){
            if($fgMay  <  0 ){

                $SafyRab7May =$EgmalyErydatMay + ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;
            }else{

                $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

            }
        }elseif($EgmalyErydatMay <  $fgMay){

            if($fgMay  <  0 ){

                $SafyRab7May =$EgmalyErydatMay + ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;
            }else{

                $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

            }


        }elseif($EgmalyErydatMay ==  $fgMay){

            $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

        }

        $TotalDebErydatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJun=$TotalCredErydatJun - $TotalDebErydatJun  ;




        $TotalDebTaklfaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJun=$TotalDebTaklfaatJun - $TotalCredTaklfaatJun  ;


        $TotalDebMasrofaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJun=$TotalDebMasrofaatJun - $TotalCredMasrofaatJun  ;


        $fgJun= $EgmalyTaklfaatJun + $EgmalyMasrofaatJun;
        if($EgmalyErydatJun >  $fgJun){
            if($fgJun  <  0 ){

                $SafyRab7Jun =$EgmalyErydatJun + ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;
            }else{

                $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

            }
        }elseif($EgmalyErydatJun <  $fgJun){

            if($fgJun  <  0 ){

                $SafyRab7Jun =$EgmalyErydatJun + ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;
            }else{

                $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

            }


        }elseif($EgmalyErydatJun ==  $fgJun){

            $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

        }

        $TotalDebErydatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJul=$TotalCredErydatJul - $TotalDebErydatJul  ;




        $TotalDebTaklfaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJul=$TotalDebTaklfaatJul - $TotalCredTaklfaatJul  ;


        $TotalDebMasrofaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJul=$TotalDebMasrofaatJul - $TotalCredMasrofaatJul  ;


        $fgJul= $EgmalyTaklfaatJul + $EgmalyMasrofaatJul;
        if($EgmalyErydatJul >  $fgJul){
            if($fgJul  <  0 ){

                $SafyRab7Jul =$EgmalyErydatJul + ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;
            }else{

                $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

            }
        }elseif($EgmalyErydatJul <  $fgJul){

            if($fgJul  <  0 ){

                $SafyRab7Jul =$EgmalyErydatJul + ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;
            }else{

                $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

            }


        }elseif($EgmalyErydatJul ==  $fgJul){

            $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

        }

        $TotalDebErydatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatAug=$TotalCredErydatAug - $TotalDebErydatAug  ;




        $TotalDebTaklfaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatAug=$TotalDebTaklfaatAug - $TotalCredTaklfaatAug  ;


        $TotalDebMasrofaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatAug=$TotalDebMasrofaatAug - $TotalCredMasrofaatAug  ;


        $fgAug= $EgmalyTaklfaatAug + $EgmalyMasrofaatAug;
        if($EgmalyErydatAug >  $fgAug){
            if($fgAug  <  0 ){

                $SafyRab7Aug =$EgmalyErydatAug + ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;
            }else{

                $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

            }
        }elseif($EgmalyErydatAug <  $fgAug){

            if($fgAug  <  0 ){

                $SafyRab7Aug =$EgmalyErydatAug + ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;
            }else{

                $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

            }


        }elseif($EgmalyErydatAug ==  $fgAug){

            $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

        }

        $TotalDebErydatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatSep=$TotalCredErydatSep - $TotalDebErydatSep  ;




        $TotalDebTaklfaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatSep=$TotalDebTaklfaatSep - $TotalCredTaklfaatSep  ;


        $TotalDebMasrofaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatSep=$TotalDebMasrofaatSep - $TotalCredMasrofaatSep  ;


        $fgSep= $EgmalyTaklfaatSep + $EgmalyMasrofaatSep;
        if($EgmalyErydatSep >  $fgSep){
            if($fgSep  <  0 ){

                $SafyRab7Sep =$EgmalyErydatSep + ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;
            }else{

                $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

            }
        }elseif($EgmalyErydatSep <  $fgSep){

            if($fgSep  <  0 ){

                $SafyRab7Sep =$EgmalyErydatSep + ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;
            }else{

                $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

            }


        }elseif($EgmalyErydatSep ==  $fgSep){

            $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

        }

        $TotalDebErydatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatOct=$TotalCredErydatOct - $TotalDebErydatOct  ;




        $TotalDebTaklfaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatOct=$TotalDebTaklfaatOct - $TotalCredTaklfaatOct  ;


        $TotalDebMasrofaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatOct=$TotalDebMasrofaatOct - $TotalCredMasrofaatOct  ;


        $fgOct= $EgmalyTaklfaatOct + $EgmalyMasrofaatOct;
        if($EgmalyErydatOct >  $fgOct){
            if($fgOct  <  0 ){

                $SafyRab7Oct =$EgmalyErydatOct + ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;
            }else{

                $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

            }
        }elseif($EgmalyErydatOct <  $fgOct){

            if($fgOct  <  0 ){

                $SafyRab7Oct =$EgmalyErydatOct + ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;
            }else{

                $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

            }


        }elseif($EgmalyErydatOct ==  $fgOct){

            $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

        }

        $TotalDebErydatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatNov=$TotalCredErydatNov - $TotalDebErydatNov  ;




        $TotalDebTaklfaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatNov=$TotalDebTaklfaatNov - $TotalCredTaklfaatNov  ;


        $TotalDebMasrofaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatNov=$TotalDebMasrofaatNov - $TotalCredMasrofaatNov  ;


        $fgNov= $EgmalyTaklfaatNov + $EgmalyMasrofaatNov;
        if($EgmalyErydatNov >  $fgNov){
            if($fgNov  <  0 ){

                $SafyRab7Nov =$EgmalyErydatNov + ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;
            }else{

                $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

            }
        }elseif($EgmalyErydatNov <  $fgNov){

            if($fgNov  <  0 ){

                $SafyRab7Nov =$EgmalyErydatNov + ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;
            }else{

                $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

            }


        }elseif($EgmalyErydatNov ==  $fgNov){

            $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

        }

        $TotalDebErydatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatDec=$TotalCredErydatDec - $TotalDebErydatDec  ;




        $TotalDebTaklfaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatDec=$TotalDebTaklfaatDec - $TotalCredTaklfaatDec  ;


        $TotalDebMasrofaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatDec=$TotalDebMasrofaatDec - $TotalCredMasrofaatDec  ;


        $fgDec= $EgmalyTaklfaatDec + $EgmalyMasrofaatDec;
        if($EgmalyErydatDec >  $fgDec){
            if($fgDec  <  0 ){

                $SafyRab7Dec =$EgmalyErydatDec + ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;
            }else{

                $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

            }
        }elseif($EgmalyErydatDec <  $fgDec){

            if($fgDec  <  0 ){

                $SafyRab7Dec =$EgmalyErydatDec + ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;
            }else{

                $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

            }


        }elseif($EgmalyErydatDec ==  $fgDec){

            $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

        }



        $Groups=ItemsGroups::select('Name','NameEn','id')->get();
        $Brands=Brands::select('Name','NameEn','id')->get();

        return view('admin.home',get_defined_vars());
    }

    public function BriefsAdmin(){
        return view('admin.BriefsAdmin');
    }

    public function StatisticsTotal(){



        //Sales
        $TotalSalesToday=Sales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalSalesThisMonth=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalSalesThisYear=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalSalesLast3Months=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //Purchases
        $TotalPurchasesToday=Purchases::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalPurchasesThisMonth=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalPurchasesThisYear=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalPurchasesLast3Months=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //ReturnSales

        $TotalReturnSalesToday=ReturnSales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnSalesThisMonth=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $TotalReturnSalesThisYear=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $TotalReturnSalesLast3Months=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        //ReturnPurch
        $TotalReturnPurchToday=ReturnPurch::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnPurchThisMonth=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $TotalReturnPurchThisYear=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $TotalReturnPurchLast3Months=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');




        $Q1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 3 months'));
        $Q2 = date('Y-m-d', strtotime(date('Y-04-01'). ' + 3 months'));
        $Q3 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 3 months'));
        $Q4 = date('Y-m-d', strtotime(date('Y-10-01'). ' + 3 months'));


        $H1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 6 months'));
        $H2 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 6 months'));


        //Sales
        $TotalSalesFirstQuarter=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalSalesSecondQuarter=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');
        $TotalSalesThirdQuarter=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalSalesFourthQuarter=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalSalesFirstHalf=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalSalesSecondHalf=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalSalesTodayCash=Sales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('Payment_Method','Cash')
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalSalesTodayLater=Sales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('Payment_Method','Later')
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //Purchases

        $TotalPurchasesFirstQuarter=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
            ->where('Status',1)
             ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalPurchasesSecondQuarter=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
            ->where('Status',1)
              ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalPurchasesThirdQuarter=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalPurchasesFourthQuarter=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
            ->where('Status',1)
               ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalPurchasesFirstHalf=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
            ->where('Status',1)
                  ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $TotalPurchasesSecondHalf=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
            ->where('Status',1)

               ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        $TotalPurchasesTodayCash=Purchases::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('Payment_Method','Cash')
             ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $TotalPurchasesTodayLater=Purchases::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Status',1)
            ->where('Payment_Method','Later')
             ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');




        //ReturnSales
        $TotalReturnSalesFirstQuarter=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnSalesSecondQuarter=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnSalesThirdQuarter=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnSalesFourthQuarter=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnSalesFirstHalf=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnSalesSecondHalf=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnSalesTodayCash=ReturnSales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Payment_Method','Cash')
         ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $TotalReturnSalesTodayLater=ReturnSales::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Payment_Method','Later')
         ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        //ReturnPurch
        $TotalReturnPurchFirstQuarter=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
        ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnPurchSecondQuarter=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnPurchThirdQuarter=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnPurchFourthQuarter=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
                    ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnPurchFirstHalf=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
        ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $TotalReturnPurchSecondHalf=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
         ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        $TotalReturnPurchTodayCash=ReturnPurch::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
                    ->where('Edit',0)
            ->where('Delete',0)
            ->where('Payment_Method','Cash')
            ->get()->sum('Total_Return_Value');


        $TotalReturnPurchTodayLater=ReturnPurch::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Payment_Method','Later')
        ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');



        // ======  Vouchers   ===============



        $PaymentVoucherToday=GeneralDaily::where('Date', date('Y-m-d'))
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');

        $ReciptVoucherToday=GeneralDaily::where('Date', date('Y-m-d'))
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherMonthly=GeneralDaily::whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMonthly=GeneralDaily::whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherYearly=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherYearly=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherLast3Month=GeneralDaily::whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');




        $ReciptVoucherLast3Month=GeneralDaily::whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherQ1=GeneralDaily::whereBetween('Date',[date('Y-01-01'),$Q1])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherQ1=GeneralDaily::whereBetween('Date',[date('Y-01-01'),$Q1])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');




        $PaymentVoucherQ2=GeneralDaily::whereBetween('Date',[date('Y-04-01'),$Q2])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherQ2=GeneralDaily::whereBetween('Date',[date('Y-04-01'),$Q2])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');

        $PaymentVoucherQ3=GeneralDaily::whereBetween('Date',[date('Y-07-01'),$Q3])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherQ3=GeneralDaily::whereBetween('Date',[date('Y-07-01'),$Q3])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherQ4=GeneralDaily::whereBetween('Date',[date('Y-10-01'),$Q4])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');




        $ReciptVoucherQ4=GeneralDaily::whereBetween('Date',[date('Y-10-01'),$Q4])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherH1=GeneralDaily::whereBetween('Date',[date('Y-04-01'),$H1])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherH1=GeneralDaily::whereBetween('Date',[date('Y-04-01'),$H1])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherH2=GeneralDaily::whereBetween('Date',[date('Y-07-01'),$H2])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');



        $ReciptVoucherH2=GeneralDaily::whereBetween('Date',[date('Y-07-01'),$H2])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        //InsurancePaper
        $TotalInsurancePaperToday=InsurancePaper::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalInsurancePaperThisMonth=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
                ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalInsurancePaperThisYear=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
                ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalInsurancePaperLast3Months=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
                ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalInsurancePaperFirstQuarter=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
    ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalInsurancePaperSecondQuarter=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
                ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalInsurancePaperThirdQuarter=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
                ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalInsurancePaperFourthQuarter=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
                ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalInsurancePaperFirstHalf=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
                ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalInsurancePaperSecondHalf=InsurancePaper::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
                ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalInsurancePaperCollected=InsurancePaper::orderBy('id','desc')
            ->where('Status',1)
                ->where('Delete',null)
            ->get()->sum('Amount');






        //IncomChecks
        $TotalIncomChecksToday=IncomChecks::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalIncomChecksThisMonth=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalIncomChecksThisYear=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalIncomChecksLast3Months=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalIncomChecksFirstQuarter=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
    ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalIncomChecksSecondQuarter=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalIncomChecksThirdQuarter=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalIncomChecksFourthQuarter=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalIncomChecksFirstHalf=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalIncomChecksSecondHalf=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalIncomChecksCollected=IncomChecks::orderBy('id','desc')
            ->where('Status',1)
   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        //ExportChecks
        $TotalExportChecksToday=ExportChecks::orderBy('id','desc')
            ->where('Date',date('Y-m-d'))
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalExportChecksThisMonth=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-m-01'),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalExportChecksThisYear=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalExportChecksLast3Months=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalExportChecksFirstQuarter=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),$Q1])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalExportChecksSecondQuarter=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$Q2])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalExportChecksThirdQuarter=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$Q3])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalExportChecksFourthQuarter=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),$Q4])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $TotalExportChecksFirstHalf=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),$H1])
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $TotalExportChecksSecondHalf=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),$H2])
   ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $TotalExportChecksCollected=ExportChecks::orderBy('id','desc')
            ->where('Status',1)
               ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        //Stores



        $TotalStoreCost=ProductsQty::orderBy('id','desc')
            ->get()->sum('TotalCost');


        $TotalStoreQty=ProductsQty::orderBy('id','desc')
            ->get()->sum('Qty');


//========================== Masrofat ==============
        $AMsrfoat=AcccountingManual::where('id',20)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }


        $TotalDebMasrofatToday = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',date('Y-m-d'));
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatToday = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',date('Y-m-d'));
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatToday=  $TotalDebMasrofatToday -  $TotalCredMasrofatToday ;


        $TotalDebMasrofatMonthly = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-m-01'),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMonthly = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-m-01'),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMonthly=  $TotalDebMasrofatMonthly -  $TotalCredMasrofatMonthly ;



        $TotalDebMasrofatYearly = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatYearly = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatYearly=  $TotalDebMasrofatYearly -  $TotalCredMasrofatYearly ;



        $TotalDebMasrofatLast3Month = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatLast3Month = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date("Y-m-d",strtotime("-3 Months")),date('Y-m-d')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatLast3Month=  $TotalDebMasrofatLast3Month -  $TotalCredMasrofatLast3Month ;


        $TotalDebMasrofatQ1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),$Q1]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatQ1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),$Q1]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatQ1=  $TotalDebMasrofatQ1 -  $TotalCredMasrofatQ1 ;


        $TotalDebMasrofatQ2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q2 = date('Y-m-d', strtotime(date('Y-04-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),$Q2]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatQ2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q2 = date('Y-m-d', strtotime(date('Y-04-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),$Q2]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatQ2=  $TotalDebMasrofatQ2 -  $TotalCredMasrofatQ2 ;



        $TotalDebMasrofatQ3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q3 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),$Q3]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatQ3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q3 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),$Q3]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatQ3=  $TotalDebMasrofatQ3 -  $TotalCredMasrofatQ3 ;



        $TotalDebMasrofatQ4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q4 = date('Y-m-d', strtotime(date('Y-10-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),$Q4]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatQ4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Q4 = date('Y-m-d', strtotime(date('Y-10-01'). ' + 3 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),$Q4]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatQ4=  $TotalDebMasrofatQ4 -  $TotalCredMasrofatQ4 ;



        $TotalDebMasrofatH1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $H1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 6 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),$H1]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatH1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $H1 = date('Y-m-d', strtotime(date('Y-01-01'). ' + 6 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),$H1]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatH1=  $TotalDebMasrofatH1 -  $TotalCredMasrofatH1 ;


        $TotalDebMasrofatH2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $H2 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 6 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),$H2]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatH2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $H2 = date('Y-m-d', strtotime(date('Y-07-01'). ' + 6 months'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),$H2]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatH2=  $TotalDebMasrofatH2 -  $TotalCredMasrofatH2 ;


        //Others

        $AEryd=AcccountingManual::where('id',18)->first();


        if($AEryd->Parent == 0){

            $words=$AEryd->Code.'0';

        }else{

            $words=$AEryd->Code;

        }
        $TotalDebErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $from = date('Y-01-01');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $from = date('Y-01-01');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $words.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyErydaat=  $TotalCredErydat -  $TotalDebErydat ;


        $ATaklfa=AcccountingManual::where('id',19)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }

        $TotalDebTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $from = date('Y-01-01');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $from = date('Y-01-01');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$from,$to]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');


        $EgmalyTaklfa=  $TotalDebTaklfa -  $TotalCredTaklfa ;
        $Mogml = $EgmalyErydaat   -  $EgmalyTaklfa   ;



        $ASabta=AcccountingManual::where('id',21)->first();
        if($ASabta->Parent == 0){

            $wordsSabta=$ASabta->Code.'0';

        }else{

            $wordsSabta=$ASabta->Code;

        }

        $TotalDebAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulSabta = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsSabta.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulSabta=$TotalDebAsoulSabta - $TotalCredAsoulSabta ;
        $Amtdawla=AcccountingManual::where('id',22)->first();

        if($Amtdawla->Parent == 0){

            $wordsMtdawla=$Amtdawla->Code.'0';

        }else{

            $wordsMtdawla=$Amtdawla->Code;

        }

        $TotalDebAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulMtadawla = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsMtdawla.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulMtadawla=$TotalDebAsoulMtadawla - $TotalCredAsoulMtadawla ;
        $AOther=AcccountingManual::where('id',147)->first();

        if($AOther->Parent == 0){

            $wordsOther=$AOther->Code.'0';

        }else{

            $wordsOther=$AOther->Code;

        }


        $TotalDebAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredAsoulOkhraa = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsOther.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyAsoulOkhraa=$TotalDebAsoulOkhraa - $TotalCredAsoulOkhraa ;
        $EgmalyAsoul=$EgmalyAsoulSabta + $EgmalyAsoulMtadawla + $EgmalyAsoulOkhraa ;
        $ATaklfa=AcccountingManual::where('id',16)->first();

        if($ATaklfa->Parent == 0){

            $wordss=$ATaklfa->Code.'0';

        }else{

            $wordss=$ATaklfa->Code;

        }

        $TotalDebKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoum = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoum= $TotalCredKhsoum  - $TotalDebKhsoum ;
        $ATaklfaTweel=AcccountingManual::where('id',148)->first();

        if($ATaklfaTweel->Parent == 0){

            $wordssTweel=$ATaklfaTweel->Code.'0';

        }else{

            $wordssTweel=$ATaklfaTweel->Code;

        }


        $TotalDebKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredKhsoumTweel = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssTweel.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyKhsoumTweel= $TotalCredKhsoumTweel  - $TotalDebKhsoumTweel ;
        $EgmalyKhsoumQaserr= $EgmalyKhsoum -  $EgmalyKhsoumTweel;
        $RasMal3aml=$EgmalyAsoulMtadawla - $EgmalyKhsoumQaserr;
        $Estsmar=$RasMal3aml + $EgmalyAsoulSabta + $EgmalyAsoulOkhraa ;
        $AMsrfoat=AcccountingManual::where('id',17)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }
        $AErydaaat=AcccountingManual::where('id',18)->first();

        if($AErydaaat->Parent == 0){

            $wordsX=$AErydaaat->Code.'0';

        }else{

            $wordsX=$AEryd->Code;

        }


        $ATaklfaaat=AcccountingManual::where('id',19)->first();

        if($ATaklfaaat->Parent == 0){

            $wordssX=$ATaklfaaat->Code.'0';

        }else{

            $wordssX=$ATaklfaaat->Code;

        }


        $AMasroffffffffat=AcccountingManual::where('id',20)->first();

        if($AMasroffffffffat->Parent == 0){

            $wordsssX=$AMasroffffffffat->Code.'0';

        }else{

            $wordsssX=$AMasroffffffffat->Code;

        }


        $TotalDebErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydat=$TotalCredErydat - $TotalDebErydat  ;




        $TotalDebTaklfaat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaat=$TotalDebTaklfaat - $TotalCredTaklfaat  ;


        $TotalDebMasrofaat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to =date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaat=$TotalDebMasrofaat - $TotalCredMasrofaat  ;


        $fg= $EgmalyTaklfaat + $EgmalyMasrofaat;
        if($EgmalyErydat >  $fg){
            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydat + ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;
            }else{

                $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

            }
        }elseif($EgmalyErydat <  $fg){

            if($fg  <  0 ){

                $SafyRab7 =$EgmalyErydat + ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;
            }else{

                $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

            }


        }elseif($EgmalyErydat ==  $fg){

            $SafyRab7 = $EgmalyErydat -  ($EgmalyTaklfaat  +   $EgmalyMasrofaat)  ;

        }
        $TotalDebHkook = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredHkook = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');




        $EgmalyHkook=($TotalCredHkook - $TotalDebHkook) + $SafyRab7 ;


        //Salries
        $EmpSalaries=Employess::type()->whereNotIn('id',[38,39,40,41,42])->get()->Sum('Salary');

        //Emp Count
        $EmpCount=Employess::type()->whereNotIn('id',[38,39,40,41,42])->count();


        //Safe Balnces

        $TotalDebSafes = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [28,29])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredSafes = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [28,29])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');




        $EgmalySafes=$TotalDebSafes  - $TotalCredSafes;



        //Clients Balnces
        $TotalDebClient = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [24])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredClient = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [24])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');




        $EgmalyClient=$TotalDebClient  - $TotalCredClient;


        //Vendors Balnces
        $TotalDebVendors = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [37])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredVendors = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $to = date('Y-m-d');
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date', '<=', $to);
            })

            ->whereIn('acccounting_manuals.Parent', [37])

            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');




        $EgmalyVendors=$TotalDebVendors  - $TotalCredVendors;



        return view('admin.StatisticsTotal',get_defined_vars());
    }

    public function StatisticsGraph(){



        //Sales
        $SalesJan=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesFeb=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMar=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesApr=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMay=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesJun=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesJul=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesAug=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesSep=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesOct=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesNov=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesDec=Sales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');




        //Purchases
        $PurchJan=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchFeb=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMar=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Status',1)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchApr=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Status',1)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMay=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Status',1)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchJun=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Status',1)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchJul=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchAug=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Status',1)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchSep=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchOct=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchNov=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchDec=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //ReturnSales
        $ReturnSalesJan=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesFeb=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesMar=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesApr=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesMay=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesJun=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesJul=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesAug=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesSep=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesOct=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesNov=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesDec=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


//ReturnPurch
        $ReturnPurchJan=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchFeb=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchMar=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchApr=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchMay=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchJun=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchJul=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchAug=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchSep=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchOct=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchNov=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchDec=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        //Expenses
        $AMsrfoat=AcccountingManual::where('id',20)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }





        $TotalDebMasrofatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJan=  $TotalDebMasrofatJan -  $TotalCredMasrofatJan ;



        $TotalDebMasrofatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatFeb=  $TotalDebMasrofatFeb -  $TotalCredMasrofatFeb ;



        $TotalDebMasrofatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMar=  $TotalDebMasrofatMar -  $TotalCredMasrofatMar ;



        $TotalDebMasrofatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatApr=  $TotalDebMasrofatApr -  $TotalCredMasrofatApr ;



        $TotalDebMasrofatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMay=  $TotalDebMasrofatMay -  $TotalCredMasrofatMay ;



        $TotalDebMasrofatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJun=  $TotalDebMasrofatJun -  $TotalCredMasrofatJun ;


        $TotalDebMasrofatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatJul=  $TotalDebMasrofatJul -  $TotalCredMasrofatJul ;




        $TotalDebMasrofatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatAug=  $TotalDebMasrofatAug -  $TotalCredMasrofatAug ;


        $TotalDebMasrofatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSep=  $TotalDebMasrofatSep -  $TotalCredMasrofatSep ;




        $TotalDebMasrofatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatOct=  $TotalDebMasrofatOct -  $TotalCredMasrofatOct ;




        $TotalDebMasrofatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatNov=  $TotalDebMasrofatNov -  $TotalCredMasrofatNov ;



        $TotalDebMasrofatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatDec=  $TotalDebMasrofatDec -  $TotalCredMasrofatDec ;



        //Vouchers
        $PaymentVoucherJan=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJan=GeneralDaily::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherFeb=GeneralDaily::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherFeb=GeneralDaily::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherMar=GeneralDaily::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMar=GeneralDaily::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');




        $PaymentVoucherApr=GeneralDaily::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherApr=GeneralDaily::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherMay=GeneralDaily::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMay=GeneralDaily::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherJun=GeneralDaily::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJun=GeneralDaily::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherJul=GeneralDaily::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherJul=GeneralDaily::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherAug=GeneralDaily::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherAug=GeneralDaily::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherSep=GeneralDaily::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSep=GeneralDaily::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherOct=GeneralDaily::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherOct=GeneralDaily::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherNov=GeneralDaily::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherNov=GeneralDaily::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherDec=GeneralDaily::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherDec=GeneralDaily::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        //Checks
        $IncomChecksJan=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJan=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $IncomChecksFeb=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksFeb=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksMar=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMar=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksApr=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksApr=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksMay=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMay=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksJun=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJun=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksJul=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksJul=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksAug=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksAug=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksSep=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSep=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksOct=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksOct=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksNov=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksNov=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksDec=IncomChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksDec=ExportChecks::orderBy('id','desc')
            ->whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
        $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
        $datemon = date("Y-m-d",strtotime('monday this week'));
        $datetue = date("Y-m-d",strtotime("tuesday this week"));
        $datewed = date("Y-m-d",strtotime("wednesday this week"));
        $datethu = date("Y-m-d",strtotime("thursday this week"));
        $datefri = date("Y-m-d",strtotime("friday this week"));


        //Sales
        $SalesSat=Sales::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesSun=Sales::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesMon=Sales::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesTue=Sales::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesWed=Sales::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesThr=Sales::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesFri=Sales::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //Purchases
        $PurchSat=Purchases::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchSun=Purchases::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchMon=Purchases::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchTue=Purchases::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchWed=Purchases::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchThr=Purchases::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchFri=Purchases::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //ReturnSales
        $ReturnSalesSat=ReturnSales::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnSalesSun=ReturnSales::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesMon=ReturnSales::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesTue=ReturnSales::orderBy('id','desc')
            ->where('Date',$datetue)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesWed=ReturnSales::orderBy('id','desc')
            ->where('Date',$datewed)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesThr=ReturnSales::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnSalesFri=ReturnSales::orderBy('id','desc')
            ->where('Date',$datefri)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

//ReturnPurch
        $ReturnPurchSat=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datesat)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnPurchSun=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchMon=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datemon)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchTue=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchWed=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchThr=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datethu)

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnPurchFri=ReturnPurch::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');



        //Vouchers


        $PaymentVoucherSat=GeneralDaily::where('Date',$datesat)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSat=GeneralDaily::where('Date',$datesat)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherSun=GeneralDaily::where('Date',$datesun)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherSun=GeneralDaily::where('Date',$datesun)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherMon=GeneralDaily::where('Date',$datemon)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherMon=GeneralDaily::where('Date',$datemon)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherTue=GeneralDaily::where('Date',$datetue)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherTue=GeneralDaily::where('Date',$datetue)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherWed=GeneralDaily::where('Date',$datewed)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherWed=GeneralDaily::where('Date',$datewed)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');


        $PaymentVoucherThr=GeneralDaily::where('Date',$datethu)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherThr=GeneralDaily::where('Date',$datethu)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');



        $PaymentVoucherFri=GeneralDaily::where('Date',$datefri)
            ->where('Type','سند صرف')
            ->get()->sum('Debitor_Coin');


        $ReciptVoucherFri=GeneralDaily::where('Date',$datefri)
            ->where('Type','سند قبض')
            ->get()->sum('Creditor_Coin');





        //Checks
        $IncomChecksSat=IncomChecks::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSat=ExportChecks::orderBy('id','desc')
            ->where('Date',$datesat)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksSun=IncomChecks::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksSun=ExportChecks::orderBy('id','desc')
            ->where('Date',$datesun)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksMon=IncomChecks::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksMon=ExportChecks::orderBy('id','desc')
            ->where('Date',$datemon)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksTue=IncomChecks::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksTue=ExportChecks::orderBy('id','desc')
            ->where('Date',$datetue)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksWed=IncomChecks::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksWed=ExportChecks::orderBy('id','desc')
            ->where('Date',$datewed)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');


        $IncomChecksThr=IncomChecks::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksThr=ExportChecks::orderBy('id','desc')
            ->where('Date',$datethu)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');



        $IncomChecksFri=IncomChecks::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');

        $ExportChecksFri=ExportChecks::orderBy('id','desc')
            ->where('Date',$datefri)
            ->where('Edit',null)
            ->where('Delete',null)
            ->get()->sum('Amount');




        //Expenses

        $TotalDebMasrofatSat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesat);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSat = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesat);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSat=  $TotalDebMasrofatSat -  $TotalCredMasrofatSat ;



        $TotalDebMasrofatSun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesun);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatSun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datesun);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatSun=  $TotalDebMasrofatSun -  $TotalCredMasrofatSun ;



        $TotalDebMasrofatMon = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datemon = date("Y-m-d",strtotime('monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datemon);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatMon = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datemon = date("Y-m-d",strtotime('monday this week'));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datemon);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatMon=  $TotalDebMasrofatMon -  $TotalCredMasrofatMon ;



        $TotalDebMasrofatTue = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datetue = date("Y-m-d",strtotime("tuesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datetue);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatTue = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datetue = date("Y-m-d",strtotime("tuesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datetue);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatTue=  $TotalDebMasrofatTue -  $TotalCredMasrofatTue ;


        $TotalDebMasrofatWed = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datewed = date("Y-m-d",strtotime("wednesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datewed);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatWed = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datewed = date("Y-m-d",strtotime("wednesday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datewed);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatWed=  $TotalDebMasrofatWed -  $TotalCredMasrofatWed ;


        $TotalDebMasrofatThr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datethu = date("Y-m-d",strtotime("thursday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datethu);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatThr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datethu = date("Y-m-d",strtotime("thursday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datethu);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatThr=  $TotalDebMasrofatThr -  $TotalCredMasrofatThr ;





        $TotalDebMasrofatFri = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datefri = date("Y-m-d",strtotime("friday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datefri);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatFri = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $datefri = date("Y-m-d",strtotime("friday this week"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->where('general_dailies.Date',$datefri);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatFri=  $TotalDebMasrofatFri -  $TotalCredMasrofatFri ;




        $Y1F=date("Y-01-01",strtotime("-1 year"));
        $Y1T=date("Y-12-31",strtotime("-1 year"));


        $Y2F=date("Y-01-01",strtotime("-2 year"));
        $Y2T=date("Y-12-31",strtotime("-2 year"));


        $Y3F=date("Y-01-01",strtotime("-3 year"));
        $Y3T=date("Y-12-31",strtotime("-3 year"));


        $Y4F=date("Y-01-01",strtotime("-4 year"));
        $Y4T=date("Y-12-31",strtotime("-4 year"));



        $YCF=date("Y-01-01");
        $YCT=date("Y-12-31");



        //Sales
        $SalesPrevY1=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesPrevY2=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $SalesPrevY3=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesPrevY4=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $SalesPrevYC=Sales::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])
            ->where('Status',1)
            ->where('KitchenEnd',1)->where('RecivedOrder',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');



        //Purchases
        $PurchPrevY1=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchPrevY2=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        $PurchPrevY3=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchPrevY4=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');

        $PurchPrevYC=Purchases::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])
            ->where('Status',1)
            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Net');


        //ReturnSales
        $ReturnSalesPrevY1=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnSalesPrevY2=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        $ReturnSalesPrevY3=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesPrevY4=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');

        $ReturnSalesPrevYC=ReturnSales::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');
//ReturnPurch
        $ReturnPurchPrevY1=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y1F,$Y1T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnPurchPrevY2=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y2F,$Y2T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');


        $ReturnPurchPrevY3=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y3F,$Y3T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchPrevY4=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$Y4F,$Y4T])
            ->where('Edit',0)
            ->where('Delete',0)

            ->get()->sum('Total_Return_Value');

        $ReturnPurchPrevYC=ReturnPurch::orderBy('id','desc')
            ->whereBetween('Date',[$YCF,$YCT])

            ->where('Edit',0)
            ->where('Delete',0)
            ->get()->sum('Total_Return_Value');


        //Expenses

        $TotalDebMasrofatY1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y1F=date("Y-01-01",strtotime("-1 year"));
                $Y1T=date("Y-12-31",strtotime("-1 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y1F,$Y1T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY1 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y1F=date("Y-01-01",strtotime("-1 year"));
                $Y1T=date("Y-12-31",strtotime("-1 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y1F,$Y1T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY1=  $TotalDebMasrofatY1 -  $TotalCredMasrofatY1 ;



        $TotalDebMasrofatY2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y2F=date("Y-01-01",strtotime("-2 year"));
                $Y2T=date("Y-12-31",strtotime("-2 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y2F,$Y2T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY2 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y2F=date("Y-01-01",strtotime("-2 year"));
                $Y2T=date("Y-12-31",strtotime("-2 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y2F,$Y2T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY2=  $TotalDebMasrofatY2 -  $TotalCredMasrofatY2 ;




        $TotalDebMasrofatY3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y3F=date("Y-01-01",strtotime("-3 year"));
                $Y3T=date("Y-12-31",strtotime("-3 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y3F,$Y3T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY3 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y3F=date("Y-01-01",strtotime("-3 year"));
                $Y3T=date("Y-12-31",strtotime("-3 year"));
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y3F,$Y3T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY3=  $TotalDebMasrofatY3 -  $TotalCredMasrofatY3 ;



        $TotalDebMasrofatY4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y4F=date("Y-01-01",strtotime("-4 year"));
                $Y4T=date("Y-12-31",strtotime("-4 year"));


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y4F,$Y4T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatY4 = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $Y4F=date("Y-01-01",strtotime("-4 year"));
                $Y4T=date("Y-12-31",strtotime("-4 year"));


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$Y4F,$Y4T]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatY4=  $TotalDebMasrofatY4 -  $TotalCredMasrofatY4 ;




        $TotalDebMasrofatCY = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $YCF=date("Y-01-01");
                $YCT=date("Y-12-31");
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$YCF,$YCT]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofatCY = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $YCF=date("Y-01-01");
                $YCT=date("Y-12-31");
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[$YCF,$YCT]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsss.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');



        $EgmalyMasrofatCY=  $TotalDebMasrofatCY -  $TotalCredMasrofatCY ;


        // =============  Safy Rab7   ===============


        $AMsrfoat=AcccountingManual::where('id',17)->first();

        if($AMsrfoat->Parent == 0){

            $wordsss=$AMsrfoat->Code.'0';

        }else{

            $wordsss=$AMsrfoat->Code;

        }
        $AErydaaat=AcccountingManual::where('id',18)->first();

        if($AErydaaat->Parent == 0){

            $wordsX=$AErydaaat->Code.'0';

        }else{

            $wordsX=$AErydaaat->Code;

        }


        $ATaklfaaat=AcccountingManual::where('id',19)->first();

        if($ATaklfaaat->Parent == 0){

            $wordssX=$ATaklfaaat->Code.'0';

        }else{

            $wordssX=$ATaklfaaat->Code;

        }


        $AMasroffffffffat=AcccountingManual::where('id',20)->first();

        if($AMasroffffffffat->Parent == 0){

            $wordsssX=$AMasroffffffffat->Code.'0';

        }else{

            $wordsssX=$AMasroffffffffat->Code;

        }


        $TotalDebErydatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJan=$TotalCredErydatJan - $TotalDebErydatJan  ;




        $TotalDebTaklfaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJan=$TotalDebTaklfaatJan - $TotalCredTaklfaatJan  ;


        $TotalDebMasrofaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJan = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-01-01'),date('Y-02-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJan=$TotalDebMasrofaatJan - $TotalCredMasrofaatJan  ;


        $fgJan= $EgmalyTaklfaatJan + $EgmalyMasrofaatJan;
        if($EgmalyErydatJan >  $fgJan){
            if($fgJan  <  0 ){

                $SafyRab7Jan =$EgmalyErydatJan + ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;
            }else{

                $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

            }
        }elseif($EgmalyErydatJan <  $fgJan){

            if($fgJan  <  0 ){

                $SafyRab7Jan =$EgmalyErydatJan + ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;
            }else{

                $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

            }


        }elseif($EgmalyErydatJan ==  $fgJan){

            $SafyRab7Jan = $EgmalyErydatJan -  ($EgmalyTaklfaatJan  +   $EgmalyMasrofaatJan)  ;

        }


        $TotalDebErydatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date',[date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatFeb=$TotalCredErydatFeb - $TotalDebErydatFeb  ;




        $TotalDebTaklfaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatFeb=$TotalDebTaklfaatFeb - $TotalCredTaklfaatFeb  ;


        $TotalDebMasrofaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatFeb = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-02-01'),date('Y-03-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatFeb=$TotalDebMasrofaatFeb - $TotalCredMasrofaatFeb  ;


        $fgFeb= $EgmalyTaklfaatFeb + $EgmalyMasrofaatFeb;
        if($EgmalyErydatFeb >  $fgFeb){
            if($fgFeb  <  0 ){

                $SafyRab7Feb =$EgmalyErydatFeb + ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;
            }else{

                $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

            }
        }elseif($EgmalyErydatFeb <  $fgFeb){

            if($fgFeb  <  0 ){

                $SafyRab7Feb =$EgmalyErydatFeb + ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;
            }else{

                $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

            }


        }elseif($EgmalyErydatFeb ==  $fgFeb){

            $SafyRab7Feb = $EgmalyErydatFeb -  ($EgmalyTaklfaatFeb  +   $EgmalyMasrofaatFeb)  ;

        }



        $TotalDebErydatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatMar=$TotalCredErydatMar - $TotalDebErydatMar  ;




        $TotalDebTaklfaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatMar=$TotalDebTaklfaatMar - $TotalCredTaklfaatMar  ;


        $TotalDebMasrofaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatMar = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-03-01'),date('Y-04-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatMar=$TotalDebMasrofaatMar - $TotalCredMasrofaatMar  ;


        $fgMar= $EgmalyTaklfaatMar + $EgmalyMasrofaatMar;
        if($EgmalyErydatMar >  $fgMar){
            if($fgMar  <  0 ){

                $SafyRab7Mar =$EgmalyErydatMar + ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;
            }else{

                $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

            }
        }elseif($EgmalyErydatMar <  $fgMar){

            if($fgMar  <  0 ){

                $SafyRab7Mar =$EgmalyErydatMar + ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;
            }else{

                $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

            }


        }elseif($EgmalyErydatMar ==  $fgMar){

            $SafyRab7Mar = $EgmalyErydatMar -  ($EgmalyTaklfaatMar  +   $EgmalyMasrofaatMar)  ;

        }

        $TotalDebErydatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatApr=$TotalCredErydatApr - $TotalDebErydatApr  ;




        $TotalDebTaklfaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatApr=$TotalDebTaklfaatApr - $TotalCredTaklfaatApr  ;


        $TotalDebMasrofaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatApr = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-04-01'),date('Y-05-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatApr=$TotalDebMasrofaatApr - $TotalCredMasrofaatApr  ;


        $fgApr= $EgmalyTaklfaatApr + $EgmalyMasrofaatApr;
        if($EgmalyErydatApr >  $fgApr){
            if($fgApr  <  0 ){

                $SafyRab7Apr =$EgmalyErydatApr + ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;
            }else{

                $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

            }
        }elseif($EgmalyErydatApr <  $fgApr){

            if($fgApr  <  0 ){

                $SafyRab7Apr =$EgmalyErydatApr + ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;
            }else{

                $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

            }


        }elseif($EgmalyErydatApr ==  $fgApr){

            $SafyRab7Apr = $EgmalyErydatApr -  ($EgmalyTaklfaatApr  +   $EgmalyMasrofaatApr)  ;

        }


        $TotalDebErydatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatMay=$TotalCredErydatMay - $TotalDebErydatMay  ;




        $TotalDebTaklfaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatMay=$TotalDebTaklfaatMay - $TotalCredTaklfaatMay  ;


        $TotalDebMasrofaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatMay = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-05-01'),date('Y-06-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatMay=$TotalDebMasrofaatMay - $TotalCredMasrofaatMay  ;


        $fgMay= $EgmalyTaklfaatMay + $EgmalyMasrofaatMay;
        if($EgmalyErydatMay >  $fgMay){
            if($fgMay  <  0 ){

                $SafyRab7May =$EgmalyErydatMay + ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;
            }else{

                $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

            }
        }elseif($EgmalyErydatMay <  $fgMay){

            if($fgMay  <  0 ){

                $SafyRab7May =$EgmalyErydatMay + ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;
            }else{

                $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

            }


        }elseif($EgmalyErydatMay ==  $fgMay){

            $SafyRab7May = $EgmalyErydatMay -  ($EgmalyTaklfaatMay  +   $EgmalyMasrofaatMay)  ;

        }

        $TotalDebErydatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJun=$TotalCredErydatJun - $TotalDebErydatJun  ;




        $TotalDebTaklfaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJun=$TotalDebTaklfaatJun - $TotalCredTaklfaatJun  ;


        $TotalDebMasrofaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJun = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-06-01'),date('Y-07-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJun=$TotalDebMasrofaatJun - $TotalCredMasrofaatJun  ;


        $fgJun= $EgmalyTaklfaatJun + $EgmalyMasrofaatJun;
        if($EgmalyErydatJun >  $fgJun){
            if($fgJun  <  0 ){

                $SafyRab7Jun =$EgmalyErydatJun + ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;
            }else{

                $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

            }
        }elseif($EgmalyErydatJun <  $fgJun){

            if($fgJun  <  0 ){

                $SafyRab7Jun =$EgmalyErydatJun + ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;
            }else{

                $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

            }


        }elseif($EgmalyErydatJun ==  $fgJun){

            $SafyRab7Jun = $EgmalyErydatJun -  ($EgmalyTaklfaatJun  +   $EgmalyMasrofaatJun)  ;

        }

        $TotalDebErydatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatJul=$TotalCredErydatJul - $TotalDebErydatJul  ;




        $TotalDebTaklfaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatJul=$TotalDebTaklfaatJul - $TotalCredTaklfaatJul  ;


        $TotalDebMasrofaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatJul = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-07-01'),date('Y-08-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatJul=$TotalDebMasrofaatJul - $TotalCredMasrofaatJul  ;


        $fgJul= $EgmalyTaklfaatJul + $EgmalyMasrofaatJul;
        if($EgmalyErydatJul >  $fgJul){
            if($fgJul  <  0 ){

                $SafyRab7Jul =$EgmalyErydatJul + ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;
            }else{

                $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

            }
        }elseif($EgmalyErydatJul <  $fgJul){

            if($fgJul  <  0 ){

                $SafyRab7Jul =$EgmalyErydatJul + ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;
            }else{

                $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

            }


        }elseif($EgmalyErydatJul ==  $fgJul){

            $SafyRab7Jul = $EgmalyErydatJul -  ($EgmalyTaklfaatJul  +   $EgmalyMasrofaatJul)  ;

        }

        $TotalDebErydatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatAug=$TotalCredErydatAug - $TotalDebErydatAug  ;




        $TotalDebTaklfaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatAug=$TotalDebTaklfaatAug - $TotalCredTaklfaatAug  ;


        $TotalDebMasrofaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatAug = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-08-01'),date('Y-09-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatAug=$TotalDebMasrofaatAug - $TotalCredMasrofaatAug  ;


        $fgAug= $EgmalyTaklfaatAug + $EgmalyMasrofaatAug;
        if($EgmalyErydatAug >  $fgAug){
            if($fgAug  <  0 ){

                $SafyRab7Aug =$EgmalyErydatAug + ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;
            }else{

                $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

            }
        }elseif($EgmalyErydatAug <  $fgAug){

            if($fgAug  <  0 ){

                $SafyRab7Aug =$EgmalyErydatAug + ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;
            }else{

                $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

            }


        }elseif($EgmalyErydatAug ==  $fgAug){

            $SafyRab7Aug = $EgmalyErydatAug -  ($EgmalyTaklfaatAug  +   $EgmalyMasrofaatAug)  ;

        }

        $TotalDebErydatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatSep=$TotalCredErydatSep - $TotalDebErydatSep  ;




        $TotalDebTaklfaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatSep=$TotalDebTaklfaatSep - $TotalCredTaklfaatSep  ;


        $TotalDebMasrofaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatSep = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-09-01'),date('Y-10-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatSep=$TotalDebMasrofaatSep - $TotalCredMasrofaatSep  ;


        $fgSep= $EgmalyTaklfaatSep + $EgmalyMasrofaatSep;
        if($EgmalyErydatSep >  $fgSep){
            if($fgSep  <  0 ){

                $SafyRab7Sep =$EgmalyErydatSep + ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;
            }else{

                $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

            }
        }elseif($EgmalyErydatSep <  $fgSep){

            if($fgSep  <  0 ){

                $SafyRab7Sep =$EgmalyErydatSep + ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;
            }else{

                $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

            }


        }elseif($EgmalyErydatSep ==  $fgSep){

            $SafyRab7Sep = $EgmalyErydatSep -  ($EgmalyTaklfaatSep  +   $EgmalyMasrofaatSep)  ;

        }

        $TotalDebErydatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatOct=$TotalCredErydatOct - $TotalDebErydatOct  ;




        $TotalDebTaklfaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatOct=$TotalDebTaklfaatOct - $TotalCredTaklfaatOct  ;


        $TotalDebMasrofaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatOct = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-10-01'),date('Y-11-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatOct=$TotalDebMasrofaatOct - $TotalCredMasrofaatOct  ;


        $fgOct= $EgmalyTaklfaatOct + $EgmalyMasrofaatOct;
        if($EgmalyErydatOct >  $fgOct){
            if($fgOct  <  0 ){

                $SafyRab7Oct =$EgmalyErydatOct + ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;
            }else{

                $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

            }
        }elseif($EgmalyErydatOct <  $fgOct){

            if($fgOct  <  0 ){

                $SafyRab7Oct =$EgmalyErydatOct + ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;
            }else{

                $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

            }


        }elseif($EgmalyErydatOct ==  $fgOct){

            $SafyRab7Oct = $EgmalyErydatOct -  ($EgmalyTaklfaatOct  +   $EgmalyMasrofaatOct)  ;

        }

        $TotalDebErydatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatNov=$TotalCredErydatNov - $TotalDebErydatNov  ;




        $TotalDebTaklfaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatNov=$TotalDebTaklfaatNov - $TotalCredTaklfaatNov  ;


        $TotalDebMasrofaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatNov = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-11-01'),date('Y-12-01')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatNov=$TotalDebMasrofaatNov - $TotalCredMasrofaatNov  ;


        $fgNov= $EgmalyTaklfaatNov + $EgmalyMasrofaatNov;
        if($EgmalyErydatNov >  $fgNov){
            if($fgNov  <  0 ){

                $SafyRab7Nov =$EgmalyErydatNov + ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;
            }else{

                $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

            }
        }elseif($EgmalyErydatNov <  $fgNov){

            if($fgNov  <  0 ){

                $SafyRab7Nov =$EgmalyErydatNov + ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;
            }else{

                $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

            }


        }elseif($EgmalyErydatNov ==  $fgNov){

            $SafyRab7Nov = $EgmalyErydatNov -  ($EgmalyTaklfaatNov  +   $EgmalyMasrofaatNov)  ;

        }

        $TotalDebErydatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })
            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredErydatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyErydatDec=$TotalCredErydatDec - $TotalDebErydatDec  ;




        $TotalDebTaklfaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {

                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredTaklfaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {
                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyTaklfaatDec=$TotalDebTaklfaatDec - $TotalCredTaklfaatDec  ;


        $TotalDebMasrofaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Debitor_Coin');



        $TotalCredMasrofaatDec = DB::table('acccounting_manuals')
            ->join('general_dailies', function ($join) {


                $join->on('acccounting_manuals.id', '=', 'general_dailies.Account')
                    ->whereBetween('general_dailies.Date', [date('Y-12-01'),date('Y-12-31')]);
            })

            ->where('acccounting_manuals.Code', 'like', $wordsssX.'%')
            ->where('acccounting_manuals.Type',  '=',1)
            ->get()->sum('Creditor_Coin');

        $EgmalyMasrofaatDec=$TotalDebMasrofaatDec - $TotalCredMasrofaatDec  ;


        $fgDec= $EgmalyTaklfaatDec + $EgmalyMasrofaatDec;
        if($EgmalyErydatDec >  $fgDec){
            if($fgDec  <  0 ){

                $SafyRab7Dec =$EgmalyErydatDec + ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;
            }else{

                $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

            }
        }elseif($EgmalyErydatDec <  $fgDec){

            if($fgDec  <  0 ){

                $SafyRab7Dec =$EgmalyErydatDec + ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;
            }else{

                $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

            }


        }elseif($EgmalyErydatDec ==  $fgDec){

            $SafyRab7Dec = $EgmalyErydatDec -  ($EgmalyTaklfaatDec  +   $EgmalyMasrofaatDec)  ;

        }



        $Groups=ItemsGroups::select('Name','NameEn','id')->get();
        $Brands=Brands::select('Name','NameEn','id')->get();

        return view('admin.StatisticsGraph',get_defined_vars());
    }

    public function StatisticsGraphTwo()
    {



        $salesByHourInterval = DB::select(
            "WITH all_intervals AS (
                SELECT generate_series(0, 22, 2) AS hour_start_interval
            ),
            sales_aggregated AS (
                SELECT
                    FLOOR(EXTRACT(HOUR FROM CONCAT(\"Date\", ' ', \"Time\")::timestamp) / 2) * 2 AS hour_start,
                    SUM(\"Total_Net\"::numeric) AS total_sales
                FROM sales
                GROUP BY FLOOR(EXTRACT(HOUR FROM CONCAT(\"Date\", ' ', \"Time\")::timestamp) / 2)
            )
            SELECT
                ai.hour_start_interval,
                COALESCE(sa.total_sales, 0) AS total_sales
            FROM all_intervals ai
            LEFT JOIN sales_aggregated sa ON ai.hour_start_interval = sa.hour_start
            ORDER BY ai.hour_start_interval ASC"
        );

        $formattedSales = collect($salesByHourInterval)->map(function ($item) {
            $startHour = str_pad($item->hour_start_interval, 2, '0', STR_PAD_LEFT);
            $endHour = str_pad($item->hour_start_interval + 1, 2, '0', STR_PAD_LEFT);

            if ($item->hour_start_interval == 22) {
                $endHour = '23';
            }

            return [
                'time_interval' => "{$startHour}:00 - {$endHour}:59",
                'total_sales' => $item->total_sales,
            ];
        });



        $WeeklyHours=$this->WeeklyMonthlyYearlyHours(6);
        $MonthlyHours=$this->WeeklyMonthlyYearlyHours(30);
        $YearlyHours=$this->WeeklyMonthlyYearlyHours(364);
//============================================================================
        $TotSOJan=SalesOrder::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOFeb=SalesOrder::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOMar=SalesOrder::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOApr=SalesOrder::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOMay=SalesOrder::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOJune=SalesOrder::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOJul=SalesOrder::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');


        $TotSOAug=SalesOrder::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');


        $TotSOSep=SalesOrder::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');


        $TotSOOct=SalesOrder::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSONov=SalesOrder::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSODec=SalesOrder::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');


   $TotSOJanT=SalesOrder::whereBetween('Date',[date('Y-01-01'),date('Y-02-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOFebT=SalesOrder::whereBetween('Date',[date('Y-02-01'),date('Y-03-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOMarT=SalesOrder::whereBetween('Date',[date('Y-03-01'),date('Y-04-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOAprT=SalesOrder::whereBetween('Date',[date('Y-04-01'),date('Y-05-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOMayT=SalesOrder::whereBetween('Date',[date('Y-05-01'),date('Y-06-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOJuneT=SalesOrder::whereBetween('Date',[date('Y-06-01'),date('Y-07-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOJulT=SalesOrder::whereBetween('Date',[date('Y-07-01'),date('Y-08-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');


        $TotSOAugT=SalesOrder::whereBetween('Date',[date('Y-08-01'),date('Y-09-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');


        $TotSOSepT=SalesOrder::whereBetween('Date',[date('Y-09-01'),date('Y-10-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');


        $TotSOOctT=SalesOrder::whereBetween('Date',[date('Y-10-01'),date('Y-11-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSONovT=SalesOrder::whereBetween('Date',[date('Y-11-01'),date('Y-12-01')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSODecT=SalesOrder::whereBetween('Date',[date('Y-12-01'),date('Y-12-31')])
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');


        $datesat = date("Y-m-d",strtotime('-2 day monday this week'));
        $datesun = date("Y-m-d",strtotime('-1 day monday this week'));
        $datemon = date("Y-m-d",strtotime('monday this week'));
        $datetue = date("Y-m-d",strtotime("tuesday this week"));
        $datewed = date("Y-m-d",strtotime("wednesday this week"));
        $datethu = date("Y-m-d",strtotime("thursday this week"));
        $datefri = date("Y-m-d",strtotime("friday this week"));


        $TotSOSat=SalesOrder::where('Date',$datesat)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOSun=SalesOrder::where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOSMon=SalesOrder::where('Date',$datemon)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOTue=SalesOrder::where('Date',$datetue)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOWed=SalesOrder::where('Date',$datewed)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOThu=SalesOrder::where('Date',$datethu)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');

        $TotSOFri=SalesOrder::where('Date',$datefri)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales','!=',1)
            ->get()->sum('Total_Net');


        $TotSOSatT=SalesOrder::where('Date',$datesat)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOSunT=SalesOrder::where('Date',$datesun)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOSMonT=SalesOrder::where('Date',$datemon)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOTueT=SalesOrder::where('Date',$datetue)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOWedT=SalesOrder::where('Date',$datewed)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOThuT=SalesOrder::where('Date',$datethu)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');

        $TotSOFriT=SalesOrder::where('Date',$datefri)
            ->where('Edit',0)
            ->where('Delete',0)
            ->where('ToSales',1)
            ->get()->sum('Total_Net');


//============================================================================
        $startOfWeek = Carbon::now()->startOfWeek(Carbon::SATURDAY);
        $endOfWeek = Carbon::now()->endOfWeek(Carbon::FRIDAY);

        $currentWeekCustomers = DB::table('customers')
            ->whereBetween('created_at', [$startOfWeek, $endOfWeek])
            ->count();

        $startOfMonth = Carbon::now()->startOfMonth();
        $endOfMonth = Carbon::now()->endOfMonth();

        $currentMonthCustomers = DB::table('customers')
            ->whereBetween('created_at', [$startOfMonth, $endOfMonth])
            ->count();


        $startOfYear = Carbon::now()->startOfYear();
        $endOfYear = Carbon::now()->endOfYear();

        $currentYearCustomers = DB::table('customers')
            ->whereBetween('created_at', [$startOfYear, $endOfYear])
            ->count();


        //============================================================================

        //Most Sales Products All
        // تحديد بداية ونهاية السنة الحالية
        $currentYear = Carbon::now()->year; // مثلاً 2025
        $startDate = Carbon::create($currentYear, 1, 1, 0, 0, 0)->toDateString(); // 2025-01-01
        $endDate = Carbon::create($currentYear, 12, 31, 23, 59, 59)->toDateString(); // 2025-12-31

        $topSellingProducts =$this->MostSalesProduct($startDate,$endDate);

        //Most Sales Products Monthly

        $startOfMonth = Carbon::now()->startOfMonth()->toDateString();
        $endOfMonth = Carbon::now()->endOfMonth()->toDateString();

        $topSellingProductsMonthly =$this->MostSalesProduct($startOfMonth,$endOfMonth);

        //Less Sales Products All

        $lessSalesProducts=$this->LessSalesProduct();

        // =======================================

        $topSellingCustomers = DB::table('customers')
            ->select(
                DB::raw('"customers"."Name" as customer_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'customers.Account', '=', 'sales.Client')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            // ->whereBetween('sales.Date', [$startDate, $endDate])
            ->groupBy(DB::raw('"customers"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(10)
            ->get();

        $topSellingCustomersM = DB::table('customers')
            ->select(
                DB::raw('"customers"."Name" as customer_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'customers.Account', '=', 'sales.Client')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
             ->whereBetween('sales.Date', [$startOfMonth, $endOfMonth])
            ->groupBy(DB::raw('"customers"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(10)
            ->get();

        $LessSellingCustomers = DB::table('customers')
            ->select(
                DB::raw('"customers"."Name" as customer_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'customers.Account', '=', 'sales.Client')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            ->groupBy(DB::raw('"customers"."Name"'))

            ->orderBy('total_revenue', 'asc')

            ->limit(10)
            ->get();

        //=======================================================

        //Stores

        $topSellingStores = DB::table('stores')
            ->select(
                DB::raw('"stores"."Name" as store_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'stores.id', '=', 'sales.Store')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            // ->whereBetween('sales.Date', [$startDate, $endDate])
            ->groupBy(DB::raw('"stores"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(5)
            ->get();

        $topSellingStoresM = DB::table('stores')
            ->select(
                DB::raw('"stores"."Name" as store_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'stores.id', '=', 'sales.Store')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            ->whereBetween('sales.Date', [$startOfMonth, $endOfMonth])
            ->groupBy(DB::raw('"stores"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(5)
            ->get();

        $LessSellingStores = DB::table('stores')
            ->select(
                DB::raw('"stores"."Name" as store_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'stores.id', '=', 'sales.Store')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            // ->whereBetween('sales.Date', [$startDate, $endDate])
            ->groupBy(DB::raw('"stores"."Name"'))


            ->orderBy('total_sales_count', 'asc')

            ->limit(5)
            ->get();

        //=================================================


        //Delegate
        $topSellingDelegate = DB::table('employesses')
            ->select(
                DB::raw('"employesses"."Name" as emp_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'employesses.id', '=', 'sales.Delegate')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            //  ->whereBetween('sales.Date', [$startOfMonth, $endOfMonth])
            ->groupBy(DB::raw('"employesses"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(10)
            ->get();

        $topSellingDelegateM = DB::table('employesses')
            ->select(
                DB::raw('"employesses"."Name" as emp_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'employesses.id', '=', 'sales.Delegate')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            ->whereBetween('sales.Date', [$startOfMonth, $endOfMonth])
            ->groupBy(DB::raw('"employesses"."Name"'))

            ->havingRaw('SUM("sales"."Total_Net"::numeric) > 0')

            ->orderBy('total_revenue', 'desc')

            ->limit(10)
            ->get();

        $LessSellingDelegate = DB::table('employesses')
            ->select(
                DB::raw('"employesses"."Name" as emp_name'),
                DB::raw('SUM("sales"."Total_Net"::numeric) as total_revenue'),
                DB::raw('COUNT(sales.id) as total_sales_count')
            )
            ->join('sales', 'employesses.id', '=', 'sales.Delegate')
            ->where('sales.Edit', 0)
            ->where('sales.Delete', 0)
            //  ->whereBetween('sales.Date', [$startOfMonth, $endOfMonth])
            ->groupBy(DB::raw('"employesses"."Name"'))


            ->orderBy('total_sales_count', 'asc')

            ->limit(10)
            ->get();

        //=================================================================

        //Purchases Products
                $topPurchProducts =$this->MostPurchProduct($startDate,$endDate);
                $LessPurchProducts =$this->LessPurchProduct();


                //=========================

        $AppSales=$this->AppsSales($startDate,$endDate);

        return view('admin.StatisticsGraphTwo',get_defined_vars());
    }

    private function WeeklyMonthlyYearlyHours($Days)
    {
        $endDate = Carbon::yesterday()->toDateString();
        $startDate = Carbon::yesterday()->subDays($Days)->toDateString();

        $salesByHourInterval = DB::select(
            "WITH all_intervals AS (
                SELECT generate_series(0, 22, 2) AS hour_start_interval
            ),
            sales_aggregated AS (
                SELECT
                    FLOOR(EXTRACT(HOUR FROM CONCAT(\"Date\", ' ', \"Time\")::timestamp) / 2) * 2 AS hour_start,
                    SUM(\"Total_Net\"::numeric) AS total_sales
                FROM sales
                WHERE \"Date\" BETWEEN ? AND ?
                GROUP BY FLOOR(EXTRACT(HOUR FROM CONCAT(\"Date\", ' ', \"Time\")::timestamp) / 2)
            )
            SELECT
                ai.hour_start_interval,
                COALESCE(sa.total_sales, 0) AS total_sales
            FROM all_intervals ai
            LEFT JOIN sales_aggregated sa ON ai.hour_start_interval = sa.hour_start
            ORDER BY ai.hour_start_interval ASC",
            [$startDate, $endDate]
        );

        $formattedSales = collect($salesByHourInterval)->map(function ($item) {
            $startHour = str_pad($item->hour_start_interval, 2, '0', STR_PAD_LEFT);
            $endHour = str_pad($item->hour_start_interval + 1, 2, '0', STR_PAD_LEFT);

            if ($item->hour_start_interval == 22) {
                $endHour = '23';
            }

            return [
                'time_interval' => "{$startHour}:00 - {$endHour}:59",
                'total_sales' => $item->total_sales,
            ];
        });

        return $formattedSales ;
    }

    private function MostSalesProduct($startDate,$endDate)
    {
        // تحديد بداية ونهاية السنة الحالية

        $allProductsSales = DB::table('products') // نبدأ من جدول 'products' لضمان إحضار كل المنتجات
        ->select(
            DB::raw('"products"."P_Ar_Name" as product_name'),
            // COALESCE لتحويل NULL إلى 0 لو مفيش مبيعات للمنتج
            DB::raw('COALESCE(SUM("product_sales"."Qty"::numeric), 0) as total_quantity_sold'),
            DB::raw('COALESCE(SUM("product_sales"."Total_Net"::numeric), 0) as total_revenue')
        )
            // نستخدم LEFT JOIN لربط المنتجات بسجلات مبيعاتها
            // ده بيضمن ظهور كل المنتجات حتى لو مفيش ليها مبيعات
            ->leftJoin('product_sales', 'products.id', '=', 'product_sales.Product')
            // LEFT JOIN لربط سجلات المبيعات بجدول Sales عشان شروط الـ "Edit" و "Delete"
            // تأكد من اسم العمود اللي بيربط product_sales بـ sales (مفترضينه "sale_id" أو "Sales")
            ->leftJoin('sales', 'product_sales.Sales', '=', 'sales.id') // استخدم "Sales" كما في الكود السابق أو "sale_id" لو هو الأصح

            // شروط الفلترة: إما أن المنتج ليس لديه مبيعات (product_sales.id يكون NULL)
            // أو أن لديه مبيعات وشروط "Edit" و "Delete" مطبقة
            ->where(function ($query) use ($startDate, $endDate) {
                $query->whereNull('product_sales.id') // المنتجات اللي ملهاش مبيعات خالص
                ->orWhere(function ($q) use ($startDate, $endDate) {
                    $q->where('sales.Edit', 0)
                        ->where('sales.Delete', 0)
                        // فلترة المبيعات للشهر الحالي فقط
                        ->whereBetween('product_sales.Date', [$startDate, $endDate]);
                });
            })
            // تجميع النتائج حسب اسم المنتج
            ->groupBy('products.P_Ar_Name')
            // الترتيب تصاعدي (الأقل مبيعاً) عشان تشوف اللي بصفر فوق أو تنازلي لو عايز الأكثر أولاً
            ->orderBy('total_quantity_sold', 'desc') // ممكن تغيرها لـ 'desc' لو عايز الأكثر مبيعاً
             ->limit(10)
            ->get();
        return $allProductsSales ;
    }

    public function LessSalesProduct()
    {
        $topSellingProducts = Products::query() // بدأنا الـ Query من الـ Product Model
        ->select(
        // اسم المنتج من جدول products، استخدام DB::raw لضمان التنصيص الصحيح
            DB::raw('"products"."P_Ar_Name" as product_name'),
            // مجموع الكميات المبيعة، COALESCE لتحويل NULL إلى 0 لو مفيش مبيعات
            DB::raw('COALESCE(SUM("product_sales"."Qty"::numeric), 0) as total_quantity_sold'),
            // مجموع قيمة المبيعات، COALESCE لتحويل NULL إلى 0 لو مفيش مبيعات
            DB::raw('COALESCE(SUM("product_sales"."Total_Net"::numeric), 0) as total_revenue')
        )
            // ربط "products" بـ "product_sales" باستخدام LEFT JOIN لضمان ظهور كل المنتجات
            // تأكد من تنصيص عمود "Product" في product_sales
            ->leftJoin('product_sales', 'products.id', '=', 'product_sales.Product')
            // ربط "product_sales" بـ "sales" باستخدام LEFT JOIN عشان شرط Edit/Delete
            // تأكد من اسم العمود اللي بيربط product_sales بـ sales (لو اسمه "Sales" بالفعل)
            ->leftJoin('sales', 'product_sales.Sales', '=', 'sales.id') // تنصيص "Sales" هنا

            // شروط الفلترة على جدول 'sales'
            ->where(function ($query) {
                // إما أن المنتج ليس لديه أي مبيعات (product_sales.id يكون NULL)
                $query->whereNull('product_sales.id')
                    // أو أن لديه مبيعات وشروط Edit/Delete مطبقة على الـ Sale اللي مربوطة به
                    ->orWhere(function ($q) {
                        // تأكد من تنصيص عمودي "Edit" و "Delete" في sales
                        $q->where('sales.Edit', 0)
                            ->where('sales.Delete', 0);
                    });
            })
            // تجميع النتائج حسب اسم المنتج، مع تنصيص P_Ar_Name
            ->groupBy('products.P_Ar_Name') // تنصيص "P_Ar_Name" هنا
            // الترتيب تصاعدي (الأقل مبيعًا)
            ->orderBy('total_quantity_sold', 'asc')
            // تحديد أقل 10 أصناف
            ->limit(10)
            ->get();

        return $topSellingProducts ;
    }

    private function MostPurchProduct($startDate,$endDate)
    {

        $allProductsPurchases = DB::table('products')
            ->select(
                DB::raw('"products"."P_Ar_Name" as product_name'),
                DB::raw('COALESCE(SUM("products_purchases"."Qty"::numeric), 0) as total_quantity_sold'),
                DB::raw('COALESCE(SUM("products_purchases"."Total_Net"::numeric), 0) as total_revenue')
            )
            ->leftJoin('products_purchases', 'products.id', '=', 'products_purchases.Product')
            ->leftJoin('purchases', 'products_purchases.Purchase', '=', 'purchases.id')
            ->where(function ($query) use ($startDate, $endDate) {
                $query->whereNull('products_purchases.id')
                    ->orWhere(function ($q) use ($startDate, $endDate) {
                        // **THE FIX IS HERE: Ensure these reference 'purchases' table**
                        $q->where('purchases.Edit', 0)   // <--- Corrected to 'purchases'
                        ->where('purchases.Delete', 0) // <--- Corrected to 'purchases'
                        ->whereBetween('products_purchases.Date', [$startDate, $endDate]);
                    });
            })
            // PostgreSQL case sensitivity for column names might require quoting here too
            ->groupBy(DB::raw('"products"."P_Ar_Name"')) // Ensure proper quoting for P_Ar_Name if mixed case
            ->orderBy('total_quantity_sold', 'desc')
            ->limit(10) // Or remove limit if you want all
            ->get();
        return $allProductsPurchases ;
    }

    public function LessPurchProduct()
    {
        $topSellingProducts = Products::query() // بدأنا الـ Query من الـ Product Model
        ->select(
        // اسم المنتج من جدول products، استخدام DB::raw لضمان التنصيص الصحيح
            DB::raw('"products"."P_Ar_Name" as product_name'),
            // مجموع الكميات المبيعة، COALESCE لتحويل NULL إلى 0 لو مفيش مبيعات
            DB::raw('COALESCE(SUM("products_purchases"."Qty"::numeric), 0) as total_quantity_sold'),
            // مجموع قيمة المبيعات، COALESCE لتحويل NULL إلى 0 لو مفيش مبيعات
            DB::raw('COALESCE(SUM("products_purchases"."Total_Net"::numeric), 0) as total_revenue')
        )
            // ربط "products" بـ "product_sales" باستخدام LEFT JOIN لضمان ظهور كل المنتجات
            // تأكد من تنصيص عمود "Product" في product_sales
            ->leftJoin('products_purchases', 'products.id', '=', 'products_purchases.Product')

            ->leftJoin('purchases', 'products_purchases.Purchase', '=', 'purchases.id')

            // شروط الفلترة على جدول 'sales'
            ->where(function ($query) {
                // إما أن المنتج ليس لديه أي مبيعات (product_sales.id يكون NULL)
                $query->whereNull('products_purchases.id')
                    // أو أن لديه مبيعات وشروط Edit/Delete مطبقة على الـ Sale اللي مربوطة به
                    ->orWhere(function ($q) {
                        // تأكد من تنصيص عمودي "Edit" و "Delete" في sales
                        $q->where('purchases.Edit', 0)
                            ->where('purchases.Delete', 0);
                    });
            })
            // تجميع النتائج حسب اسم المنتج، مع تنصيص P_Ar_Name
            ->groupBy('products.P_Ar_Name') // تنصيص "P_Ar_Name" هنا
            // الترتيب تصاعدي (الأقل مبيعًا)
            ->orderBy('total_quantity_sold', 'asc')
            // تحديد أقل 10 أصناف
            ->limit(10)
            ->get();

        return $topSellingProducts ;
    }


    private function AppsSales($startDate,$endDate)
    {

        $topSellingCustomers = DB::table('delivery_apps')
            ->select(
                DB::raw('"delivery_apps"."Arabic_Name" as app_name'),
                DB::raw('COALESCE(SUM("sales"."Total_Net"::numeric), 0) as total_revenue')
            )
            ->leftJoin('sales', 'delivery_apps.id', '=', 'sales.App')

            ->where(function ($query) use ($startDate, $endDate) {
                $query->whereNull('sales.id')
                    ->orWhere(function ($q) use ($startDate, $endDate) {
                        // **THE FIX IS HERE: Ensure these reference 'purchases' table**
                        $q->where('sales.Edit', 0)   // <--- Corrected to 'purchases'
                        ->where('sales.Delete', 0) // <--- Corrected to 'purchases'
                        ->where('sales.Payment_Method', 'Apps') // <--- Corrected to 'purchases'
                        ->whereBetween('sales.Date', [$startDate, $endDate]);
                    });
            })

            ->groupBy(DB::raw('"delivery_apps"."Arabic_Name"')) // Ensure proper quoting for P_Ar_Name if mixed case
            ->orderBy('total_revenue', 'desc')
            ->limit(5) // Or remove limit if you want all
            ->get();
        return $topSellingCustomers ;
    }




    //Calendar
    public function CalendarMeet(){

        $Months=date("Y-m-d", strtotime("-3 Months"));

        if(auth()->guard('admin')->user()->emp == 0){
            $events = Event::where('End_Date','>=',$Months)->get();
        }else{

            $events = Event::where('End_Date','>=',$Months)->where('Emp',auth()->guard('admin')->user()->emp)->get();
        }
        $event_list = [];
        foreach ($events as $key => $event) {
            if(app()->getLocale() == 'ar'){
                $NAme=$event->Event_Ar_Name;
            }else{
                $NAme=$event->Event_En_Name;
            }


            if(!empty($event->Emp)){

                if(app()->getLocale() == 'ar'){

                    if(!empty($event->Emp()->first()->Name)){
                        $EmpName=$event->Emp()->first()->Name;
                    }else{
                        $EmpName='';
                    }

                }else{
                    if(!empty($event->Emp()->first()->NameEn)){
                        $EmpName=$event->Emp()->first()->NameEn;
                    }else{
                        $EmpName='';
                    }
                }



            }else{

                $EmpName='';

            }


            if(!empty($event->Client)){

                if(app()->getLocale() == 'ar'){

                    if(!empty($event->Client()->first()->Name)){
                        $AccName=$event->Client()->first()->Name;
                    }else{
                        $AccName='';
                    }


                }else{
                    if(!empty($event->Client()->first()->NameEn)){
                        $AccName=$event->Client()->first()->NameEn;
                    }else{
                        $AccName='';
                    }

                }



            }else{

                $AccName='';

            }


            if(!empty($event->Product)){

                if(app()->getLocale() == 'ar'){

                    if(!empty($event->Product()->first()->P_Ar_Name)){
                        $ProName=$event->Product()->first()->P_Ar_Name;
                    }else{
                        $ProName='';
                    }



                }else{
                    if(!empty($event->Product()->first()->P_En_Name)){
                        $ProName=$event->Product()->first()->P_En_Name;
                    }else{
                        $ProName='';
                    }

                }



            }else{

                $ProName='';

            }





            $event_list[] = Calendar::event(
                $NAme.' '.'('.$event->Type_Code .')'.' '.'('. $EmpName .')'.' '.'('. $AccName .')'.' '.'('. $ProName .')',
                true,
                new \DateTime($event->Start_Date),
                new \DateTime($event->End_Date.' +1 day')
            );
        }
        $calendar_details = Calendar::addEvents($event_list);


        return view('admin.CalendarMeet',['calendar_details'=>$calendar_details]);
    }

    //Send Mails
    public function SendMails(){
        $Customers=Customers::all();
        $Groups=CustomersGroup::all();

        return view('admin.SendMail',get_defined_vars());
    }

    public function PostSendMails(){

        try {
            DB::beginTransaction();


            $data= $this->validate(request(),[
                'Message'=>'required',
            ],[
            ]);

            $Group=request('Group');
            $Client=request('Client');
            $Message=request('Message');



            if(!empty($Client)){

                for($i=0; $i < count($Client); $i++) {

                    $user = Customers::find($Client[$i]);


                    if (!empty($user->email)) {


                        Mail::to($user->email)->send(new CliendSendMail(['data' => $Message,'Name'=>$user->Name]));

                    }
                }



            }else{

                $users = Customers::where('Group',$Group)->get();

                foreach($users as $user){

                    if (!empty($user->email)) {

                        Mail::to($user->email)->send(new CliendSendMail(['data' => $Message,'Name'=>$user->Name]));

                    }

                }


            }







            session()->flash('success',trans('admin.Send_Successfully'));

            DB::commit();
            return back();

        }catch(\Exception $ex){

            $MODEL=IncomChecks::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }catch(\Error $ex){


            $MODEL=IncomChecks::class;
            DB::rollBack();
            Log::channel('custom')->error(' Model => '.$MODEL.' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

            session()->flash('error',trans('admin.There_is_Something_Wrong_Happen'));
            return back();

        }




    }


}
