<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AddJournalizingEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public $requests;
    public $status;
    public $type;
    public $type_ar;
    public $type_en;
    public $custom;
    public $custom_data;

    
   public function __construct($requests ,$status, $type , $type_ar ,$type_en , $custom , $custom_data)
    {
        $this->requests = $requests;
        $this->status = $status;
        $this->type = $type;
        $this->type_ar = $type_ar;
        $this->type_en = $type_en;
        $this->custom = $custom;
        $this->custom_data = $custom_data;

    }

 
    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
