<?php

namespace App\Console\Commands;
use App\Models\CompanyData;
use Illuminate\Support\Facades\Log;
use Illuminate\Console\Command;
use Spatie\DbDumper\Databases\PostgreSql;
use DB;
class DB_Backup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'DB:BACKUP';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Database Backup Daily';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

             @ini_set('max_execution_time', 0);
		@set_time_limit(0);
        ini_set('memory_limit', '-1');

        try {
            DB::beginTransaction();

            $def=CompanyData::orderBy('id','desc')->first();

            $backup_name = $def->Name.'-Rabih-' . date('c')  . '.sql';

            PostgreSql::create()
                ->setDbName(env('DB_DATABASE'))
                ->setUserName(env('DB_USERNAME'))
                ->setPassword(env('DB_PASSWORD'))
                ->dumpToFile($backup_name);

            DB::commit();

       

        }catch(\Exception $ex){


            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

 

        }catch(\Error $ex){



            DB::rollBack();
            Log::channel('custom')->error(' Message => '. $ex->getMessage() ." Line => ".$ex->getLine() . "\n");

        

        }


    }
}
